/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.sink;

import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.net.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.org.slf4j.Logger;
import org.apache.flink.connector.nebula.shaded.org.slf4j.LoggerFactory;
import org.apache.flink.connector.nebula.sink.NebulaBatchExecutor;
import org.apache.flink.connector.nebula.sink.NebulaRowVertexOutputFormatConverter;
import org.apache.flink.connector.nebula.statement.VertexExecutionOptions;
import org.apache.flink.connector.nebula.utils.NebulaVertex;
import org.apache.flink.connector.nebula.utils.NebulaVertices;
import org.apache.flink.connector.nebula.utils.VidTypeEnum;
import org.apache.flink.types.Row;

public class NebulaVertexBatchExecutor
implements NebulaBatchExecutor<Row> {
    private static final Logger LOG = LoggerFactory.getLogger(NebulaVertexBatchExecutor.class);
    private final VertexExecutionOptions executionOptions;
    private final List<NebulaVertex> nebulaVertexList;
    private final NebulaRowVertexOutputFormatConverter converter;

    public NebulaVertexBatchExecutor(VertexExecutionOptions executionOptions, VidTypeEnum vidType, Map<String, Integer> schema) {
        this.executionOptions = executionOptions;
        this.nebulaVertexList = new ArrayList<NebulaVertex>();
        this.converter = new NebulaRowVertexOutputFormatConverter(executionOptions, vidType, schema);
    }

    @Override
    public void addToBatch(Row record) {
        NebulaVertex vertex = this.converter.createVertex(record, this.executionOptions.getPolicy());
        if (vertex == null) {
            return;
        }
        this.nebulaVertexList.add(vertex);
    }

    @Override
    public String executeBatch(Session session) {
        if (this.nebulaVertexList.size() == 0) {
            return null;
        }
        NebulaVertices nebulaVertices = new NebulaVertices(this.executionOptions.getLabel(), this.executionOptions.getFields(), this.nebulaVertexList, this.executionOptions.getPolicy());
        String statement = null;
        switch (this.executionOptions.getWriteMode()) {
            case INSERT: {
                statement = nebulaVertices.getInsertStatement();
                break;
            }
            case UPDATE: {
                statement = nebulaVertices.getUpdateStatement();
                break;
            }
            case DELETE: {
                statement = nebulaVertices.getDeleteStatement();
                break;
            }
            default: {
                throw new IllegalArgumentException("write mode is not supported");
            }
        }
        LOG.debug("write statement={}", (Object)statement);
        ResultSet execResult = null;
        try {
            execResult = session.execute(statement);
        }
        catch (Exception e) {
            LOG.error("write data error, ", e);
            this.nebulaVertexList.clear();
            return statement;
        }
        if (!execResult.isSucceeded()) {
            LOG.error("write data failed: {}", (Object)execResult.getErrorMessage());
            this.nebulaVertexList.clear();
            return statement;
        }
        LOG.debug("write success");
        this.nebulaVertexList.clear();
        return null;
    }
}

