/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.sink;

import java.util.Map;
import java.util.function.Function;
import org.apache.flink.connector.nebula.connection.NebulaGraphConnectionProvider;
import org.apache.flink.connector.nebula.connection.NebulaMetaConnectionProvider;
import org.apache.flink.connector.nebula.sink.NebulaBatchExecutor;
import org.apache.flink.connector.nebula.sink.NebulaBatchOutputFormat;
import org.apache.flink.connector.nebula.sink.NebulaTableBufferReducedExecutor;
import org.apache.flink.connector.nebula.sink.NebulaVertexBatchExecutor;
import org.apache.flink.connector.nebula.statement.VertexExecutionOptions;
import org.apache.flink.connector.nebula.utils.VidTypeEnum;
import org.apache.flink.connector.nebula.utils.WriteModeEnum;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.Row;

public class NebulaVertexBatchTableOutputFormat
extends NebulaBatchOutputFormat<RowData, VertexExecutionOptions> {
    private final DynamicTableSink.DataStructureConverter dataStructureConverter;

    public NebulaVertexBatchTableOutputFormat(NebulaGraphConnectionProvider graphProvider, NebulaMetaConnectionProvider metaProvider, VertexExecutionOptions executionOptions, DynamicTableSink.DataStructureConverter dataStructureConverter) {
        super(graphProvider, metaProvider, executionOptions);
        this.dataStructureConverter = dataStructureConverter;
    }

    @Override
    protected NebulaBatchExecutor<RowData> createNebulaBatchExecutor() {
        VidTypeEnum vidType = this.metaProvider.getVidType(this.metaClient, ((VertexExecutionOptions)this.executionOptions).getGraphSpace());
        Map<String, Integer> schema = this.metaProvider.getTagSchema(this.metaClient, ((VertexExecutionOptions)this.executionOptions).getGraphSpace(), ((VertexExecutionOptions)this.executionOptions).getLabel());
        VertexExecutionOptions insertOptions = ((VertexExecutionOptions)this.executionOptions).toBuilder().setWriteMode(WriteModeEnum.INSERT).build();
        VertexExecutionOptions deleteOptions = ((VertexExecutionOptions)this.executionOptions).toBuilder().setWriteMode(WriteModeEnum.DELETE).build();
        return new NebulaTableBufferReducedExecutor(this.dataStructureConverter, NebulaVertexBatchTableOutputFormat.createKeyExtractor(((VertexExecutionOptions)this.executionOptions).getIdIndex()), new NebulaVertexBatchExecutor(insertOptions, vidType, schema), new NebulaVertexBatchExecutor(deleteOptions, vidType, schema));
    }

    private static Function<Row, Row> createKeyExtractor(int idIndex) {
        return row -> {
            Row key = new Row(1);
            key.setField(0, row.getField(idIndex));
            return key;
        };
    }
}

