/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.statement;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.connector.nebula.utils.DataTypeEnum;
import org.apache.flink.connector.nebula.utils.PolicyEnum;
import org.apache.flink.connector.nebula.utils.WriteModeEnum;

public abstract class ExecutionOptions
implements Serializable {
    private static final long serialVersionUID = 6958907525999542402L;
    private String graphSpace;
    private String executeStatement;
    private List<String> fields;
    private List<Integer> positions;
    private boolean noColumn;
    private int limit;
    private long startTime;
    private long endTime;
    private int batchSize;
    private PolicyEnum policy;
    private WriteModeEnum writeMode;
    private int batchIntervalMs;

    protected ExecutionOptions(String graphSpace, String executeStatement, List<String> fields, List<Integer> positions, boolean noColumn, int limit, long startTime, long endTime, int batchSize, PolicyEnum policy, WriteModeEnum writeMode, int batchIntervalMs) {
        this.graphSpace = graphSpace;
        this.executeStatement = executeStatement;
        this.fields = fields;
        this.positions = positions;
        this.noColumn = noColumn;
        this.limit = limit;
        this.startTime = startTime;
        this.endTime = endTime;
        this.batchSize = batchSize;
        this.policy = policy;
        this.writeMode = writeMode;
        this.batchIntervalMs = batchIntervalMs;
    }

    public String getGraphSpace() {
        return this.graphSpace;
    }

    public String getExecuteStatement() {
        return this.executeStatement;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<Integer> getPositions() {
        return this.positions;
    }

    public boolean isNoColumn() {
        return this.noColumn;
    }

    public int getLimit() {
        return this.limit;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Deprecated
    public int getBatch() {
        return this.batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public PolicyEnum getPolicy() {
        return this.policy;
    }

    public abstract String getLabel();

    public abstract DataTypeEnum getDataType();

    public WriteModeEnum getWriteMode() {
        return this.writeMode;
    }

    public int getBatchIntervalMs() {
        return this.batchIntervalMs;
    }

    public String toString() {
        return "ExecutionOptions{graphSpace='" + this.graphSpace + '\'' + ", executeStatement='" + this.executeStatement + '\'' + ", fields=" + this.fields + ", positions=" + this.positions + ", noColumn=" + this.noColumn + ", limit=" + this.limit + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", batchSize=" + this.batchSize + ", policy=" + (Object)((Object)this.policy) + ", mode=" + (Object)((Object)this.writeMode) + ", batchIntervalMs=" + this.batchIntervalMs + '}';
    }
}

