/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.utils;

import java.io.Serializable;
import java.util.Map;
import org.apache.flink.connector.nebula.utils.NebulaConstant;
import org.apache.flink.connector.nebula.utils.NebulaSpace;

public class NebulaSpaces
implements Serializable {
    private final NebulaSpace nebulaSpace;
    private final Map<String, String> props;

    public NebulaSpaces(NebulaSpace nebulaSpace) {
        this.nebulaSpace = nebulaSpace;
        this.props = nebulaSpace.getProps();
    }

    public String getCreateStatement() {
        Map<String, String> props = this.nebulaSpace.getProps();
        StringBuilder sb = new StringBuilder();
        this.addParams(sb, "partition_num", 100);
        this.addParams(sb, "replica_factor", 1);
        sb.append("vid_type").append(" = ").append(props.get("vid_type"));
        String stat = String.format(NebulaConstant.CREATE_SPACE_TEMPLATE, this.nebulaSpace.getSpaceName(), sb);
        String comment = this.nebulaSpace.getComment();
        if (comment != null) {
            stat = stat + String.format(NebulaConstant.CREATE_SPACE_COMMENT, comment);
        }
        return stat;
    }

    private void addParams(StringBuilder sb, String para, int defaultValue) {
        sb.append(para).append(" = ").append(this.props.containsKey(para) ? Integer.parseInt(this.props.get(para)) : defaultValue).append(", ");
    }
}

