/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.nebula.utils.DataTypeEnum;
import org.apache.flink.connector.nebula.utils.NebulaConstant;
import org.apache.flink.connector.nebula.utils.NebulaUtils;
import org.apache.flink.connector.nebula.utils.NebulaVertex;
import org.apache.flink.connector.nebula.utils.PolicyEnum;

public class NebulaVertices
implements Serializable {
    private String tagName;
    private List<String> propNames;
    private List<NebulaVertex> vertices;
    private PolicyEnum policy = null;

    public NebulaVertices(String tagName, List<String> propNames, List<NebulaVertex> vertices, PolicyEnum policy) {
        this.tagName = tagName;
        this.propNames = propNames;
        this.vertices = vertices;
        this.policy = policy;
    }

    public String getPropNames() {
        ArrayList<String> escapePropNames = new ArrayList<String>();
        for (String propName : this.propNames) {
            escapePropNames.add(NebulaUtils.mkString(propName, "`", "", "`"));
        }
        return String.join((CharSequence)",", escapePropNames);
    }

    public void setPropNames(List<String> propNames) {
        this.propNames = propNames;
    }

    public List<NebulaVertex> getVertices() {
        return this.vertices;
    }

    public void setVertices(List<NebulaVertex> vertices) {
        this.vertices = vertices;
    }

    public PolicyEnum getPolicy() {
        return this.policy;
    }

    public void setPolicy(PolicyEnum policy) {
        this.policy = policy;
    }

    public String getInsertStatement() {
        ArrayList<String> values = new ArrayList<String>();
        for (NebulaVertex vertex : this.vertices) {
            String vertexId = this.getVertexId(vertex);
            values.add(String.format(NebulaConstant.VERTEX_VALUE_TEMPLATE, vertexId, vertex.getPropValuesString()));
        }
        return String.format(NebulaConstant.BATCH_INSERT_TEMPLATE, DataTypeEnum.VERTEX.name(), this.tagName, this.getPropNames(), String.join((CharSequence)",", values));
    }

    public String getUpdateStatement() {
        ArrayList<String> statements = new ArrayList<String>();
        for (NebulaVertex vertex : this.vertices) {
            String vertexId = this.getVertexId(vertex);
            ArrayList<String> updateProps = new ArrayList<String>();
            for (int i = 0; i < this.propNames.size(); ++i) {
                updateProps.add(String.format(NebulaConstant.UPDATE_VALUE_TEMPLATE, this.propNames.get(i), vertex.getPropValues().get(i)));
            }
            String updatePropsString = String.join((CharSequence)",", updateProps);
            String statement = String.format(NebulaConstant.UPDATE_VERTEX_TEMPLATE, DataTypeEnum.VERTEX.name(), this.tagName, vertexId, updatePropsString);
            statements.add(statement);
        }
        return String.join((CharSequence)";", statements);
    }

    public String getDeleteStatement() {
        ArrayList<String> vertexIds = new ArrayList<String>();
        for (NebulaVertex vertex : this.vertices) {
            String vertexId = this.getVertexId(vertex);
            vertexIds.add(vertexId);
        }
        return String.format(NebulaConstant.DELETE_VERTEX_TEMPLATE, String.join((CharSequence)",", vertexIds));
    }

    private String getVertexId(NebulaVertex vertex) {
        String vertexId = null;
        if (this.policy == null) {
            vertexId = vertex.getVid();
        } else {
            switch (this.policy) {
                case HASH: {
                    vertexId = String.format(NebulaConstant.ENDPOINT_TEMPLATE, PolicyEnum.HASH.name(), vertex.getVid());
                    break;
                }
                case UUID: {
                    vertexId = String.format(NebulaConstant.ENDPOINT_TEMPLATE, PolicyEnum.UUID.name(), vertex.getVid());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("policy is not supported");
                }
            }
        }
        return vertexId;
    }
}

