/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;

public class SimplePointInAreaLocator {
    public static int locate(Coordinate p, Geometry geom) {
        if (geom.isEmpty()) {
            return 2;
        }
        if (SimplePointInAreaLocator.containsPoint(p, geom)) {
            return 0;
        }
        return 2;
    }

    private static boolean containsPoint(Coordinate p, Geometry geom) {
        if (geom instanceof Polygon) {
            return SimplePointInAreaLocator.containsPointInPolygon(p, (Polygon)geom);
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollectionIterator geomi = new GeometryCollectionIterator((GeometryCollection)geom);
            while (geomi.hasNext()) {
                Geometry g2 = (Geometry)geomi.next();
                if (g2 == geom || !SimplePointInAreaLocator.containsPoint(p, g2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsPointInPolygon(Coordinate p, Polygon poly) {
        if (poly.isEmpty()) {
            return false;
        }
        LinearRing shell = (LinearRing)poly.getExteriorRing();
        if (!CGAlgorithms.isPointInRing(p, shell.getCoordinates())) {
            return false;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            LinearRing hole = (LinearRing)poly.getInteriorRingN(i);
            if (!CGAlgorithms.isPointInRing(p, hole.getCoordinates())) continue;
            return false;
        }
        return true;
    }
}

