/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import com.vividsolutions.jts.simplify.DouglasPeuckerLineSimplifier;

public class DouglasPeuckerSimplifier {
    private Geometry inputGeom;
    private double distanceTolerance;

    public static Geometry simplify(Geometry geom, double distanceTolerance) {
        DouglasPeuckerSimplifier tss = new DouglasPeuckerSimplifier(geom);
        tss.setDistanceTolerance(distanceTolerance);
        return tss.getResultGeometry();
    }

    public DouglasPeuckerSimplifier(Geometry inputGeom) {
        this.inputGeom = inputGeom;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance must be non-negative");
        }
        this.distanceTolerance = distanceTolerance;
    }

    public Geometry getResultGeometry() {
        return new DPTransformer().transform(this.inputGeom);
    }

    class DPTransformer
    extends GeometryTransformer {
        DPTransformer() {
        }

        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
            Coordinate[] inputPts = coords.toCoordinateArray();
            Coordinate[] newPts = DouglasPeuckerLineSimplifier.simplify(inputPts, DouglasPeuckerSimplifier.this.distanceTolerance);
            return this.factory.getCoordinateSequenceFactory().create(newPts);
        }

        protected Geometry transformPolygon(Polygon geom, Geometry parent) {
            Geometry roughGeom = super.transformPolygon(geom, parent);
            if (parent instanceof MultiPolygon) {
                return roughGeom;
            }
            return this.createValidArea(roughGeom);
        }

        protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
            Geometry roughGeom = super.transformMultiPolygon(geom, parent);
            return this.createValidArea(roughGeom);
        }

        private Geometry createValidArea(Geometry roughAreaGeom) {
            return roughAreaGeom.buffer(0.0);
        }
    }
}

