/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.basic;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.hibernate.HibernateException;

public class Inet
implements Serializable {
    private final String address;

    public Inet(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Inet inet = (Inet)o;
        return this.address != null ? this.address.equals(inet.address) : inet.address == null;
    }

    public int hashCode() {
        return this.address != null ? this.address.hashCode() : 0;
    }

    public InetAddress toInetAddress() {
        try {
            String host = this.address.replaceAll("\\/.*$", "");
            return Inet4Address.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new HibernateException((Throwable)new IllegalArgumentException(e));
        }
    }
}

