/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.range.guava;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import com.vladmihalcea.hibernate.type.ImmutableType;
import com.vladmihalcea.hibernate.util.ReflectionUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaXMember;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.DynamicParameterizedType;
import org.postgresql.util.PGobject;

public class PostgreSQLGuavaRangeType
extends ImmutableType<Range>
implements DynamicParameterizedType {
    public static final PostgreSQLGuavaRangeType INSTANCE = new PostgreSQLGuavaRangeType();
    private Type type;

    public PostgreSQLGuavaRangeType() {
        super(Range.class);
    }

    public int[] sqlTypes() {
        return new int[]{1111};
    }

    @Override
    protected Range get(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws SQLException {
        PGobject pgObject = (PGobject)rs.getObject(names[0]);
        if (pgObject == null) {
            return null;
        }
        String type = pgObject.getType();
        String value = pgObject.getValue();
        if ("int4range".equals(type)) {
            return PostgreSQLGuavaRangeType.integerRange(value);
        }
        if ("int8range".equals(type)) {
            return PostgreSQLGuavaRangeType.longRange(value);
        }
        if ("numrange".equals(type)) {
            return PostgreSQLGuavaRangeType.bigDecimalRange(value);
        }
        throw new HibernateException((Throwable)new IllegalStateException("The range type [" + type + "] is not supported!"));
    }

    @Override
    protected void set(PreparedStatement st, Range range, int index, SessionImplementor session) throws SQLException {
        if (range == null) {
            st.setNull(index, 1111);
        } else {
            PGobject object = new PGobject();
            object.setType(PostgreSQLGuavaRangeType.determineRangeType(range));
            object.setValue(this.asString(range));
            st.setObject(index, object);
        }
    }

    private static String determineRangeType(Range<?> range) {
        Comparable anyEndpoint;
        Comparable comparable = range.hasLowerBound() ? range.lowerEndpoint() : (anyEndpoint = range.hasUpperBound() ? range.upperEndpoint() : null);
        if (anyEndpoint == null) {
            throw new HibernateException((Throwable)new IllegalArgumentException("The range " + range + " doesn't have any upper or lower bound!"));
        }
        Class<?> clazz = anyEndpoint.getClass();
        if (clazz.equals(Integer.class)) {
            return "int4range";
        }
        if (clazz.equals(Long.class)) {
            return "int8range";
        }
        if (clazz.equals(BigDecimal.class)) {
            return "numrange";
        }
        throw new HibernateException((Throwable)new IllegalStateException("The class [" + clazz.getName() + "] is not supported!"));
    }

    public static <T extends Comparable> Range<T> ofString(String str, Function<String, T> converter, Class<T> cls) {
        BoundType lowerBound = str.charAt(0) == '[' ? BoundType.CLOSED : BoundType.OPEN;
        BoundType upperBound = str.charAt(str.length() - 1) == ']' ? BoundType.CLOSED : BoundType.OPEN;
        int delim = str.indexOf(44);
        if (delim == -1) {
            throw new HibernateException((Throwable)new IllegalArgumentException("Cannot find comma character"));
        }
        String lowerStr = str.substring(1, delim);
        String upperStr = str.substring(delim + 1, str.length() - 1);
        Comparable lower = null;
        Comparable upper = null;
        if (lowerStr.length() > 0) {
            lower = (Comparable)converter.apply(lowerStr);
        }
        if (upperStr.length() > 0) {
            upper = (Comparable)converter.apply(upperStr);
        }
        if (lower == null && upper == null) {
            throw new HibernateException((Throwable)new IllegalArgumentException("Cannot find bound type"));
        }
        if (lowerStr.length() == 0) {
            return upperBound == BoundType.CLOSED ? Ranges.atMost((Comparable)upper) : Ranges.lessThan((Comparable)upper);
        }
        if (upperStr.length() == 0) {
            return lowerBound == BoundType.CLOSED ? Ranges.atLeast((Comparable)lower) : Ranges.greaterThan((Comparable)lower);
        }
        return Ranges.range((Comparable)lower, (BoundType)lowerBound, (Comparable)upper, (BoundType)upperBound);
    }

    public static Range<BigDecimal> bigDecimalRange(String range) {
        return PostgreSQLGuavaRangeType.ofString(range, new Function<String, BigDecimal>(){

            @Override
            public BigDecimal apply(String s) {
                return new BigDecimal(s);
            }
        }, BigDecimal.class);
    }

    public static Range<Integer> integerRange(String range) {
        return PostgreSQLGuavaRangeType.ofString(range, new Function<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return Integer.parseInt(s);
            }
        }, Integer.class);
    }

    public static Range<Long> longRange(String range) {
        return PostgreSQLGuavaRangeType.ofString(range, new Function<String, Long>(){

            @Override
            public Long apply(String s) {
                return Long.parseLong(s);
            }
        }, Long.class);
    }

    public String asString(Range range) {
        StringBuilder sb = new StringBuilder();
        sb.append((char)(range.hasLowerBound() && range.lowerBoundType() == BoundType.CLOSED ? 91 : 40)).append(range.hasLowerBound() ? range.lowerEndpoint().toString() : "").append(",").append(range.hasUpperBound() ? range.upperEndpoint().toString() : "").append((char)(range.hasUpperBound() && range.upperBoundType() == BoundType.CLOSED ? 93 : 41));
        return sb.toString();
    }

    public void setParameterValues(Properties parameters) {
        XProperty xProperty = (XProperty)parameters.get("org.hibernate.type.ParameterType.xproperty");
        this.type = xProperty instanceof JavaXMember ? (Type)ReflectionUtils.invokeGetter(xProperty, "javaType") : ((DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType")).getReturnedClass();
    }

    public Class<?> getElementType() {
        return this.type instanceof ParameterizedType ? (Class)((ParameterizedType)this.type).getActualTypeArguments()[0] : null;
    }

    public static interface Function<T, R> {
        public R apply(T var1);
    }
}

