/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.json.internal;

import com.vladmihalcea.hibernate.type.util.ObjectMapperWrapper;
import com.vladmihalcea.hibernate.type.util.ReflectionUtils;
import java.lang.reflect.Type;
import java.util.Properties;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaXMember;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.usertype.DynamicParameterizedType;

public class JsonTypeDescriptor
extends AbstractTypeDescriptor<Object>
implements DynamicParameterizedType {
    private Type type;
    private ObjectMapperWrapper objectMapperWrapper;

    public JsonTypeDescriptor() {
        super(Object.class, (MutabilityPlan)new MutableMutabilityPlan<Object>(){

            protected Object deepCopyNotNull(Object value) {
                return ObjectMapperWrapper.INSTANCE.clone(value);
            }
        });
    }

    public JsonTypeDescriptor(final ObjectMapperWrapper objectMapperWrapper) {
        super(Object.class, (MutabilityPlan)new MutableMutabilityPlan<Object>(){

            protected Object deepCopyNotNull(Object value) {
                return objectMapperWrapper.clone(value);
            }
        });
        this.objectMapperWrapper = objectMapperWrapper;
    }

    public JsonTypeDescriptor(final ObjectMapperWrapper objectMapperWrapper, Type type) {
        super(Object.class, (MutabilityPlan)new MutableMutabilityPlan<Object>(){

            protected Object deepCopyNotNull(Object value) {
                return objectMapperWrapper.clone(value);
            }
        });
        this.objectMapperWrapper = objectMapperWrapper;
        this.type = type;
    }

    public void setParameterValues(Properties parameters) {
        XProperty xProperty = (XProperty)parameters.get("org.hibernate.type.ParameterType.xproperty");
        this.type = xProperty instanceof JavaXMember ? (Type)ReflectionUtils.invokeGetter(xProperty, "javaType") : ((DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType")).getReturnedClass();
    }

    public boolean areEqual(Object one, Object another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        if (one instanceof String && another instanceof String) {
            return one.equals(another);
        }
        return this.objectMapperWrapper.toJsonNode(this.objectMapperWrapper.toString(one)).equals((Object)this.objectMapperWrapper.toJsonNode(this.objectMapperWrapper.toString(another)));
    }

    public String toString(Object value) {
        return this.objectMapperWrapper.toString(value);
    }

    public Object fromString(String string) {
        return this.objectMapperWrapper.fromString(string, this.type);
    }

    public <X> X unwrap(Object value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        if (Object.class.isAssignableFrom(type)) {
            return (X)this.objectMapperWrapper.toJsonNode(this.toString(value));
        }
        throw this.unknownUnwrap(type);
    }

    public <X> Object wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        return this.fromString(value.toString());
    }
}

