/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public final class ReflectionUtils {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";

    private ReflectionUtils() {
        throw new UnsupportedOperationException("The " + this.getClass() + " is not instantiable!");
    }

    public static <T> T newInstance(String className) {
        Class<T> clazz = ReflectionUtils.getClass(className);
        return ReflectionUtils.newInstance(clazz);
    }

    public static <T> T newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw ReflectionUtils.handleException(e);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(e);
        }
    }

    public static <T> T newInstance(Class clazz, Object[] args, Class[] argsTypes) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(argsTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw ReflectionUtils.handleException(e);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(e);
        }
        catch (NoSuchMethodException e) {
            throw ReflectionUtils.handleException(e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(e);
        }
    }

    public static Field getField(Class targetClass, String fieldName) {
        Field field = null;
        try {
            field = targetClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            try {
                field = targetClass.getField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (!targetClass.getSuperclass().equals(Object.class)) {
                Field field2 = ReflectionUtils.getField(targetClass.getSuperclass(), fieldName);
                return field2;
            }
            throw ReflectionUtils.handleException(e);
        }
        finally {
            if (field != null) {
                field.setAccessible(true);
            }
        }
        return field;
    }

    public static Field getFieldOrNull(Class targetClass, String fieldName) {
        try {
            return ReflectionUtils.getField(targetClass, fieldName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static <T> T getFieldValue(Object target, String fieldName) {
        try {
            Field field = ReflectionUtils.getField(target.getClass(), fieldName);
            Object returnValue = field.get(target);
            return (T)returnValue;
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(e);
        }
    }

    public static <T> T getFieldValueOrNull(Object target, String fieldName) {
        try {
            Field field = ReflectionUtils.getField(target.getClass(), fieldName);
            Object returnValue = field.get(target);
            return (T)returnValue;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static void setFieldValue(Object target, String fieldName, Object value) {
        try {
            Field field = ReflectionUtils.getField(target.getClass(), fieldName);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(e);
        }
    }

    public static Method getMethod(Object target, String methodName, Class ... parameterTypes) {
        return ReflectionUtils.getMethod(target.getClass(), methodName, parameterTypes);
    }

    public static Method getMethodOrNull(Object target, String methodName, Class ... parameterTypes) {
        try {
            return ReflectionUtils.getMethod(target.getClass(), methodName, parameterTypes);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Method getMethod(Class targetClass, String methodName, Class ... parameterTypes) {
        try {
            return targetClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            try {
                return targetClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!targetClass.getSuperclass().equals(Object.class)) {
                    return ReflectionUtils.getMethod(targetClass.getSuperclass(), methodName, parameterTypes);
                }
                throw ReflectionUtils.handleException(e);
            }
        }
    }

    public static Method getDeclaredMethodOrNull(Class targetClass, String methodName, Class ... parameterTypes) {
        try {
            return targetClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean hasMethod(Class<?> targetClass, String methodName, Class ... parameterTypes) {
        try {
            targetClass.getMethod(methodName, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static Method getSetter(Object target, String propertyName, Class<?> parameterType) {
        String setterMethodName = SETTER_PREFIX + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method setter = ReflectionUtils.getMethod(target, setterMethodName, parameterType);
        setter.setAccessible(true);
        return setter;
    }

    public static Method getGetter(Object target, String propertyName) {
        String getterMethodName = GETTER_PREFIX + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method getter = ReflectionUtils.getMethod(target, getterMethodName, new Class[0]);
        getter.setAccessible(true);
        return getter;
    }

    public static <T> T invokeMethod(Object target, Method method, Object ... parameters) {
        try {
            method.setAccessible(true);
            Object returnValue = method.invoke(target, parameters);
            return (T)returnValue;
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(e);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(e);
        }
    }

    public static <T> T invokeMethod(Object target, String methodName, Object ... parameters) {
        try {
            Class[] parameterClasses = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                parameterClasses[i] = parameters[i].getClass();
            }
            Method method = ReflectionUtils.getMethod(target, methodName, parameterClasses);
            method.setAccessible(true);
            Object returnValue = method.invoke(target, parameters);
            return (T)returnValue;
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(e);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(e);
        }
    }

    public static <T> T invokeGetter(Object target, String propertyName) {
        Method setter = ReflectionUtils.getGetter(target, propertyName);
        try {
            return (T)setter.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(e);
        }
    }

    public static void invokeSetter(Object target, String propertyName, Object parameter) {
        Method setter = ReflectionUtils.getSetter(target, propertyName, parameter.getClass());
        try {
            setter.invoke(target, parameter);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(e);
        }
    }

    public static void invokeSetter(Object target, String propertyName, boolean parameter) {
        Method setter = ReflectionUtils.getSetter(target, propertyName, Boolean.TYPE);
        try {
            setter.invoke(target, parameter);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(e);
        }
    }

    public static void invokeSetter(Object target, String propertyName, int parameter) {
        Method setter = ReflectionUtils.getSetter(target, propertyName, Integer.TYPE);
        try {
            setter.invoke(target, parameter);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(e);
        }
    }

    public static <T> T invokeStaticMethod(Method method, Object ... parameters) {
        try {
            method.setAccessible(true);
            Object returnValue = method.invoke(null, parameters);
            return (T)returnValue;
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(e);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(e);
        }
    }

    public static <T> Class<T> getClass(String className) {
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw ReflectionUtils.handleException(e);
        }
    }

    public static <T> Class<T> getClassOrNull(String className) {
        try {
            return ReflectionUtils.getClass(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> getWrapperClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public static <T> Class<T> getFirstSuperClassFromPackage(Class clazz, String packageName) {
        if (clazz.getPackage().getName().equals(packageName)) {
            return clazz;
        }
        Class superClass = clazz.getSuperclass();
        return superClass == null || superClass.equals(Object.class) ? null : ReflectionUtils.getFirstSuperClassFromPackage(superClass, packageName);
    }

    public static Member getMemberOrNull(Class targetClass, String memberName) {
        Field field = ReflectionUtils.getFieldOrNull(targetClass, memberName);
        return field != null ? field : ReflectionUtils.getMethodOrNull(targetClass, memberName, new Class[0]);
    }

    public static Type getMemberGenericTypeOrNull(Class targetClass, String memberName) {
        Field field = ReflectionUtils.getFieldOrNull(targetClass, memberName);
        return field != null ? field.getGenericType() : ReflectionUtils.getMethodOrNull(targetClass, memberName, new Class[0]).getGenericReturnType();
    }

    private static IllegalArgumentException handleException(NoSuchFieldException e) {
        return new IllegalArgumentException(e);
    }

    private static IllegalArgumentException handleException(NoSuchMethodException e) {
        return new IllegalArgumentException(e);
    }

    private static IllegalArgumentException handleException(IllegalAccessException e) {
        return new IllegalArgumentException(e);
    }

    private static IllegalArgumentException handleException(InvocationTargetException e) {
        return new IllegalArgumentException(e);
    }

    private static IllegalArgumentException handleException(ClassNotFoundException e) {
        return new IllegalArgumentException(e);
    }

    private static IllegalArgumentException handleException(InstantiationException e) {
        return new IllegalArgumentException(e);
    }
}

