/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.array.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayUtil {
    public static <T> T deepCopy(Object originalArray) {
        Class<?> arrayClass = originalArray.getClass();
        if (boolean[].class.equals(arrayClass)) {
            boolean[] array = (boolean[])originalArray;
            return (T)Arrays.copyOf(array, array.length);
        }
        if (byte[].class.equals(arrayClass)) {
            byte[] array = (byte[])originalArray;
            return (T)Arrays.copyOf(array, array.length);
        }
        if (short[].class.equals(arrayClass)) {
            short[] array = (short[])originalArray;
            return (T)Arrays.copyOf(array, array.length);
        }
        if (int[].class.equals(arrayClass)) {
            int[] array = (int[])originalArray;
            return (T)Arrays.copyOf(array, array.length);
        }
        if (long[].class.equals(arrayClass)) {
            long[] array = (long[])originalArray;
            return (T)Arrays.copyOf(array, array.length);
        }
        if (float[].class.equals(arrayClass)) {
            float[] array = (float[])originalArray;
            return (T)Arrays.copyOf(array, array.length);
        }
        if (double[].class.equals(arrayClass)) {
            double[] array = (double[])originalArray;
            return (T)Arrays.copyOf(array, array.length);
        }
        if (char[].class.equals(arrayClass)) {
            char[] array = (char[])originalArray;
            return (T)Arrays.copyOf(array, array.length);
        }
        Object[] array = (Object[])originalArray;
        return (T)Arrays.copyOf(array, array.length);
    }

    public static Object[] wrapArray(Object originalArray) {
        Class<?> arrayClass = originalArray.getClass();
        if (boolean[].class.equals(arrayClass)) {
            boolean[] fromArray = (boolean[])originalArray;
            Object[] array = new Boolean[fromArray.length];
            for (int i = 0; i < fromArray.length; ++i) {
                array[i] = fromArray[i];
            }
            return array;
        }
        if (byte[].class.equals(arrayClass)) {
            byte[] fromArray = (byte[])originalArray;
            Object[] array = new Byte[fromArray.length];
            for (int i = 0; i < fromArray.length; ++i) {
                array[i] = fromArray[i];
            }
            return array;
        }
        if (short[].class.equals(arrayClass)) {
            short[] fromArray = (short[])originalArray;
            Object[] array = new Short[fromArray.length];
            for (int i = 0; i < fromArray.length; ++i) {
                array[i] = fromArray[i];
            }
            return array;
        }
        if (int[].class.equals(arrayClass)) {
            int[] fromArray = (int[])originalArray;
            Object[] array = new Integer[fromArray.length];
            for (int i = 0; i < fromArray.length; ++i) {
                array[i] = fromArray[i];
            }
            return array;
        }
        if (long[].class.equals(arrayClass)) {
            long[] fromArray = (long[])originalArray;
            Object[] array = new Long[fromArray.length];
            for (int i = 0; i < fromArray.length; ++i) {
                array[i] = fromArray[i];
            }
            return array;
        }
        if (float[].class.equals(arrayClass)) {
            float[] fromArray = (float[])originalArray;
            Object[] array = new Float[fromArray.length];
            for (int i = 0; i < fromArray.length; ++i) {
                array[i] = Float.valueOf(fromArray[i]);
            }
            return array;
        }
        if (double[].class.equals(arrayClass)) {
            double[] fromArray = (double[])originalArray;
            Object[] array = new Double[fromArray.length];
            for (int i = 0; i < fromArray.length; ++i) {
                array[i] = fromArray[i];
            }
            return array;
        }
        if (char[].class.equals(arrayClass)) {
            char[] fromArray = (char[])originalArray;
            Object[] array = new Character[fromArray.length];
            for (int i = 0; i < fromArray.length; ++i) {
                array[i] = Character.valueOf(fromArray[i]);
            }
            return array;
        }
        if (originalArray instanceof List) {
            return ((List)originalArray).toArray();
        }
        return (Object[])originalArray;
    }

    public static <T> T unwrapArray(Object[] originalArray, Class<T> arrayClass) {
        if (boolean[].class.equals(arrayClass)) {
            boolean[] array = new boolean[originalArray.length];
            for (int i = 0; i < originalArray.length; ++i) {
                array[i] = originalArray[i] != null ? (Boolean)originalArray[i] : Boolean.FALSE;
            }
            return (T)array;
        }
        if (byte[].class.equals(arrayClass)) {
            byte[] array = new byte[originalArray.length];
            for (int i = 0; i < originalArray.length; ++i) {
                array[i] = originalArray[i] != null ? (Byte)originalArray[i] : (byte)0;
            }
            return (T)array;
        }
        if (short[].class.equals(arrayClass)) {
            short[] array = new short[originalArray.length];
            for (int i = 0; i < originalArray.length; ++i) {
                array[i] = originalArray[i] != null ? (Short)originalArray[i] : (short)0;
            }
            return (T)array;
        }
        if (int[].class.equals(arrayClass)) {
            int[] array = new int[originalArray.length];
            for (int i = 0; i < originalArray.length; ++i) {
                array[i] = originalArray[i] != null ? (Integer)originalArray[i] : 0;
            }
            return (T)array;
        }
        if (long[].class.equals(arrayClass)) {
            long[] array = new long[originalArray.length];
            for (int i = 0; i < originalArray.length; ++i) {
                array[i] = originalArray[i] != null ? (Long)originalArray[i] : 0L;
            }
            return (T)array;
        }
        if (float[].class.equals(arrayClass)) {
            float[] array = new float[originalArray.length];
            for (int i = 0; i < originalArray.length; ++i) {
                array[i] = originalArray[i] != null ? ((Float)originalArray[i]).floatValue() : 0.0f;
            }
            return (T)array;
        }
        if (double[].class.equals(arrayClass)) {
            double[] array = new double[originalArray.length];
            for (int i = 0; i < originalArray.length; ++i) {
                array[i] = originalArray[i] != null ? (Double)originalArray[i] : 0.0;
            }
            return (T)array;
        }
        if (char[].class.equals(arrayClass)) {
            char[] array = new char[originalArray.length];
            for (int i = 0; i < originalArray.length; ++i) {
                array[i] = originalArray[i] != null ? ((Character)originalArray[i]).charValue() : (char)'\u0000';
            }
            return (T)array;
        }
        if (Enum[].class.isAssignableFrom(arrayClass)) {
            T array = arrayClass.cast(Array.newInstance(arrayClass.getComponentType(), originalArray.length));
            for (int i = 0; i < originalArray.length; ++i) {
                Object objectValue = originalArray[i];
                if (objectValue != null) {
                    String stringValue = objectValue instanceof String ? (String)objectValue : String.valueOf(objectValue);
                    objectValue = Enum.valueOf(arrayClass.getComponentType(), stringValue);
                }
                Array.set(array, i, objectValue);
            }
            return array;
        }
        if (arrayClass.getComponentType() != null && arrayClass.getComponentType().isArray()) {
            int arrayLength = originalArray.length;
            Object[] array = (Object[])Array.newInstance(arrayClass.getComponentType(), arrayLength);
            if (arrayLength > 0) {
                for (int i = 0; i < originalArray.length; ++i) {
                    array[i] = ArrayUtil.unwrapArray((Object[])originalArray[i], arrayClass.getComponentType());
                }
            }
            return (T)array;
        }
        if (arrayClass.isInstance(originalArray)) {
            return (T)originalArray;
        }
        return (T)Arrays.copyOf(originalArray, originalArray.length, arrayClass);
    }

    public static <T> T fromString(String string, Class<T> arrayClass) {
        String stringArray = string.replaceAll("[\\[\\]]", "");
        String[] tokens = stringArray.split(",");
        int length = tokens.length;
        if (boolean[].class.equals(arrayClass)) {
            boolean[] array = new boolean[length];
            for (int i = 0; i < tokens.length; ++i) {
                array[i] = Boolean.valueOf(tokens[i]);
            }
            return (T)array;
        }
        if (byte[].class.equals(arrayClass)) {
            byte[] array = new byte[length];
            for (int i = 0; i < tokens.length; ++i) {
                array[i] = Byte.valueOf(tokens[i]);
            }
            return (T)array;
        }
        if (short[].class.equals(arrayClass)) {
            short[] array = new short[length];
            for (int i = 0; i < tokens.length; ++i) {
                array[i] = Short.valueOf(tokens[i]);
            }
            return (T)array;
        }
        if (int[].class.equals(arrayClass)) {
            int[] array = new int[length];
            for (int i = 0; i < tokens.length; ++i) {
                array[i] = Integer.valueOf(tokens[i]);
            }
            return (T)array;
        }
        if (long[].class.equals(arrayClass)) {
            long[] array = new long[length];
            for (int i = 0; i < tokens.length; ++i) {
                array[i] = Long.valueOf(tokens[i]);
            }
            return (T)array;
        }
        if (float[].class.equals(arrayClass)) {
            float[] array = new float[length];
            for (int i = 0; i < tokens.length; ++i) {
                array[i] = Float.valueOf(tokens[i]).floatValue();
            }
            return (T)array;
        }
        if (double[].class.equals(arrayClass)) {
            double[] array = new double[length];
            for (int i = 0; i < tokens.length; ++i) {
                array[i] = Double.valueOf(tokens[i]);
            }
            return (T)array;
        }
        if (char[].class.equals(arrayClass)) {
            char[] array = new char[length];
            for (int i = 0; i < tokens.length; ++i) {
                array[i] = tokens[i].length() > 0 ? tokens[i].charAt(0) : (char)'\u0000';
            }
            return (T)array;
        }
        return (T)tokens;
    }

    public static boolean isEquals(Object firstArray, Object secondArray) {
        if (firstArray.getClass() != secondArray.getClass()) {
            return false;
        }
        Class<?> arrayClass = firstArray.getClass();
        if (boolean[].class.equals(arrayClass)) {
            return Arrays.equals((boolean[])firstArray, (boolean[])secondArray);
        }
        if (byte[].class.equals(arrayClass)) {
            return Arrays.equals((byte[])firstArray, (byte[])secondArray);
        }
        if (short[].class.equals(arrayClass)) {
            return Arrays.equals((short[])firstArray, (short[])secondArray);
        }
        if (int[].class.equals(arrayClass)) {
            return Arrays.equals((int[])firstArray, (int[])secondArray);
        }
        if (long[].class.equals(arrayClass)) {
            return Arrays.equals((long[])firstArray, (long[])secondArray);
        }
        if (float[].class.equals(arrayClass)) {
            return Arrays.equals((float[])firstArray, (float[])secondArray);
        }
        if (double[].class.equals(arrayClass)) {
            return Arrays.equals((double[])firstArray, (double[])secondArray);
        }
        if (char[].class.equals(arrayClass)) {
            return Arrays.equals((char[])firstArray, (char[])secondArray);
        }
        return Arrays.equals((Object[])firstArray, (Object[])secondArray);
    }

    public static <T> Class<T[]> toArrayClass(Class<T> arrayElementClass) {
        if (Boolean.TYPE.equals(arrayElementClass)) {
            return boolean[].class;
        }
        if (Byte.TYPE.equals(arrayElementClass)) {
            return byte[].class;
        }
        if (Short.TYPE.equals(arrayElementClass)) {
            return short[].class;
        }
        if (Integer.TYPE.equals(arrayElementClass)) {
            return int[].class;
        }
        if (Long.TYPE.equals(arrayElementClass)) {
            return long[].class;
        }
        if (Float.TYPE.equals(arrayElementClass)) {
            return float[].class;
        }
        if (double[].class.equals(arrayElementClass)) {
            return double[].class;
        }
        if (char[].class.equals(arrayElementClass)) {
            return char[].class;
        }
        Object array = Array.newInstance(arrayElementClass, 0);
        return array.getClass();
    }

    public static <T> List<T> asList(T[] array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add(i, array[i]);
        }
        return list;
    }
}

