/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.json.internal;

import com.vladmihalcea.hibernate.type.json.internal.AbstractJsonSqlTypeDescriptor;
import com.vladmihalcea.hibernate.type.json.internal.JsonBinarySqlTypeDescriptor;
import com.vladmihalcea.hibernate.type.json.internal.JsonBytesSqlTypeDescriptor;
import com.vladmihalcea.hibernate.type.json.internal.JsonStringSqlTypeDescriptor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;

public class JsonSqlTypeDescriptor
extends AbstractJsonSqlTypeDescriptor {
    private volatile Dialect dialect;
    private volatile AbstractJsonSqlTypeDescriptor sqlTypeDescriptor;

    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                JsonSqlTypeDescriptor.this.sqlTypeDescriptor(st.getConnection()).getBinder(javaTypeDescriptor).bind(st, value, index, options);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                JsonSqlTypeDescriptor.this.sqlTypeDescriptor(st.getConnection()).getBinder(javaTypeDescriptor).bind(st, value, name, options);
            }
        };
    }

    @Override
    protected Object extractJson(ResultSet rs, String name) throws SQLException {
        return this.sqlTypeDescriptor(rs.getStatement().getConnection()).extractJson(rs, name);
    }

    @Override
    protected Object extractJson(CallableStatement statement, int index) throws SQLException {
        return this.sqlTypeDescriptor(statement.getConnection()).extractJson(statement, index);
    }

    @Override
    protected Object extractJson(CallableStatement statement, String name) throws SQLException {
        return this.sqlTypeDescriptor(statement.getConnection()).extractJson(statement, name);
    }

    private AbstractJsonSqlTypeDescriptor sqlTypeDescriptor(Connection connection) {
        if (this.sqlTypeDescriptor == null) {
            this.sqlTypeDescriptor = this.resolveSqlTypeDescriptor(connection);
        }
        return this.sqlTypeDescriptor;
    }

    private AbstractJsonSqlTypeDescriptor resolveSqlTypeDescriptor(Connection connection) {
        try {
            StandardDialectResolver dialectResolver = new StandardDialectResolver();
            this.dialect = dialectResolver.resolveDialect((DialectResolutionInfo)new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData()));
            if (PostgreSQL81Dialect.class.isInstance(this.dialect)) {
                return JsonBinarySqlTypeDescriptor.INSTANCE;
            }
            if (H2Dialect.class.isInstance(this.dialect)) {
                return JsonBytesSqlTypeDescriptor.INSTANCE;
            }
            return JsonStringSqlTypeDescriptor.INSTANCE;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

