/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.json.internal;

import com.vladmihalcea.hibernate.type.json.internal.AbstractJsonJdbcTypeDescriptor;
import com.vladmihalcea.hibernate.type.json.internal.JsonBinaryJdbcTypeDescriptor;
import com.vladmihalcea.hibernate.type.json.internal.JsonBlobJdbcTypeDescriptor;
import com.vladmihalcea.hibernate.type.json.internal.JsonBytesJdbcTypeDescriptor;
import com.vladmihalcea.hibernate.type.json.internal.JsonStringJdbcTypeDescriptor;
import com.vladmihalcea.hibernate.type.util.ParameterTypeUtils;
import com.vladmihalcea.hibernate.util.StringUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.dialect.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.ParameterizedType;

public class JsonJdbcTypeDescriptor
extends AbstractJsonJdbcTypeDescriptor
implements ParameterizedType {
    private volatile Dialect dialect;
    private volatile AbstractJsonJdbcTypeDescriptor jdbcTypeDescriptor;
    private volatile Properties properties;

    public JsonJdbcTypeDescriptor() {
    }

    public JsonJdbcTypeDescriptor(Properties properties) {
        this.properties = properties;
    }

    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                JsonJdbcTypeDescriptor.this.sqlTypeDescriptor(st.getConnection()).getBinder(javaType).bind(st, value, index, options);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                JsonJdbcTypeDescriptor.this.sqlTypeDescriptor(st.getConnection()).getBinder(javaType).bind(st, value, name, options);
            }
        };
    }

    @Override
    protected Object extractJson(ResultSet rs, int paramIndex) throws SQLException {
        return this.sqlTypeDescriptor(rs.getStatement().getConnection()).extractJson(rs, paramIndex);
    }

    @Override
    protected Object extractJson(CallableStatement statement, int index) throws SQLException {
        return this.sqlTypeDescriptor(statement.getConnection()).extractJson(statement, index);
    }

    @Override
    protected Object extractJson(CallableStatement statement, String name) throws SQLException {
        return this.sqlTypeDescriptor(statement.getConnection()).extractJson(statement, name);
    }

    private AbstractJsonJdbcTypeDescriptor sqlTypeDescriptor(Connection connection) {
        if (this.jdbcTypeDescriptor == null) {
            this.jdbcTypeDescriptor = this.resolveJdbcTypeDescriptor(connection);
        }
        return this.jdbcTypeDescriptor;
    }

    private AbstractJsonJdbcTypeDescriptor resolveJdbcTypeDescriptor(Connection connection) {
        try {
            StandardDialectResolver dialectResolver = new StandardDialectResolver();
            DatabaseMetaDataDialectResolutionInfoAdapter metaDataInfo = new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData());
            this.dialect = dialectResolver.resolveDialect((DialectResolutionInfo)metaDataInfo);
            if (this.dialect instanceof PostgreSQLDialect) {
                return JsonBinaryJdbcTypeDescriptor.INSTANCE;
            }
            if (this.dialect instanceof H2Dialect) {
                return JsonBytesJdbcTypeDescriptor.INSTANCE;
            }
            if (this.dialect instanceof OracleDialect) {
                String columnType;
                DynamicParameterizedType.ParameterType parameterType;
                if (this.properties != null && (parameterType = ParameterTypeUtils.resolve(this.properties)) != null && !StringUtils.isBlank(columnType = ParameterTypeUtils.getColumnType(parameterType))) {
                    switch (columnType) {
                        case "json": {
                            return JsonBytesJdbcTypeDescriptor.of(Database.ORACLE);
                        }
                        case "blob": 
                        case "clob": {
                            return JsonBlobJdbcTypeDescriptor.INSTANCE;
                        }
                        case "varchar2": 
                        case "nvarchar2": {
                            return JsonStringJdbcTypeDescriptor.INSTANCE;
                        }
                    }
                }
                if (metaDataInfo.getDatabaseMajorVersion() >= 21) {
                    return JsonBytesJdbcTypeDescriptor.of(Database.ORACLE);
                }
            }
            return JsonStringJdbcTypeDescriptor.INSTANCE;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcTypeDescriptor != null ? this.jdbcTypeDescriptor.getJdbcTypeCode() : super.getJdbcTypeCode();
    }

    public void setParameterValues(Properties parameters) {
        if (this.properties == null) {
            this.properties = parameters;
        } else {
            this.properties.putAll((Map<?, ?>)parameters);
        }
    }
}

