/*
 * Decompiled with CFR 0.152.
 */
package com.wywy.log4j.appender;

import com.wywy.log4j.appender.FluencyConfig;
import com.wywy.log4j.appender.Server;
import com.wywy.log4j.appender.StaticField;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.NameAbbreviator;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.status.StatusLogger;
import org.komamitsu.fluency.Fluency;

@Plugin(name="Fluency", category="Core", elementType="appender", printObject=true)
public final class FluencyAppender
extends AbstractAppender {
    private static final StatusLogger LOG = StatusLogger.getLogger();
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final NameAbbreviator abbr = NameAbbreviator.getAbbreviator((String)"1.");
    private boolean usePre26Abbreviate = false;
    private Method abbreviateMethod;
    private Fluency fluency;
    private Map<String, Object> parameters;
    private Map<String, String> staticFields;

    private FluencyAppender(String name, Map<String, Object> parameters, Map<String, String> staticFields, Server[] servers, FluencyConfig fluencyConfig, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        this.parameters = parameters;
        this.staticFields = staticFields;
        try {
            this.fluency = FluencyAppender.makeFluency(servers, fluencyConfig);
            LOG.info("FluencyAppender initialized");
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        try {
            this.abbreviateMethod = NameAbbreviator.class.getMethod("abbreviate", String.class);
            this.usePre26Abbreviate = true;
        }
        catch (NoSuchMethodException e) {
            try {
                this.abbreviateMethod = NameAbbreviator.class.getMethod("abbreviate", String.class, StringBuilder.class);
            }
            catch (NoSuchMethodException | SecurityException e1) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (SecurityException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @PluginFactory
    public static FluencyAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="tag") String tag, @PluginAttribute(value="application") String application, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginElement(value="StaticField") StaticField[] staticFields, @PluginElement(value="Server") Server[] servers, @PluginElement(value="FluencyConfig") FluencyConfig fluencyConfig, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, String> fields = new HashMap<String, String>();
        if (tag == null) {
            throw new IllegalArgumentException("tag is required");
        }
        parameters.put("tag", tag);
        if (application != null) {
            fields.put("application", application);
        }
        for (StaticField field : staticFields) {
            if (field.getName().trim().equals("")) {
                LOG.warn("Skipping empty field");
                continue;
            }
            if (field.getValue().trim().equals("")) {
                LOG.warn("Skipping field {} due to empty value", new Object[]{field.getName()});
                continue;
            }
            fields.put(field.getName(), field.getValue());
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new FluencyAppender(name, parameters, fields, servers, fluencyConfig, filter, (Layout<? extends Serializable>)layout, ignoreExceptions);
    }

    static Fluency makeFluency(Server[] servers, FluencyConfig config) throws IOException {
        if (servers.length == 0 && config == null) {
            return Fluency.defaultFluency();
        }
        if (servers.length == 0) {
            return Fluency.defaultFluency((Fluency.Config)config.configure());
        }
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(servers.length);
        for (Server s : servers) {
            addresses.add(s.configure());
        }
        if (config == null) {
            return Fluency.defaultFluency(addresses);
        }
        return Fluency.defaultFluency(addresses, (Fluency.Config)config.configure());
    }

    public void append(LogEvent logEvent) {
        String level = logEvent.getLevel().name();
        String loggerName = logEvent.getLoggerName();
        String message = new String(this.getLayout().toByteArray(logEvent));
        Date eventTime = new Date(logEvent.getTimeMillis());
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("level", level);
        StackTraceElement logSource = logEvent.getSource();
        if (logSource == null || logSource.getFileName() == null) {
            m.put("sourceFile", "<unknown>");
        } else {
            m.put("sourceFile", logSource.getFileName());
        }
        if (logSource == null || logSource.getClassName() == null) {
            m.put("sourceClass", "<unknown>");
        } else {
            m.put("sourceClass", logEvent.getSource().getClassName());
        }
        if (logSource == null || logSource.getMethodName() == null) {
            m.put("sourceMethod", "<unknown>");
        } else {
            m.put("sourceMethod", logEvent.getSource().getMethodName());
        }
        if (logSource == null || logSource.getLineNumber() == 0) {
            m.put("sourceLine", 0);
        } else {
            m.put("sourceLine", logEvent.getSource().getLineNumber());
        }
        try {
            if (this.usePre26Abbreviate) {
                m.put("logger", this.abbreviatePre26(loggerName));
            } else if (this.abbreviateMethod != null) {
                m.put("logger", this.abbreviate(loggerName));
            } else {
                m.put("logger", loggerName);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOG.error(e.getMessage());
        }
        m.put("loggerFull", loggerName);
        m.put("message", message);
        m.put("thread", logEvent.getThreadName());
        m.putAll(this.staticFields);
        m.put("@timestamp", this.format.format(eventTime));
        if (this.fluency != null) {
            try {
                this.fluency.emit((String)this.parameters.get("tag"), logEvent.getTimeMillis(), m);
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        }
    }

    private String abbreviatePre26(String stringToAbbreviate) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (String)this.abbreviateMethod.invoke((Object)this.abbr, stringToAbbreviate);
    }

    private String abbreviate(String stringToAbbreviate) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        StringBuilder logger = new StringBuilder();
        this.abbreviateMethod.invoke((Object)this.abbr, stringToAbbreviate, logger);
        return logger.toString();
    }
}

