/*
 * Decompiled with CFR 0.152.
 */
package com.wywy.log4j.appender;

import java.net.InetSocketAddress;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="Server", category="Core", printObject=true)
public class Server {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String host;
    private final int port;

    private Server(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public InetSocketAddress configure() {
        return new InetSocketAddress(this.host, this.port);
    }

    @PluginFactory
    public static Server createServer(@PluginAttribute(value="host") String host, @PluginAttribute(value="port") int port) {
        if (host == null) {
            LOGGER.error("Property host cannot be null");
        }
        if (port <= 0) {
            LOGGER.error("Property port must be > 0");
        }
        return new Server(host, port);
    }

    public String toString() {
        return "Server{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

