/*
 * Decompiled with CFR 0.152.
 */
package com.wywy.log4j.appender;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.PluginValue;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="StaticField", category="Core", printObject=true)
public final class StaticField {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String name;
    private final String value;
    private final boolean valueNeedsLookup;

    private StaticField(String name, String value) {
        this.name = name;
        this.value = value;
        this.valueNeedsLookup = value != null && value.contains("${");
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    public boolean isValueNeedsLookup() {
        return this.valueNeedsLookup;
    }

    @PluginFactory
    public static StaticField createStaticField(@PluginAttribute(value="name") String name, @PluginValue(value="value") String value) {
        if (name == null) {
            LOGGER.error("Property name cannot be null");
        }
        return new StaticField(name, value);
    }

    public String toString() {
        return this.name + '=' + this.getValue();
    }
}

