/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.notify.XWikiDocChangeNotificationInterface;
import com.xpn.xwiki.notify.XWikiNotificationRule;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerException;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplicationClass;
import com.xpn.xwiki.plugin.packaging.DocumentInfoAPI;
import com.xpn.xwiki.plugin.packaging.PackageAPI;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ApplicationManager
implements XWikiDocChangeNotificationInterface {
    public static final String MESSAGETOOL_CONTEXT_KEY = "applicationmanagermessagetool";
    protected static final Log LOG = LogFactory.getLog((Class)(class$com$xpn$xwiki$plugin$applicationmanager$ApplicationManager == null ? (class$com$xpn$xwiki$plugin$applicationmanager$ApplicationManager = ApplicationManager.class$("com.xpn.xwiki.plugin.applicationmanager.ApplicationManager")) : class$com$xpn$xwiki$plugin$applicationmanager$ApplicationManager));
    private static final String XWIKIPREFERENCES = "XWiki.XWikiPreferences";
    private static final String XWIKIPREFERENCES_DOCUMENTBUNDLES = "documentBundles";
    private static final String XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP = ",";
    private static final String PACKAGEPLUGIN_NAME = "package";
    private static ApplicationManager instance;
    static /* synthetic */ Class class$com$xpn$xwiki$plugin$applicationmanager$ApplicationManager;

    private ApplicationManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationManager getInstance() {
        Class clazz = class$com$xpn$xwiki$plugin$applicationmanager$ApplicationManager == null ? (class$com$xpn$xwiki$plugin$applicationmanager$ApplicationManager = ApplicationManager.class$("com.xpn.xwiki.plugin.applicationmanager.ApplicationManager")) : class$com$xpn$xwiki$plugin$applicationmanager$ApplicationManager;
        synchronized (clazz) {
            if (instance == null) {
                instance = new ApplicationManager();
            }
        }
        return instance;
    }

    public void notify(XWikiNotificationRule rule, XWikiDocument newdoc, XWikiDocument olddoc, int event, XWikiContext context) {
        try {
            if (newdoc != null && XWikiApplicationClass.getInstance(context).isInstance(newdoc)) {
                List appList = XWikiApplicationClass.getInstance(context).newSuperDocumentList(newdoc, context);
                this.updateApplicationsTranslation(appList, "Auto update translations informations from applications in " + newdoc.getFullName(), context);
            }
        }
        catch (XWikiException e) {
            LOG.error((Object)("Error when updating translations informations from applications in " + newdoc.getFullName()), (Throwable)e);
        }
    }

    public XWikiApplication getRootApplication(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        String docFullName = xwiki.getXWikiPreference("rootapplication", null, context);
        if (docFullName != null && !(doc = xwiki.getDocument(docFullName, context)).isNew()) {
            return (XWikiApplication)XWikiApplicationClass.getInstance(context).newSuperDocument(doc, 0, context);
        }
        return null;
    }

    public List getApplicationList(XWikiContext context) throws XWikiException {
        return XWikiApplicationClass.getInstance(context).searchSuperDocuments(context);
    }

    public void createApplication(XWikiApplication userAppSuperDoc, boolean failOnExist, String comment, XWikiContext context) throws XWikiException {
        XWikiApplicationClass appClass;
        XWiki xwiki = context.getWiki();
        XWikiDocument docToSave = xwiki.getDocument((appClass = XWikiApplicationClass.getInstance(context)).getItemDocumentDefaultFullName(userAppSuperDoc.getAppName(), context), context);
        if (!docToSave.isNew() && appClass.isInstance(docToSave)) {
            if (failOnExist) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Wiki creation (" + userAppSuperDoc + ") failed: wiki server page already exists"));
                }
                throw new ApplicationManagerException(60010, "Application \"" + userAppSuperDoc.getAppName() + "\" document already exist");
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Application creation (" + userAppSuperDoc + ") failed: application page already exists"));
            }
        }
        XWikiApplication appSuperDocToSave = (XWikiApplication)XWikiApplicationClass.getInstance(context).newSuperDocument(docToSave, 0, context);
        appSuperDocToSave.mergeObject(userAppSuperDoc);
        appSuperDocToSave.save(comment);
        userAppSuperDoc.setFullName(appSuperDocToSave.getFullName());
    }

    public void deleteApplication(String appName, XWikiContext context) throws XWikiException {
        XWikiApplication app = this.getApplication(appName, context, true);
        app.delete();
    }

    public XWikiApplication getApplication(String appName, XWikiContext context, boolean validate) throws XWikiException {
        return XWikiApplicationClass.getInstance(context).getApplication(appName, validate, context);
    }

    public void reloadApplication(XWikiApplication app, String comment, XWikiContext context) throws XWikiException {
        this.updateApplicationTranslation(app, comment, context);
    }

    public void reloadAllApplications(String comment, XWikiContext context) throws XWikiException {
        List applist = this.getApplicationList(context);
        Iterator it = applist.iterator();
        while (it.hasNext()) {
            XWikiApplication app = (XWikiApplication)it.next();
            ApplicationManager.getInstance().updateApplicationTranslation(app, comment, context);
        }
    }

    public void updateApplicationsTranslation(Collection applications, String comment, XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        XWikiDocument prefsDoc = xwiki.getDocument(XWIKIPREFERENCES, context);
        BaseObject prefsObject = prefsDoc.getObject(XWIKIPREFERENCES);
        if (prefsObject != null) {
            String documentBundles = prefsObject.getStringValue(XWIKIPREFERENCES_DOCUMENTBUNDLES);
            List translationPrefs = ListClass.getListFromString((String)documentBundles, (String)XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP, (boolean)true);
            boolean updateprefs = false;
            Iterator it = applications.iterator();
            while (it.hasNext()) {
                XWikiApplication app = (XWikiApplication)it.next();
                updateprefs |= this.updateApplicationTranslation(translationPrefs, app);
            }
            if (updateprefs) {
                prefsObject.setStringValue(XWIKIPREFERENCES_DOCUMENTBUNDLES, StringUtils.join((Object[])translationPrefs.toArray(), (String)XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP));
                xwiki.saveDocument(prefsDoc, comment, context);
            }
        }
    }

    public void updateAllApplicationTranslation(String comment, XWikiContext context) throws XWikiException {
        this.updateApplicationsTranslation(this.getApplicationList(context), comment, context);
    }

    public void updateApplicationTranslation(XWikiApplication app, String comment, XWikiContext context) throws XWikiException {
        String documentBundles;
        List translationPrefs;
        boolean updateprefs;
        XWiki xwiki = context.getWiki();
        XWikiDocument prefsDoc = xwiki.getDocument(XWIKIPREFERENCES, context);
        BaseObject prefsObject = prefsDoc.getObject(XWIKIPREFERENCES);
        if (prefsObject != null && (updateprefs = this.updateApplicationTranslation(translationPrefs = ListClass.getListFromString((String)(documentBundles = prefsObject.getStringValue(XWIKIPREFERENCES_DOCUMENTBUNDLES)), (String)XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP, (boolean)true), app))) {
            prefsObject.setStringValue(XWIKIPREFERENCES_DOCUMENTBUNDLES, StringUtils.join((Object[])translationPrefs.toArray(), (String)XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP));
            xwiki.saveDocument(prefsDoc, comment, context);
        }
    }

    public boolean updateApplicationTranslation(List translationPrefs, XWikiApplication app) {
        boolean updateprefs = false;
        List translationDocs = app.getTranslationDocs();
        Iterator it2 = translationDocs.iterator();
        while (it2.hasNext()) {
            String translationDoc = (String)it2.next();
            if (translationPrefs.contains(translationDoc)) continue;
            translationPrefs.add(translationDoc);
            updateprefs = true;
        }
        return updateprefs;
    }

    public void exportApplicationXAR(String appName, boolean recurse, boolean withDocHistory, XWikiContext context) throws XWikiException, IOException {
        XWikiApplication app = ApplicationManager.getInstance().getApplication(appName, context, true);
        PackageAPI export = (PackageAPI)context.getWiki().getPluginApi(PACKAGEPLUGIN_NAME, context);
        export.setName(app.getAppName() + "-" + app.getAppVersion());
        Set documents = app.getDocumentsNames(recurse, true);
        Iterator it = documents.iterator();
        while (it.hasNext()) {
            export.add((String)it.next(), 0);
        }
        export.setWithVersions(withDocHistory);
        export.export();
    }

    public void importApplication(XWikiDocument packageDoc, String packageName, String comment, XWikiContext context) throws XWikiException {
        XWikiAttachment packFile = packageDoc.getAttachment(packageName);
        if (packFile == null) {
            throw new ApplicationManagerException(0, "Package " + packageName + " does not exists.");
        }
        PackageAPI importer = (PackageAPI)context.getWiki().getPluginApi(PACKAGEPLUGIN_NAME, context);
        try {
            importer.Import(packFile.getContent(context));
        }
        catch (IOException e) {
            throw new ApplicationManagerException(0, "Fail to import package " + packageName, e);
        }
        if (importer.install() == 0) {
            throw new ApplicationManagerException(0, "Fail to install package " + packageName);
        }
        Iterator it = importer.getFiles().iterator();
        while (it.hasNext()) {
            DocumentInfoAPI docinfo = (DocumentInfoAPI)it.next();
            XWikiDocument doc = docinfo.getDocInfo().getDoc();
            if (!XWikiApplicationClass.getInstance(context).isInstance(doc)) continue;
            this.reloadApplication((XWikiApplication)XWikiApplicationClass.getInstance(context).newSuperDocument(doc, 0, context), comment, context);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

