/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.SuperClass;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.SuperDocument;
import java.util.List;

public class DefaultSuperDocument
extends Document
implements SuperDocument {
    private static final int BOOLEANFIELD_TRUE = 1;
    private static final int BOOLEANFIELD_FALSE = 0;
    private static final int BOOLEANFIELD_MAYBE = 2;
    protected SuperClass sclass;
    protected int objectId;
    protected boolean isNew;

    public DefaultSuperDocument(SuperClass sclass, XWikiDocument xdoc, int objectId, XWikiContext context) throws XWikiException {
        super(xdoc, context);
        this.sclass = sclass;
        this.objectId = objectId;
        this.reload(context);
    }

    public void setFullName(String docFullName) {
        this.getDoc().setFullName(docFullName, ((Api)this).context);
    }

    public void reload(XWikiContext context) throws XWikiException {
        if (this.getObjectNumbers(this.sclass.getClassFullName()) == 0) {
            if (this.objectId > 0) {
                throw new XWikiException(2, 2, "Object od id " + this.objectId + "does not exist");
            }
            BaseObject object = this.getDoc().newObject(this.sclass.getClassFullName(), context);
            XWikiDocument docTemplate = context.getWiki().getDocument(this.sclass.getClassTemplateFullName(), context);
            BaseObject templateObject = docTemplate.getObject(this.sclass.getClassFullName());
            if (templateObject != null) {
                object.merge(templateObject);
            }
            if (super.isNew()) {
                this.setParent(docTemplate.getParent());
                this.setContent(docTemplate.getContent());
            }
            this.isNew = true;
        }
    }

    public Document getDocumentApi() {
        return this;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public Object getObjectApi() {
        BaseObject obj = this.getBaseObject(false);
        return obj == null ? null : obj.newObjectApi(obj, ((Api)this).context);
    }

    protected BaseObject getBaseObject(boolean toWrite) {
        BaseObject obj = toWrite ? this.getDoc().getObject(this.sclass.getClassFullName(), this.objectId) : this.doc.getObject(this.sclass.getClassFullName(), this.objectId);
        return obj;
    }

    public void mergeObject(DefaultSuperDocument sdoc) {
        if (this.getSuperClass() != sdoc.getSuperClass()) {
            return;
        }
        this.getBaseObject(true).merge(sdoc.getBaseObject(false));
    }

    public SuperClass getSuperClass() {
        return this.sclass;
    }

    public boolean isNew() {
        return super.isNew() || this.isNew;
    }

    protected void saveDocument(String comment) throws XWikiException {
        super.saveDocument(comment);
        this.isNew = false;
    }

    protected void deleteDocument() throws XWikiException {
        if (this.getObjectNumbers(this.sclass.getClassFullName()) == 1) {
            super.deleteDocument();
        } else {
            this.doc.removeObject(this.getBaseObject(false));
            this.save();
        }
        this.isNew = true;
    }

    public String getStringValue(String fieldName) {
        BaseObject obj = this.getBaseObject(false);
        if (obj == null) {
            return null;
        }
        return obj.getStringValue(fieldName);
    }

    public void setStringValue(String fieldName, String value) {
        BaseObject obj = this.getBaseObject(true);
        if (obj != null) {
            obj.setStringValue(fieldName, value);
        }
    }

    public String getLargeStringValue(String fieldName) {
        BaseObject obj = this.getBaseObject(false);
        if (obj == null) {
            return null;
        }
        return obj.getLargeStringValue(fieldName);
    }

    public void setLargeStringValue(String fieldName, String value) {
        BaseObject obj = this.getBaseObject(true);
        if (obj != null) {
            obj.setLargeStringValue(fieldName, value);
        }
    }

    public List getListValue(String fieldName) {
        BaseObject obj = this.getBaseObject(false);
        if (obj == null) {
            return null;
        }
        return obj.getListValue(fieldName);
    }

    public void setListValue(String fieldName, List value) {
        BaseObject obj = this.getBaseObject(true);
        if (obj != null) {
            obj.setStringListValue(fieldName, value);
        }
    }

    public int getIntValue(String fieldName) {
        BaseObject obj = this.getBaseObject(false);
        if (obj == null) {
            return 0;
        }
        return obj.getIntValue(fieldName);
    }

    public void setIntValue(String fieldName, int value) {
        BaseObject obj = this.getBaseObject(true);
        if (obj != null) {
            obj.setIntValue(fieldName, value);
        }
    }

    public Boolean getBooleanValue(String fieldName) {
        int intValue = this.getIntValue(fieldName);
        return intValue == 1 ? Boolean.TRUE : (intValue == 0 ? Boolean.FALSE : null);
    }

    public void setBooleanValue(String fieldName, Boolean value) {
        this.setIntValue(fieldName, value == null ? 2 : (value != false ? 1 : 0));
    }
}

