/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.DefaultSuperDocument;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplicationClass;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XWikiApplication
extends DefaultSuperDocument {
    private static final Pattern EXT_DOCNAME_PATTERN = Pattern.compile("^\\[(.*)\\]$");

    public XWikiApplication(XWikiDocument xdoc, int objectId, XWikiContext context) throws XWikiException {
        super(XWikiApplicationClass.getInstance(context), xdoc, objectId, context);
    }

    public String getAppName() {
        return this.getStringValue("appname");
    }

    public void setAppName(String appname) {
        this.setStringValue("appname", appname);
    }

    public String getDescription() {
        return this.getStringValue("description");
    }

    public void setDescription(String description) {
        this.setStringValue("description", description);
    }

    public String getAppVersion() {
        return this.getStringValue("appversion");
    }

    public void setAppVersion(String appversion) {
        this.setStringValue("appversion", appversion);
    }

    public String getAppAuthors() {
        return this.getStringValue("appauthors");
    }

    public void setAppAuthors(String appauthors) {
        this.setStringValue("appauthors", appauthors);
    }

    public String getLicense() {
        return this.getStringValue("license");
    }

    public void setLicense(String license) {
        this.setStringValue("license", license);
    }

    public List getDependencies() {
        return this.getListValue("dependencies");
    }

    public void setDependencies(List dependencies) {
        this.setListValue("dependencies", dependencies);
    }

    public List getApplications() {
        return this.getListValue("applications");
    }

    public void setApplications(List applications) {
        this.setListValue("applications", applications);
    }

    public List getDocuments() {
        return this.getListValue("documents");
    }

    public void setDocuments(List documents) {
        this.setListValue("documents", documents);
    }

    public List getDocsToInclude() {
        return this.getListValue("docstoinclude");
    }

    public void setDocsToInclude(List docstoinclude) {
        this.setListValue("docstoinclude", docstoinclude);
    }

    public List getDocsToLink() {
        return this.getListValue("docstolink");
    }

    public void setDocsToLink(List docstolink) {
        this.setListValue("docstolink", docstolink);
    }

    public List getTranslationDocs() {
        return this.getListValue("translationdocs");
    }

    public void setTranslationDocs(List translationdocs) {
        this.setListValue("translationdocs", translationdocs);
    }

    public String toString() {
        return this.getAppName() + "-" + this.getAppVersion();
    }

    public int hashCode() {
        return this.getAppName() != null ? this.getAppName().hashCode() : "".hashCode();
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof XWikiApplication) {
            equals = this.getAppName() == null ? ((XWikiApplication)object).getAppName() == null : this.getAppName().equalsIgnoreCase(((XWikiApplication)object).getAppName());
        } else if (object instanceof String) {
            equals = this.getAppName() == null ? object == null : this.getAppName().equalsIgnoreCase((String)object);
        }
        return equals;
    }

    protected void addXWikiApplicationSet(XWikiApplication rootApplication, Collection applicationList, boolean recurse, XWikiContext context) throws XWikiException {
        List applications = this.getApplications();
        Iterator it = applications.iterator();
        while (it.hasNext()) {
            String appname = (String)it.next();
            if (rootApplication != null && rootApplication.equals(appname) || applicationList.contains(appname)) continue;
            XWikiApplication app = ((XWikiApplicationClass)this.sclass).getApplication(appname, true, context);
            applicationList.add(app);
            if (!recurse) continue;
            app.addXWikiApplicationSet(rootApplication, applicationList, recurse, context);
        }
    }

    public Set getXWikiApplicationSet(boolean recurse, XWikiContext context) throws XWikiException {
        HashSet applicationSet = new HashSet();
        this.addXWikiApplicationSet(this, applicationSet, recurse, context);
        return applicationSet;
    }

    private static void resolveDocumentsNames(Collection docsNames, Collection docsNamesToResolve, XWikiContext context) throws XWikiException {
        StringBuffer where = new StringBuffer();
        Iterator it = docsNamesToResolve.iterator();
        while (it.hasNext()) {
            String docName = (String)it.next();
            Matcher matcher = EXT_DOCNAME_PATTERN.matcher(docName);
            if (matcher.matches()) {
                if (where.length() > 0) {
                    where.append(" or ");
                }
                where.append("doc.fullName like '").append(matcher.group(1)).append("'");
                continue;
            }
            docsNames.add(docName);
        }
        if (where.length() > 0) {
            docsNames.addAll(context.getWiki().getStore().searchDocumentsNames("where " + where, context));
        }
    }

    private void resolveDocumentsNames(Collection docsNames, String type, boolean includeAppDesc) throws XWikiException {
        if (includeAppDesc) {
            docsNames.add(this.getFullName());
        }
        XWikiApplication.resolveDocumentsNames(docsNames, this.getListValue(type), ((Api)this).context);
    }

    private static void resolveApplicationsDocsNames(Collection docsNames, Collection applications, String type, boolean includeAppDesc) throws XWikiException {
        Iterator it = applications.iterator();
        while (it.hasNext()) {
            XWikiApplication app = (XWikiApplication)it.next();
            app.resolveDocumentsNames(docsNames, type, includeAppDesc);
        }
    }

    private Set getDocsNameSet(String type, boolean recurse, boolean includeAppDesc) throws XWikiException {
        HashSet documents = new HashSet();
        this.resolveDocumentsNames(documents, type, includeAppDesc);
        if (recurse) {
            XWikiApplication.resolveApplicationsDocsNames(documents, this.getXWikiApplicationSet(true, ((Api)this).context), type, includeAppDesc);
        }
        return documents;
    }

    public Set getDocumentsNames(boolean recurse, boolean includeAppDesc) throws XWikiException {
        return this.getDocsNameSet("documents", recurse, includeAppDesc);
    }

    public Set getDocsNameToInclude(boolean recurse) throws XWikiException {
        return this.getDocsNameSet("docstoinclude", recurse, false);
    }

    public static Set getDocsNameToInclude(Collection applications) throws XWikiException {
        HashSet docsToInclude = new HashSet();
        XWikiApplication.resolveApplicationsDocsNames(docsToInclude, applications, "docstoinclude", false);
        return docsToInclude;
    }

    public Set getDocsNameToLink(boolean recurse) throws XWikiException {
        return this.getDocsNameSet("docstolink", recurse, false);
    }

    public static Set getDocsNameToLink(Collection applications) throws XWikiException {
        HashSet docsToLink = new HashSet();
        XWikiApplication.resolveApplicationsDocsNames(docsToLink, applications, "docstolink", false);
        return docsToLink;
    }
}

