/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.AbstractXClassManager;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.DefaultSuperDocument;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.SuperClass;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.SuperDocument;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.SuperDocumentDoesNotExistException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class AbstractSuperClass
extends AbstractXClassManager
implements SuperClass {
    protected AbstractSuperClass(String prefix) {
        super(prefix);
    }

    protected AbstractSuperClass(String spaceprefix, String prefix) {
        super(spaceprefix, prefix);
    }

    protected AbstractSuperClass(String spaceprefix, String prefix, boolean dispatch) {
        super(spaceprefix, prefix, dispatch);
    }

    public SuperDocument getSuperDocument(String itemName, int objectId, boolean validate, XWikiContext context) throws XWikiException {
        XWikiDocument doc = context.getWiki().getDocument(this.getItemDocumentDefaultFullName(itemName, context), context);
        if (doc.isNew() || !this.isInstance(doc)) {
            throw new SuperDocumentDoesNotExistException(itemName + " object does not exist");
        }
        return this.newSuperDocument(doc, objectId, context);
    }

    public List searchSuperDocuments(XWikiContext context) throws XWikiException {
        return this.searchSuperDocumentsByFields(null, context);
    }

    public List searchSuperDocumentsByField(String fieldName, String fieldValue, String fieldType, XWikiContext context) throws XWikiException {
        String[][] fieldDescriptors = new String[][]{{fieldName, fieldType, fieldValue}};
        return this.searchSuperDocumentsByFields(fieldDescriptors, context);
    }

    public List searchSuperDocumentsByFields(String[][] fieldDescriptors, XWikiContext context) throws XWikiException {
        this.check(context);
        ArrayList parameterValues = new ArrayList();
        String where = this.createWhereClause(fieldDescriptors, parameterValues);
        return this.newSuperDocumentList(context.getWiki().getStore().searchDocuments(where, parameterValues, context), context);
    }

    public SuperDocument newSuperDocument(XWikiDocument doc, int objId, XWikiContext context) throws XWikiException {
        return new DefaultSuperDocument(this, doc, objId, context);
    }

    public SuperDocument newSuperDocument(String docFullName, int objId, XWikiContext context) throws XWikiException {
        return this.newSuperDocument(context.getWiki().getDocument(docFullName, context), objId, context);
    }

    public SuperDocument newSuperDocument(XWikiContext context) throws XWikiException {
        return this.newSuperDocument(new XWikiDocument(), 0, context);
    }

    public List newSuperDocumentList(XWikiDocument document, XWikiContext context) throws XWikiException {
        ArrayList<XWikiDocument> documents = new ArrayList<XWikiDocument>(1);
        documents.add(document);
        return this.newSuperDocumentList(documents, context);
    }

    public List newSuperDocumentList(List documents, XWikiContext context) throws XWikiException {
        ArrayList<SuperDocument> list = new ArrayList<SuperDocument>(documents.size());
        for (XWikiDocument doc : documents) {
            Vector objects = doc.getObjects(this.getClassFullName());
            for (BaseObject bobject : objects) {
                if (bobject == null) continue;
                list.add(this.newSuperDocument(doc, bobject.getNumber(), context));
            }
        }
        return list;
    }
}

