/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.DefaultXObjectDocument;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.XClassManager;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.XObjectDocument;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.XObjectDocumentDoesNotExistException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public abstract class AbstractXClassManager
implements XClassManager {
    private static final String DEFAULT_XWIKICLASS_PARENT = "XWiki.XWikiClasses";
    private static final String DOCUMENTCONTENT_EXT = ".svn";
    private static final String DOCUMENTCONTENT_SHEET_PREFIX = "sheets/";
    private static final String DOCUMENTCONTENT_TEMPLATE_PREFIX = "templates/";
    private static final String HQL_PARAMETER_STRING = "?";
    private final String classSpacePrefix;
    private final String classPrefix;
    private final String classSpace;
    private final String className;
    private final String classFullName;
    private final String classSheetSpace;
    private final String classSheetName;
    private final String classSheetFullName;
    private final String classTemplateSpace;
    private final String classTemplateName;
    private final String classTemplateFullName;
    private final String classSheetDefaultContent;
    private final String classTemplateDefaultContent;
    private BaseClass baseClass;
    private final Set databasesInitedMap = new HashSet();

    protected AbstractXClassManager(String prefix) {
        this("XWiki", prefix);
    }

    protected AbstractXClassManager(String spaceprefix, String prefix) {
        this(spaceprefix, prefix, true);
    }

    protected AbstractXClassManager(String spaceprefix, String prefix, boolean dispatch) {
        this.classSpacePrefix = spaceprefix;
        this.classPrefix = prefix;
        this.classSpace = dispatch ? this.classSpacePrefix + "Classes" : this.classSpacePrefix;
        this.className = this.classPrefix + "Class";
        this.classFullName = this.classSpace + "." + this.className;
        this.classSheetSpace = dispatch ? this.classSpacePrefix + "Sheets" : this.classSpacePrefix;
        this.classSheetName = this.classPrefix + "ClassSheet";
        this.classSheetFullName = this.classSheetSpace + "." + this.classSheetName;
        this.classTemplateSpace = dispatch ? this.classSpacePrefix + "Templates" : this.classSpacePrefix;
        this.classTemplateName = this.classPrefix + "ClassTemplate";
        this.classTemplateFullName = this.classTemplateSpace + "." + this.classTemplateName;
        this.classSheetDefaultContent = "## you can modify this page to customize the presentation of your object\n\n1 Document $doc.name\n\n#set($class = $doc.getObject(\"" + this.classFullName + "\").xWikiClass)\n" + "\n" + "<dl>\n" + "  #foreach($prop in $class.properties)\n" + "    <dt> ${prop.prettyName} </dt>\n" + "    <dd>$doc.display($prop.getName())</dd>\n  #end\n" + "</dl>\n";
        this.classTemplateDefaultContent = "#includeForm(\"" + this.classSheetFullName + "\")\n";
    }

    public String getClassSpacePrefix() {
        return this.classSpacePrefix;
    }

    public String getClassSpace() {
        return this.classSpace;
    }

    public String getClassPrefix() {
        return this.classPrefix;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassFullName() {
        return this.classFullName;
    }

    public String getClassTemplateSpace() {
        return this.classTemplateSpace;
    }

    public String getClassTemplateName() {
        return this.classTemplateName;
    }

    public String getClassTemplateFullName() {
        return this.classTemplateFullName;
    }

    public String getClassSheetSpace() {
        return this.classSheetSpace;
    }

    public String getClassSheetName() {
        return this.classSheetName;
    }

    public String getClassSheetFullName() {
        return this.classSheetFullName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check(XWikiContext context) throws XWikiException {
        Set set = this.databasesInitedMap;
        synchronized (set) {
            if (!this.databasesInitedMap.contains(context.getDatabase())) {
                this.databasesInitedMap.add(context.getDatabase());
                this.checkClassDocument(context);
                this.checkClassSheetDocument(context);
                this.checkClassTemplateDocument(context);
            }
        }
    }

    private void checkClassDocument(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        try {
            doc = xwiki.getDocument(this.getClassFullName(), context);
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            doc.setSpace(this.getClassSpace());
            doc.setName(this.getClassName());
            doc.setParent(DEFAULT_XWIKICLASS_PARENT);
            needsUpdate = true;
        }
        this.baseClass = doc.getxWikiClass();
        if (doc.isNew() || (needsUpdate |= this.updateBaseClass(this.baseClass))) {
            xwiki.saveDocument(doc, context);
        }
    }

    public String getClassSheetDefaultContent() {
        return this.classSheetDefaultContent;
    }

    private String getResourceDocumentContent(String path) {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(path);
        if (in != null) {
            try {
                StringBuffer content = new StringBuffer(in.available());
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String str = reader.readLine();
                while (str != null) {
                    content.append(str);
                    content.append('\n');
                    str = reader.readLine();
                }
                return content.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private void checkClassSheetDocument(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        try {
            doc = xwiki.getDocument(this.getClassSheetFullName(), context);
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            doc.setSpace(this.getClassSheetSpace());
            doc.setName(this.getClassSheetName());
            doc.setParent(this.getClassFullName());
            needsUpdate = true;
        }
        if (doc.isNew()) {
            String content = this.getResourceDocumentContent(DOCUMENTCONTENT_SHEET_PREFIX + this.getClassSheetFullName() + DOCUMENTCONTENT_EXT);
            doc.setContent(content != null ? content : this.getClassSheetDefaultContent());
        }
        if (doc.isNew() || needsUpdate) {
            xwiki.saveDocument(doc, context);
        }
    }

    public String getClassTemplateDefaultContent() {
        return this.classTemplateDefaultContent;
    }

    private void checkClassTemplateDocument(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        try {
            doc = xwiki.getDocument(this.getClassTemplateFullName(), context);
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            doc.setSpace(this.getClassTemplateSpace());
            doc.setName(this.getClassTemplateName());
            needsUpdate = true;
        }
        if (doc.getObject(this.getClassFullName()) == null) {
            doc.createNewObject(this.getClassFullName(), context);
            needsUpdate = true;
        }
        if (doc.isNew()) {
            String content = this.getResourceDocumentContent(DOCUMENTCONTENT_TEMPLATE_PREFIX + this.getClassTemplateFullName() + DOCUMENTCONTENT_EXT);
            doc.setContent(content != null ? content : this.getClassTemplateDefaultContent());
            doc.setParent(this.getClassFullName());
        }
        if (doc.isNew() || (needsUpdate |= this.updateClassTemplateDocument(doc))) {
            xwiki.saveDocument(doc, context);
        }
    }

    protected boolean updateClassTemplateDocument(XWikiDocument doc) {
        return false;
    }

    protected boolean updateBaseClass(BaseClass baseClass) {
        boolean needUpdate = false;
        if (!baseClass.getName().equals(this.getClassFullName())) {
            baseClass.setName(this.getClassFullName());
            needUpdate = true;
        }
        return needUpdate;
    }

    public BaseClass getBaseClass() {
        if (this.baseClass == null) {
            this.baseClass = new BaseClass();
            this.updateBaseClass(this.baseClass);
        }
        return this.baseClass;
    }

    public Document getClassDocument(XWikiContext context) throws XWikiException {
        this.check(context);
        return context.getWiki().getDocument(this.getClassFullName(), context).newDocument(context);
    }

    public Document getClassSheetDocument(XWikiContext context) throws XWikiException {
        this.check(context);
        return context.getWiki().getDocument(this.getClassSheetFullName(), context).newDocument(context);
    }

    public Document getClassTemplateDocument(XWikiContext context) throws XWikiException {
        this.check(context);
        return context.getWiki().getDocument(this.getClassTemplateFullName(), context).newDocument(context);
    }

    public boolean isInstance(XWikiDocument doc) {
        return doc.getObjectNumbers(this.getClassFullName()) > 0;
    }

    public boolean isInstance(Document doc) {
        return doc.getObjectNumbers(this.getClassFullName()) > 0;
    }

    public String getItemDocumentDefaultName(String itemName, XWikiContext context) {
        String name = context.getWiki().clearName(itemName, true, true, context);
        return this.getClassPrefix() + name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    public String getItemDocumentDefaultFullName(String itemName, XWikiContext context) {
        return this.getClassSpacePrefix() + "." + this.getItemDocumentDefaultName(itemName, context);
    }

    public String getItemDefaultName(String docFullName) {
        return docFullName.substring((this.getClassSpacePrefix() + "." + this.getClassPrefix()).length()).toLowerCase();
    }

    public XObjectDocument getXObjectDocument(String itemName, int objectId, boolean validate, XWikiContext context) throws XWikiException {
        XWikiDocument doc = context.getWiki().getDocument(this.getItemDocumentDefaultFullName(itemName, context), context);
        if (doc.isNew() || !this.isInstance(doc)) {
            throw new XObjectDocumentDoesNotExistException(itemName + " object does not exist");
        }
        return this.newXObjectDocument(doc, objectId, context);
    }

    public String createWhereClause(Object[][] fieldDescriptors, List parameterValues) {
        StringBuffer from = new StringBuffer(", BaseObject as obj");
        StringBuffer where = new StringBuffer(" where doc.fullName=obj.name and obj.className=?");
        parameterValues.add(this.getClassFullName());
        where.append(" and obj.name<>?");
        parameterValues.add(this.getClassTemplateFullName());
        String andSymbol = " and ";
        if (fieldDescriptors != null) {
            for (int i = 0; i < fieldDescriptors.length; ++i) {
                String fieldName = (String)fieldDescriptors[i][0];
                String type = (String)fieldDescriptors[i][1];
                Object value = fieldDescriptors[i][2];
                if (type != null) {
                    String fieldPrefix = "field" + i;
                    from.append(", " + type + " as " + fieldPrefix);
                    where.append(andSymbol + "obj.id=" + fieldPrefix + ".id.id");
                    where.append(andSymbol + fieldPrefix + ".name=" + HQL_PARAMETER_STRING);
                    parameterValues.add(fieldName);
                    if (value instanceof String) {
                        where.append(andSymbol + "lower(" + fieldPrefix + ".value)=" + HQL_PARAMETER_STRING);
                        parameterValues.add(((String)value).toLowerCase());
                        continue;
                    }
                    where.append(andSymbol + "" + fieldPrefix + ".value=" + HQL_PARAMETER_STRING);
                    parameterValues.add(value);
                    continue;
                }
                if (value instanceof String) {
                    where.append(" and lower(doc." + fieldName + ")=" + HQL_PARAMETER_STRING);
                    parameterValues.add(((String)value).toLowerCase());
                    continue;
                }
                where.append(" and doc." + fieldName + "=" + HQL_PARAMETER_STRING);
                parameterValues.add(value);
            }
        }
        return from.append(where).toString();
    }

    public List searchXObjectDocuments(XWikiContext context) throws XWikiException {
        return this.searchXObjectDocumentsByFields(null, context);
    }

    public List searchXObjectDocumentsByField(String fieldName, Object fieldValue, String fieldType, XWikiContext context) throws XWikiException {
        Object[][] fieldDescriptors = new Object[][]{{fieldName, fieldType, fieldValue}};
        return this.searchXObjectDocumentsByFields(fieldDescriptors, context);
    }

    public List searchXObjectDocumentsByFields(Object[][] fieldDescriptors, XWikiContext context) throws XWikiException {
        this.check(context);
        ArrayList parameterValues = new ArrayList();
        String where = this.createWhereClause(fieldDescriptors, parameterValues);
        return this.newXObjectDocumentList(context.getWiki().getStore().searchDocuments(where, parameterValues, context), context);
    }

    public XObjectDocument newXObjectDocument(XWikiDocument doc, int objId, XWikiContext context) throws XWikiException {
        return new DefaultXObjectDocument(this, doc, objId, context);
    }

    public XObjectDocument newXObjectDocument(String docFullName, int objId, XWikiContext context) throws XWikiException {
        return this.newXObjectDocument(context.getWiki().getDocument(docFullName, context), objId, context);
    }

    public XObjectDocument newXObjectDocument(XWikiContext context) throws XWikiException {
        return this.newXObjectDocument(new XWikiDocument(), 0, context);
    }

    public List newXObjectDocumentList(XWikiDocument document, XWikiContext context) throws XWikiException {
        ArrayList<XWikiDocument> documents = new ArrayList<XWikiDocument>(1);
        documents.add(document);
        return this.newXObjectDocumentList(documents, context);
    }

    public List newXObjectDocumentList(List documents, XWikiContext context) throws XWikiException {
        ArrayList<XObjectDocument> list = new ArrayList<XObjectDocument>(documents.size());
        for (XWikiDocument doc : documents) {
            Vector objects = doc.getObjects(this.getClassFullName());
            for (BaseObject bobject : objects) {
                if (bobject == null) continue;
                list.add(this.newXObjectDocument(doc, bobject.getNumber(), context));
            }
        }
        return list;
    }
}

