/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.DefaultXObjectDocument;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplicationClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XWikiApplication
extends DefaultXObjectDocument {
    private static final Pattern EXT_DOCNAME_PATTERN = Pattern.compile("^\\[(.*)\\]$");
    private static final String HQL_WHERE = "where";
    private static final String HQL_OR = " or ";
    private static final String HQL_AND = " and ";
    private static final String HQL_FILTER_DOC_EQUALS = "doc.fullName = ?";
    private static final String HQL_FILTER_DOC_PATTERN = "doc.fullName like ?";
    private static final String HQL_GROUP_OPEN = "(";
    private static final String HQL_GROUP_CLOSE = ")";

    public XWikiApplication(XWikiDocument xdoc, int objectId, XWikiContext context) throws XWikiException {
        super(XWikiApplicationClass.getInstance(context), xdoc, objectId, context);
    }

    public String getAppName() {
        return this.getStringValue("appname");
    }

    public void setAppName(String appname) {
        this.setStringValue("appname", appname);
    }

    public String getAppPrettyName() {
        return this.getStringValue("appprettyname");
    }

    public void setAppPrettyName(String appprettyname) {
        this.setStringValue("appprettyname", appprettyname);
    }

    public String getDescription() {
        return this.getStringValue("description");
    }

    public void setDescription(String description) {
        this.setStringValue("description", description);
    }

    public String getAppVersion() {
        return this.getStringValue("appversion");
    }

    public void setAppVersion(String appversion) {
        this.setStringValue("appversion", appversion);
    }

    public String getAppAuthors() {
        return this.getStringValue("appauthors");
    }

    public void setAppAuthors(String appauthors) {
        this.setStringValue("appauthors", appauthors);
    }

    public String getLicense() {
        return this.getStringValue("license");
    }

    public void setLicense(String license) {
        this.setStringValue("license", license);
    }

    public List getDependencies() {
        return this.getListValue("dependencies");
    }

    public void setDependencies(List dependencies) {
        this.setListValue("dependencies", dependencies);
    }

    public List getApplications() {
        return this.getListValue("applications");
    }

    public void setApplications(List applications) {
        this.setListValue("applications", applications);
    }

    public List getDocuments() {
        return this.getListValue("documents");
    }

    public void setDocuments(List documents) {
        this.setListValue("documents", documents);
    }

    public List getDocsToInclude() {
        return this.getListValue("docstoinclude");
    }

    public void setDocsToInclude(List docstoinclude) {
        this.setListValue("docstoinclude", docstoinclude);
    }

    public List getDocsToLink() {
        return this.getListValue("docstolink");
    }

    public void setDocsToLink(List docstolink) {
        this.setListValue("docstolink", docstolink);
    }

    public List getTranslationDocs() {
        return this.getListValue("translationdocs");
    }

    public void setTranslationDocs(List translationdocs) {
        this.setListValue("translationdocs", translationdocs);
    }

    public String toString() {
        return this.getAppName() + "-" + this.getAppVersion();
    }

    public int hashCode() {
        return this.getAppName() != null ? this.getAppName().hashCode() : "".hashCode();
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof XWikiApplication) {
            equals = this.getAppName() == null ? ((XWikiApplication)object).getAppName() == null : this.getAppName().equalsIgnoreCase(((XWikiApplication)object).getAppName());
        } else if (object instanceof String) {
            equals = this.getAppName() == null ? object == null : this.getAppName().equalsIgnoreCase((String)object);
        }
        return equals;
    }

    protected void addXWikiApplicationSet(XWikiApplication rootApplication, Collection applicationList, boolean recurse, XWikiContext context) throws XWikiException {
        List applications = this.getApplications();
        for (String appname : applications) {
            if (rootApplication != null && rootApplication.equals(appname) || applicationList.contains(appname)) continue;
            XWikiApplication app = ((XWikiApplicationClass)this.sclass).getApplication(appname, true, context);
            applicationList.add(app);
            if (!recurse) continue;
            app.addXWikiApplicationSet(rootApplication, applicationList, recurse, context);
        }
    }

    public Set getXWikiApplicationSet(boolean recurse, XWikiContext context) throws XWikiException {
        HashSet applicationSet = new HashSet();
        this.addXWikiApplicationSet(this, applicationSet, recurse, context);
        return applicationSet;
    }

    private static String createApplicationsHqlFilter(Collection applications, String type, Collection values, boolean includeAppDesc) throws XWikiException {
        StringBuffer filter = new StringBuffer();
        Iterator it = applications.iterator();
        while (it.hasNext()) {
            XWikiApplication app;
            String appFilter;
            if (filter.length() > 0) {
                filter.append(HQL_OR);
            }
            if ((appFilter = (app = (XWikiApplication)it.next()).createHqlFilter(type, values, false, includeAppDesc)).equals("")) continue;
            filter.append(HQL_GROUP_OPEN);
            filter.append(appFilter);
            filter.append(HQL_GROUP_CLOSE);
        }
        return filter.toString();
    }

    private String createHqlFilter(String type, Collection values, boolean recurse, boolean includeAppDesc) throws XWikiException {
        Set applications;
        String dependenciesFilter;
        StringBuffer filter = new StringBuffer();
        List patterns = this.getListValue(type);
        if (!patterns.isEmpty()) {
            String typeFilter;
            if (!type.equals("documents")) {
                filter.append(HQL_GROUP_OPEN);
                filter.append(this.createHqlFilter(this.getDocuments(), values, false));
                filter.append(HQL_GROUP_CLOSE);
            }
            if (!(typeFilter = this.createHqlFilter(this.getListValue(type), values, includeAppDesc)).equals("")) {
                if (filter.length() > 0) {
                    filter.append(HQL_AND);
                }
                filter.append(HQL_GROUP_OPEN);
                filter.append(typeFilter);
                filter.append(HQL_GROUP_CLOSE);
            }
        }
        if (recurse && !(dependenciesFilter = XWikiApplication.createApplicationsHqlFilter(applications = this.getXWikiApplicationSet(true, this.context), type, values, includeAppDesc)).equals("")) {
            if (filter.length() > 0) {
                filter.append(HQL_OR);
            }
            filter.append(dependenciesFilter);
        }
        return filter.toString();
    }

    private String createHqlFilter(Collection docsNamesToResolve, Collection values, boolean includeAppDesc) {
        StringBuffer filter = new StringBuffer();
        if (includeAppDesc) {
            filter.append(HQL_FILTER_DOC_EQUALS);
            values.add(this.getFullName());
        }
        Iterator it = docsNamesToResolve.iterator();
        while (it.hasNext()) {
            String docName;
            Matcher matcher;
            if (filter.length() > 0) {
                filter.append(HQL_OR);
            }
            if ((matcher = EXT_DOCNAME_PATTERN.matcher(docName = (String)it.next())).matches()) {
                filter.append(HQL_FILTER_DOC_PATTERN);
                values.add(matcher.group(1));
                continue;
            }
            filter.append(HQL_FILTER_DOC_EQUALS);
            values.add(docName);
        }
        return filter.toString();
    }

    private Set getDocsNamesByType(String type, boolean recurse, boolean includeAppDesc) throws XWikiException {
        ArrayList values = new ArrayList();
        String where = this.createHqlFilter(type, values, recurse, includeAppDesc);
        return where.equals("") ? Collections.EMPTY_SET : new HashSet(this.context.getWiki().getStore().searchDocumentsNames("where " + where, values, this.context));
    }

    private static Set getApplicationsDocsNamesByType(Collection applications, String type, boolean includeAppDesc) throws XWikiException {
        Set set = Collections.EMPTY_SET;
        if (applications.size() > 0) {
            ArrayList values = new ArrayList();
            String where = XWikiApplication.createApplicationsHqlFilter(applications, type, values, includeAppDesc);
            XWikiApplication app = (XWikiApplication)applications.iterator().next();
            set = where.equals("") ? Collections.EMPTY_SET : new HashSet(app.context.getWiki().getStore().searchDocumentsNames("where " + where, values, app.context));
        }
        return set;
    }

    public Set getDocumentsNames(boolean recurse, boolean includeAppDesc) throws XWikiException {
        return this.getDocsNamesByType("documents", recurse, includeAppDesc);
    }

    public Set getDocsNameToInclude(boolean recurse) throws XWikiException {
        return this.getDocsNamesByType("docstoinclude", recurse, false);
    }

    public static Set getDocsNameToInclude(Collection applications) throws XWikiException {
        return XWikiApplication.getApplicationsDocsNamesByType(applications, "docstoinclude", false);
    }

    public Set getDocsNameToLink(boolean recurse) throws XWikiException {
        return this.getDocsNamesByType("docstolink", recurse, false);
    }

    public static Set getDocsNameToLink(Collection applications) throws XWikiException {
        return XWikiApplication.getApplicationsDocsNamesByType(applications, "docstolink", false);
    }
}

