/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.notify.XWikiDocChangeNotificationInterface;
import com.xpn.xwiki.notify.XWikiNotificationRule;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerException;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.core.plugin.XWikiPluginMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplicationClass;
import com.xpn.xwiki.plugin.packaging.DocumentInfoAPI;
import com.xpn.xwiki.plugin.packaging.PackageAPI;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ApplicationManager
implements XWikiDocChangeNotificationInterface {
    protected static final Log LOG = LogFactory.getLog(ApplicationManager.class);
    private static final String XWIKIPREFERENCES = "XWiki.XWikiPreferences";
    private static final String XWIKIPREFERENCES_DOCUMENTBUNDLES = "documentBundles";
    private static final String XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP = ",";
    private static final String PACKAGEPLUGIN_NAME = "package";
    private static ApplicationManager instance;

    private ApplicationManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationManager getInstance() {
        Class<ApplicationManager> clazz = ApplicationManager.class;
        synchronized (ApplicationManager.class) {
            if (instance == null) {
                instance = new ApplicationManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public XWikiPluginMessageTool getMessageTool(XWikiContext context) {
        return ApplicationManagerMessageTool.getDefault(context);
    }

    public void notify(XWikiNotificationRule rule, XWikiDocument newdoc, XWikiDocument olddoc, int event, XWikiContext context) {
        try {
            if (newdoc != null && XWikiApplicationClass.isApplication(newdoc)) {
                List<XWikiApplication> appList = XWikiApplicationClass.getInstance(context).newXObjectDocumentList(newdoc, context);
                this.updateApplicationsTranslation(appList, this.getMessageTool(context).get("applicationmanager.plugin.comment.autoupdatetranslations", newdoc.getFullName()), context);
            }
        }
        catch (XWikiException e) {
            LOG.error((Object)this.getMessageTool(context).get("applicationmanager.plugin.log.autoupdatetranslations", newdoc.getFullName()), (Throwable)e);
        }
    }

    public XWikiApplication getRootApplication(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        String docFullName = xwiki.getXWikiPreference("rootapplication", null, context);
        if (docFullName != null && !(doc = xwiki.getDocument(docFullName, context)).isNew()) {
            return XWikiApplicationClass.getInstance(context).newXObjectDocument(doc, 0, context);
        }
        return null;
    }

    public List<XWikiApplication> getApplicationList(XWikiContext context) throws XWikiException {
        return XWikiApplicationClass.getInstance(context).searchXObjectDocuments(context);
    }

    public void createApplication(XWikiApplication userAppSuperDoc, boolean failOnExist, String comment, XWikiContext context) throws XWikiException {
        XWikiApplicationClass appClass;
        XWiki xwiki = context.getWiki();
        XWikiDocument docToSave = xwiki.getDocument((appClass = XWikiApplicationClass.getInstance(context)).getItemDocumentDefaultFullName(userAppSuperDoc.getAppName(), context), context);
        if (!docToSave.isNew() && appClass.isInstance(docToSave)) {
            if (failOnExist) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)this.getMessageTool(context).get("applicationmanager.plugin.error.applicationpagealreadyexists", userAppSuperDoc.getAppName()));
                }
                throw new ApplicationManagerException(60010, this.getMessageTool(context).get("applicationmanager.plugin.error.applicationpagealreadyexists", userAppSuperDoc.getAppName()));
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)this.getMessageTool(context).get("applicationmanager.plugin.error.applicationpagealreadyexists", userAppSuperDoc.getAppName()));
            }
        }
        XWikiApplication appSuperDocToSave = XWikiApplicationClass.getInstance(context).newXObjectDocument(docToSave, 0, context);
        appSuperDocToSave.mergeObject(userAppSuperDoc);
        appSuperDocToSave.save(comment);
        userAppSuperDoc.setFullName(appSuperDocToSave.getFullName());
    }

    public void deleteApplication(String appName, XWikiContext context) throws XWikiException {
        XWikiApplication app = this.getApplication(appName, context, true);
        app.delete();
    }

    public XWikiApplication getApplication(String appName, XWikiContext context, boolean validate) throws XWikiException {
        return XWikiApplicationClass.getInstance(context).getApplication(appName, validate, context);
    }

    public void reloadApplication(XWikiApplication app, String comment, XWikiContext context) throws XWikiException {
        this.updateApplicationTranslation(app, comment, context);
    }

    public void reloadAllApplications(String comment, XWikiContext context) throws XWikiException {
        List<XWikiApplication> applist = this.getApplicationList(context);
        for (XWikiApplication app : applist) {
            ApplicationManager.getInstance().updateApplicationTranslation(app, comment, context);
        }
    }

    public void updateApplicationsTranslation(Collection<XWikiApplication> applications, String comment, XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        XWikiDocument prefsDoc = xwiki.getDocument(XWIKIPREFERENCES, context);
        BaseObject prefsObject = prefsDoc.getObject(XWIKIPREFERENCES);
        if (prefsObject != null) {
            String documentBundles = prefsObject.getStringValue(XWIKIPREFERENCES_DOCUMENTBUNDLES);
            List translationPrefs = ListClass.getListFromString((String)documentBundles, (String)XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP, (boolean)true);
            boolean updateprefs = false;
            for (XWikiApplication app : applications) {
                updateprefs |= this.updateApplicationTranslation(translationPrefs, app);
            }
            if (updateprefs) {
                prefsObject.setStringValue(XWIKIPREFERENCES_DOCUMENTBUNDLES, StringUtils.join((Object[])translationPrefs.toArray(), (String)XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP));
                xwiki.saveDocument(prefsDoc, comment, context);
            }
        }
    }

    public void updateAllApplicationTranslation(String comment, XWikiContext context) throws XWikiException {
        this.updateApplicationsTranslation(this.getApplicationList(context), comment, context);
    }

    public void updateApplicationTranslation(XWikiApplication app, String comment, XWikiContext context) throws XWikiException {
        String documentBundles;
        List translationPrefs;
        boolean updateprefs;
        XWiki xwiki = context.getWiki();
        XWikiDocument prefsDoc = xwiki.getDocument(XWIKIPREFERENCES, context);
        BaseObject prefsObject = prefsDoc.getObject(XWIKIPREFERENCES);
        if (prefsObject != null && (updateprefs = this.updateApplicationTranslation(translationPrefs = ListClass.getListFromString((String)(documentBundles = prefsObject.getStringValue(XWIKIPREFERENCES_DOCUMENTBUNDLES)), (String)XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP, (boolean)true), app))) {
            prefsObject.setStringValue(XWIKIPREFERENCES_DOCUMENTBUNDLES, StringUtils.join((Object[])translationPrefs.toArray(), (String)XWIKIPREFERENCES_DOCUMENTBUNDLES_SEP));
            xwiki.saveDocument(prefsDoc, comment, context);
        }
    }

    public boolean updateApplicationTranslation(List<String> translationPrefs, XWikiApplication app) {
        boolean updateprefs = false;
        List<String> translationDocs = app.getTranslationDocs();
        for (String translationDoc : translationDocs) {
            if (translationPrefs.contains(translationDoc)) continue;
            translationPrefs.add(translationDoc);
            updateprefs = true;
        }
        return updateprefs;
    }

    public void exportApplicationXAR(String appName, boolean recurse, boolean withDocHistory, XWikiContext context) throws XWikiException, IOException {
        XWikiApplication app = ApplicationManager.getInstance().getApplication(appName, context, true);
        PackageAPI export = (PackageAPI)context.getWiki().getPluginApi(PACKAGEPLUGIN_NAME, context);
        export.setName(app.getAppName() + "-" + app.getAppVersion());
        Set<String> documents = app.getDocumentsNames(recurse, true);
        for (String documentName : documents) {
            export.add(documentName, 0);
        }
        export.setWithVersions(withDocHistory);
        export.export();
    }

    public void importApplication(XWikiDocument packageDoc, String packageName, String comment, XWikiContext context) throws XWikiException {
        XWikiAttachment packFile = packageDoc.getAttachment(packageName);
        if (packFile == null) {
            throw new ApplicationManagerException(0, this.getMessageTool(context).get("applicationmanager.plugin.error.import.packagedoesnotexists", packageName));
        }
        PackageAPI importer = (PackageAPI)context.getWiki().getPluginApi(PACKAGEPLUGIN_NAME, context);
        try {
            importer.Import(packFile.getContent(context));
        }
        catch (IOException e) {
            throw new ApplicationManagerException(0, this.getMessageTool(context).get("applicationmanager.plugin.error.import.import", packageName), e);
        }
        if (importer.install() == 0) {
            throw new ApplicationManagerException(0, this.getMessageTool(context).get("applicationmanager.plugin.error.import.install", packageName));
        }
        for (DocumentInfoAPI docinfo : importer.getFiles()) {
            XWikiDocument doc = docinfo.getDocInfo().getDoc();
            if (!XWikiApplicationClass.getInstance(context).isInstance(doc)) continue;
            this.reloadApplication(XWikiApplicationClass.getInstance(context).newXObjectDocument(doc, 0, context), comment, context);
        }
    }
}

