/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.lucene.AbstractXWikiRunnable;
import com.xpn.xwiki.plugin.lucene.IndexUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexRebuilder
extends AbstractXWikiRunnable {
    private static final Log LOG = LogFactory.getLog(IndexRebuilder.class);
    private IndexUpdater indexUpdater;
    private XWikiContext context;
    private static int retryInterval = 30000;
    private boolean rebuildInProgress = false;

    public IndexRebuilder(IndexUpdater indexUpdater, XWikiContext context) {
        this.indexUpdater = indexUpdater;
        if (indexUpdater.needInitialBuild) {
            this.startRebuildIndex(context);
            LOG.info((Object)"Launched initial lucene indexing");
        }
    }

    public synchronized int startRebuildIndex(XWikiContext context) {
        if (this.rebuildInProgress) {
            LOG.warn((Object)"Cannot launch rebuild because a build is in progress");
            return -2;
        }
        this.rebuildInProgress = true;
        this.context = context;
        Thread indexRebuilderThread = new Thread((Runnable)this, "Lucene Index Rebuilder");
        indexRebuilderThread.setDaemon(true);
        indexRebuilderThread.setPriority(3);
        indexRebuilderThread.start();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MDC.put((String)"url", (Object)"Lucene index rebuilder thread");
        LOG.debug((Object)"Starting lucene index rebuild");
        XWikiContext context = null;
        try {
            context = (XWikiContext)this.context.clone();
            this.context = null;
            context.remove((Object)"hibsession");
            context.remove((Object)"hibtransaction");
            context.remove((Object)"vcontext");
            this.initXWikiContainer(context);
            context.setRequest(null);
            context.setResponse(null);
            this.rebuildIndex(context);
        }
        catch (Exception e) {
            LOG.error((Object)"Error in lucene rebuild thread", (Throwable)e);
        }
        finally {
            this.rebuildInProgress = false;
            this.cleanupXWikiContainer(context);
            if (context != null) {
                context.getWiki().getStore().cleanUp(context);
            }
            MDC.remove((String)"url");
        }
        LOG.debug((Object)"Lucene index rebuild done");
    }

    private int rebuildIndex(XWikiContext context) {
        Collection<String> wikiServers;
        this.indexUpdater.cleanIndex();
        int retval = 0;
        XWiki xwiki = context.getWiki();
        if (xwiki.isVirtualMode()) {
            wikiServers = this.findWikiServers(context);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found " + wikiServers.size() + " virtual wikis:"));
                for (String wikiName : wikiServers) {
                    LOG.debug((Object)wikiName);
                }
            }
        } else {
            wikiServers = new ArrayList<String>();
            wikiServers.add(context.getDatabase());
        }
        for (String wikiName : wikiServers) {
            int wikiResult = this.indexWiki(wikiName, context);
            if (wikiResult <= 0) continue;
            retval += wikiResult;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int indexWiki(String wikiName, XWikiContext context) {
        LOG.info((Object)("Reading content of wiki " + wikiName));
        int retval = 0;
        XWiki xwiki = context.getWiki();
        String database = context.getDatabase();
        try {
            context.setDatabase(wikiName);
            List docNames = null;
            try {
                docNames = xwiki.getStore().searchDocumentsNames("", context);
            }
            catch (XWikiException ex) {
                LOG.warn((Object)String.format("Error getting document names for wiki [%s]. Internal error is: $s", wikiName, ex.getMessage()));
                int n = -1;
                context.setDatabase(database);
                return n;
            }
            for (String docName : docNames) {
                XWikiDocument document;
                try {
                    document = xwiki.getDocument(docName, context);
                }
                catch (XWikiException e2) {
                    LOG.error((Object)("error fetching document " + wikiName + ":" + docName), (Throwable)e2);
                    continue;
                }
                if (document != null) {
                    while (this.indexUpdater.getQueueSize() > (long)this.indexUpdater.maxQueueSize) {
                        try {
                            context.getWiki().getStore().cleanUp(context);
                            Thread.sleep(retryInterval);
                        }
                        catch (InterruptedException e) {
                            int n = -2;
                            context.setDatabase(database);
                            return n;
                        }
                    }
                    this.indexUpdater.add(document, context);
                    ++retval;
                    retval += this.addTranslationsOfDocument(document, context);
                    retval += this.indexUpdater.addAttachmentsOfDocument(document, context);
                    retval += this.addObjectsOfDocument(document, context);
                    continue;
                }
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("XWiki delivered null for document name " + wikiName + ":" + docName));
            }
        }
        finally {
            context.setDatabase(database);
        }
        return retval;
    }

    private int addObjectsOfDocument(XWikiDocument document, XWikiContext wikiContext) {
        int retval = 0;
        if (document.hasElement(2)) {
            retval += document.getxWikiObjects().size();
            this.indexUpdater.addObject(document, wikiContext);
        }
        return retval;
    }

    protected int addTranslationsOfDocument(XWikiDocument document, XWikiContext wikiContext) {
        List translations;
        int retval = 0;
        try {
            translations = document.getTranslationList(wikiContext);
        }
        catch (XWikiException e) {
            LOG.error((Object)("error getting list of translations from document " + document.getFullName()), (Throwable)e);
            e.printStackTrace();
            return 0;
        }
        for (String lang : translations) {
            try {
                this.indexUpdater.add(document.getTranslatedDocument(lang, wikiContext), wikiContext);
                ++retval;
            }
            catch (XWikiException e1) {
                LOG.error((Object)("Error getting translated document for document " + document.getFullName() + " and language " + lang), (Throwable)e1);
            }
        }
        return retval;
    }

    private Collection<String> findWikiServers(XWikiContext context) {
        List retval = Collections.emptyList();
        try {
            retval = context.getWiki().getVirtualWikisDatabaseNames(context);
            if (!retval.contains(context.getMainXWiki())) {
                retval.add(context.getMainXWiki());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting list of wiki servers!", (Throwable)e);
        }
        return retval;
    }
}

