/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.plugin.lucene.SearchResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.Hits;

public class SearchResults
extends Api {
    private final XWiki xwiki;
    private final Hits hits;
    private static final Log LOG = LogFactory.getLog(SearchResults.class);
    private List relevantResults;

    public SearchResults(Hits hits, XWiki xwiki, XWikiContext context) {
        super(context);
        this.hits = hits;
        this.xwiki = xwiki;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getRelevantResults() {
        if (this.relevantResults == null) {
            this.relevantResults = new ArrayList();
            int hitcount = this.hits.length();
            String database = this.context.getDatabase();
            try {
                for (int i = 0; i < hitcount; ++i) {
                    SearchResult result = null;
                    try {
                        result = new SearchResult(this.hits.doc(i), this.hits.score(i), this.xwiki);
                        this.context.setDatabase(result.getWiki());
                        String pageName = null;
                        if (result.isWikiContent()) {
                            pageName = result.getWiki() + ":" + result.getWeb() + "." + result.getName();
                        }
                        if (result == null || !result.isWikiContent() || !this.xwiki.checkAccess(pageName, "view") || !this.xwiki.exists(pageName)) continue;
                        this.relevantResults.add(result);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"error getting search result", (Throwable)e);
                        e.printStackTrace();
                    }
                }
            }
            finally {
                this.context.setDatabase(database);
            }
        }
        return this.relevantResults;
    }

    public boolean hasNext(String beginIndex, String items) {
        int itemCount = Integer.parseInt(items);
        int begin = Integer.parseInt(beginIndex);
        return begin + itemCount - 1 < this.getRelevantResults().size();
    }

    public boolean hasPrevious(String beginIndex) {
        return Integer.parseInt(beginIndex) > 1;
    }

    public int getNextIndex(String beginIndex, String items) {
        int itemCount = Integer.parseInt(items);
        int resultcount = this.getRelevantResults().size();
        int retval = Integer.parseInt(beginIndex) + itemCount;
        return retval > resultcount ? resultcount - itemCount + 1 : retval;
    }

    public int getPreviousIndex(String beginIndex, String items) {
        int retval = Integer.parseInt(beginIndex) - Integer.parseInt(items);
        return 0 < retval ? retval : 1;
    }

    public int getEndIndex(String beginIndex, String items) {
        int resultcount;
        int retval = Integer.parseInt(beginIndex) + Integer.parseInt(items) - 1;
        if (retval > (resultcount = this.getRelevantResults().size())) {
            return resultcount;
        }
        return retval;
    }

    public List getResults(String beginIndex, String items) {
        return this.getResults(Integer.parseInt(beginIndex), Integer.parseInt(items));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getResults(int beginIndex, int items) {
        int n;
        int listStartIndex = beginIndex - 1;
        int listEndIndex = listStartIndex + items;
        int resultcount = 0;
        ArrayList<SearchResult> relResults = this.relevantResults;
        if (relResults == null) {
            relResults = new ArrayList<SearchResult>();
            int hitcount = this.hits.length();
            String database = this.context.getDatabase();
            try {
                int i = 0;
                while (i < hitcount) {
                    SearchResult result = null;
                    try {
                        result = new SearchResult(this.hits.doc(i), this.hits.score(i), this.xwiki);
                        this.context.setDatabase(result.getWiki());
                        String pageName = null;
                        if (result.isWikiContent()) {
                            pageName = result.getWiki() + ":" + result.getWeb() + "." + result.getName();
                        }
                        if (result != null && result.isWikiContent() && this.xwiki.exists(pageName) && this.xwiki.checkAccess(pageName, "view")) {
                            if (resultcount >= listStartIndex) {
                                relResults.add(result);
                            }
                            if (++resultcount == listEndIndex) {
                                ArrayList<SearchResult> arrayList = relResults;
                                return arrayList;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"error getting search result", (Throwable)e);
                        e.printStackTrace();
                    }
                    ++i;
                }
                return relResults;
            }
            finally {
                this.context.setDatabase(database);
            }
        }
        resultcount = this.getRelevantResults().size();
        List list = this.getRelevantResults();
        if (listEndIndex < resultcount) {
            n = listEndIndex;
            return list.subList(listStartIndex, n);
        }
        n = resultcount;
        return list.subList(listStartIndex, n);
    }

    public List getResults() {
        return this.getRelevantResults();
    }

    public int getHitcount() {
        return this.getRelevantResults().size();
    }

    public int getTotalHitcount() {
        return this.hits.length();
    }
}

