/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.mailsender;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.mailsender.Mail;
import com.xpn.xwiki.plugin.mailsender.MailConfiguration;
import com.xpn.xwiki.plugin.mailsender.MailSender;
import com.xpn.xwiki.plugin.mailsender.MailSenderPlugin;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;

public class MailSenderPluginApi
extends PluginApi
implements MailSender {
    private static final Log LOG = LogFactory.getLog(MailSenderPluginApi.class);

    public MailSenderPluginApi(MailSenderPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
    }

    private MailSenderPlugin getMailSenderPlugin() {
        return (MailSenderPlugin)this.getProtectedPlugin();
    }

    public int sendHtmlMessage(String from, String to, String cc, String bcc, String subject, String body, String alternative, List attachments) {
        Mail email = new Mail();
        email.setSubject(subject);
        email.setFrom(from);
        email.setTo(to);
        email.setCc(cc);
        email.setBcc(bcc);
        email.setTextPart(alternative);
        email.setHtmlPart(body);
        email.setAttachments(attachments);
        return this.sendMail(email);
    }

    public int sendTextMessage(String from, String to, String subject, String message) {
        Mail email = new Mail();
        email.setSubject(subject);
        email.setTextPart(message);
        email.setFrom(from);
        email.setTo(to);
        return this.sendMail(email);
    }

    public int sendTextMessage(String from, String to, String cc, String bcc, String subject, String message, List attachments) {
        Mail email = new Mail();
        email.setSubject(subject);
        email.setTextPart(message);
        email.setFrom(from);
        email.setTo(to);
        email.setCc(cc);
        email.setBcc(bcc);
        email.setAttachments(attachments);
        return this.sendMail(email);
    }

    public int sendMessageFromTemplate(String from, String to, String cc, String bcc, String language, String documentFullName, VelocityContext vcontext) {
        try {
            return this.getMailSenderPlugin().sendMailFromTemplate(documentFullName, from, to, cc, bcc, language, vcontext, this.context);
        }
        catch (Exception e) {
            this.context.put((Object)"error", (Object)e.getMessage());
            LOG.error((Object)"sendMessageFromTemplate", (Throwable)e);
            return -1;
        }
    }

    public Mail createMail() {
        return new Mail();
    }

    public int sendMail(Mail mail) {
        int result = 0;
        try {
            this.getMailSenderPlugin().sendMail(mail, this.context);
        }
        catch (Exception e) {
            this.context.put((Object)"error", (Object)e.getMessage());
            LOG.error((Object)("Failed to send email [" + mail.toString() + "]"), (Throwable)e);
            result = -1;
        }
        return result;
    }

    public MailConfiguration createMailConfiguration(XWiki xwiki) {
        return new MailConfiguration(xwiki);
    }

    public int sendMail(Mail mail, MailConfiguration mailConfiguration) {
        int result = 0;
        try {
            this.getMailSenderPlugin().sendMail(mail, mailConfiguration, this.context);
        }
        catch (Exception e) {
            this.context.put((Object)"error", (Object)e.getMessage());
            LOG.error((Object)("Failed to send email [" + mail.toString() + "] using mail configuration [" + mailConfiguration.toString() + "]"), (Throwable)e);
            result = -1;
        }
        return result;
    }
}

