/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.scheduler;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.scheduler.JobState;
import com.xpn.xwiki.plugin.scheduler.SchedulerPluginApi;
import com.xpn.xwiki.plugin.scheduler.SchedulerPluginException;
import com.xpn.xwiki.plugin.scheduler.StatusListener;
import com.xpn.xwiki.plugin.scheduler.XWikiServletRequestStub;
import com.xpn.xwiki.plugin.scheduler.XWikiServletResponseStub;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerPlugin
extends XWikiDefaultPlugin {
    private static final Log LOG = LogFactory.getLog(SchedulerPlugin.class);
    public static final String XWIKI_JOB_CLASS = "XWiki.SchedulerJobClass";
    private Scheduler scheduler;

    public SchedulerPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(XWikiContext context) {
        try {
            String initialDb = !context.getDatabase().equals("") ? context.getDatabase() : context.getMainXWiki();
            List wikiServers = Collections.emptyList();
            if (context.getWiki().isVirtualMode()) {
                try {
                    wikiServers = context.getWiki().getVirtualWikisDatabaseNames(context);
                    if (!wikiServers.contains(context.getMainXWiki())) {
                        wikiServers.add(context.getMainXWiki());
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"error getting list of wiki servers!", (Throwable)e);
                }
            } else {
                wikiServers = new ArrayList();
                wikiServers.add(context.getMainXWiki());
            }
            try {
                for (String wikiName : wikiServers) {
                    context.setDatabase(wikiName);
                    this.updateSchedulerJobClass(context);
                }
            }
            finally {
                context.setDatabase(initialDb);
            }
            System.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
            System.setProperty("org.quartz.threadPool.makeThreadsDaemons", "true");
            this.setScheduler(this.getDefaultSchedulerInstance());
            this.setStatusListener();
            this.getScheduler().start();
            try {
                for (String wikiName : wikiServers) {
                    context.setDatabase(wikiName);
                    this.restoreExistingJobs(context);
                }
            }
            finally {
                context.setDatabase(initialDb);
            }
        }
        catch (SchedulerException e) {
            LOG.error((Object)"Failed to start the scheduler", (Throwable)e);
        }
        catch (SchedulerPluginException e) {
            LOG.error((Object)"Failed to initialize the scheduler", (Throwable)((Object)e));
        }
        super.init(context);
    }

    public void virtualInit(XWikiContext context) {
        super.virtualInit(context);
    }

    private XWikiContext prepareJobStubContext(BaseObject job, XWikiContext context) throws SchedulerPluginException {
        XWikiURLFactory xurf;
        String cLang;
        boolean jobNeedsUpdate = true;
        String cUser = job.getStringValue("contextUser");
        if (cUser.equals("")) {
            cUser = context.getUser();
            job.setStringValue("contextUser", cUser);
            jobNeedsUpdate = true;
        }
        if ((cLang = job.getStringValue("contextLang")).equals("")) {
            cLang = context.getLanguage();
            job.setStringValue("contextLang", cLang);
            jobNeedsUpdate = true;
        }
        String iDb = context.getDatabase();
        String cDb = job.getStringValue("contextDatabase");
        if (cDb.equals("") || !cDb.equals(iDb)) {
            cDb = context.getDatabase();
            job.setStringValue("contextDatabase", cDb);
            jobNeedsUpdate = true;
        }
        if (jobNeedsUpdate) {
            try {
                context.setDatabase(cDb);
                XWikiDocument jobHolder = context.getWiki().getDocument(job.getName(), context);
                BaseObject jObj = jobHolder.getObject(XWIKI_JOB_CLASS, job.getNumber());
                jobHolder.setMinorEdit(true);
                context.getWiki().saveDocument(jobHolder, context);
            }
            catch (XWikiException e) {
                throw new SchedulerPluginException(90011, "Failed to prepare context for job with job name " + job.getStringValue("jobName"), e);
            }
            finally {
                context.setDatabase(iDb);
            }
        }
        XWikiContext scontext = (XWikiContext)context.clone();
        scontext.setWiki(context.getWiki());
        context.getWiki().getStore().cleanUp(context);
        XWikiServletRequestStub dummy = new XWikiServletRequestStub();
        dummy.setHost(context.getRequest().getHeader("x-forwarded-host"));
        dummy.setScheme(context.getRequest().getScheme());
        XWikiServletRequest request = new XWikiServletRequest((HttpServletRequest)dummy);
        scontext.setRequest((XWikiRequest)request);
        XWikiServletResponseStub stub = new XWikiServletResponseStub();
        scontext.setResponse((XWikiResponse)stub);
        scontext.setUser(cUser);
        scontext.setLanguage(cLang);
        scontext.setDatabase(cDb);
        scontext.setMainXWiki(context.getMainXWiki());
        if (scontext.getURL() == null) {
            try {
                scontext.setURL(new URL("http://www.mystuburl.com/"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((xurf = context.getURLFactory()) == null) {
            xurf = context.getWiki().getURLFactoryService().createURLFactory(context.getMode(), context);
        }
        scontext.setURLFactory(xurf);
        try {
            XWikiDocument cDoc = context.getWiki().getDocument(job.getName(), context);
            scontext.setDoc(cDoc);
        }
        catch (Exception e) {
            throw new SchedulerPluginException(90011, "Failed to prepare context for job with job name " + job.getStringValue("jobName"), e);
        }
        return scontext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void restoreExistingJobs(XWikiContext context) throws SchedulerPluginException {
        String hql = ", BaseObject as obj where doc.web='Scheduler' and obj.name=doc.fullName and obj.className='XWiki.SchedulerJobClass'";
        try {
            List jobsDocsNames = context.getWiki().getStore().searchDocumentsNames(hql, context);
            for (String docName : jobsDocsNames) {
                XWikiDocument jobDoc = context.getWiki().getDocument(docName, context);
                BaseObject jobObj = jobDoc.getObject(XWIKI_JOB_CLASS);
                String jobName = jobObj.getStringValue("jobName");
                try {
                    String status = jobObj.getStringValue("status");
                    if (status.equals("Normal") || status.equals("Paused")) {
                        this.scheduleJob(jobObj, context);
                    }
                    if (!status.equals("Paused")) continue;
                    this.pauseJob(jobObj, context);
                }
                catch (XWikiException e) {
                    throw new SchedulerPluginException(90008, "Failed to restore job with job name " + jobName, e);
                    return;
                }
            }
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90009, "Failed to restore existing scheduler jobs", e);
        }
    }

    public JobState getJobStatus(BaseObject object, XWikiContext context) throws SchedulerException {
        int state = this.getScheduler().getTriggerState(this.getObjectUniqueId(object, context), "DEFAULT");
        return new JobState(state);
    }

    public boolean scheduleJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        boolean scheduled = true;
        try {
            JobDataMap data = new JobDataMap();
            String xjob = this.getObjectUniqueId(object, context);
            JobDetail job = new JobDetail(xjob, "DEFAULT", Class.forName(object.getStringValue("jobClass")));
            CronTrigger trigger = new CronTrigger(xjob, "DEFAULT", xjob, "DEFAULT", object.getStringValue("cron"));
            XWikiContext stubContext = this.prepareJobStubContext(object, context);
            data.put((Object)"context", (Object)stubContext);
            data.put((Object)"xwiki", (Object)new com.xpn.xwiki.api.XWiki(context.getWiki(), stubContext));
            data.put((Object)"xjob", (Object)object);
            job.setJobDataMap(data);
            this.getScheduler().addJob(job, true);
            JobState status = this.getJobStatus(object, context);
            switch (status.getState()) {
                case 1: {
                    break;
                }
                case 0: {
                    if (this.getTrigger(object, context).compareTo((Object)trigger) != 0) {
                        LOG.debug((Object)("Reschedule Job : " + object.getStringValue("jobName")));
                    }
                    this.getScheduler().rescheduleJob(trigger.getName(), trigger.getGroup(), (Trigger)trigger);
                    break;
                }
                case -1: {
                    LOG.debug((Object)("Schedule Job : " + object.getStringValue("jobName")));
                    this.getScheduler().scheduleJob((Trigger)trigger);
                    LOG.info((Object)("XWiki Job Status :" + object.getStringValue("status")));
                    if (object.getStringValue("status").equals("Paused")) {
                        this.getScheduler().pauseJob(xjob, "DEFAULT");
                        this.saveStatus("Paused", object, context);
                        break;
                    }
                    this.saveStatus("Normal", object, context);
                    break;
                }
                default: {
                    LOG.debug((Object)("Schedule Job : " + object.getStringValue("jobName")));
                    this.getScheduler().scheduleJob((Trigger)trigger);
                    this.saveStatus("Normal", object, context);
                    break;
                }
            }
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90004, "Error while scheduling job " + object.getStringValue("jobName"), e);
        }
        catch (ParseException e) {
            throw new SchedulerPluginException(90005, "Error while parsing cron expression for job " + object.getStringValue("jobName"), e);
        }
        catch (ClassNotFoundException e) {
            throw new SchedulerPluginException(90006, "Error while loading job class for job : " + object.getStringValue("jobName"), e);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90006, "Error while saving job status for job : " + object.getStringValue("jobName"), e);
        }
        return scheduled;
    }

    public void pauseJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        try {
            this.getScheduler().pauseJob(this.getObjectUniqueId(object, context), "DEFAULT");
            this.saveStatus("Paused", object, context);
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90002, "Error occured while trying to pause job " + object.getStringValue("jobName"), e);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90002, "Error occured while trying to save status of job " + object.getStringValue("jobName"), e);
        }
    }

    public void resumeJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        try {
            this.getScheduler().resumeJob(this.getObjectUniqueId(object, context), "DEFAULT");
            this.saveStatus("Normal", object, context);
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90003, "Error occured while trying to resume job " + object.getStringValue("jobName"), e);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90003, "Error occured while trying to save status of job " + object.getStringValue("jobName"), e);
        }
    }

    public void triggerJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        try {
            this.getScheduler().triggerJob(this.getObjectUniqueId(object, context), "DEFAULT");
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90012, "Error occured while trying to trigger job " + object.getStringValue("jobName"), e);
        }
    }

    public void unscheduleJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        try {
            this.getScheduler().deleteJob(this.getObjectUniqueId(object, context), "DEFAULT");
            this.saveStatus("None", object, context);
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90006, "Error while unscheduling job " + object.getStringValue("jobName"), e);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90006, "Error while saving status of job " + object.getStringValue("jobName"), e);
        }
    }

    private Trigger getTrigger(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        Trigger trigger;
        String job = this.getObjectUniqueId(object, context);
        try {
            trigger = this.getScheduler().getTrigger(job, "DEFAULT");
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90006, "Error while getting trigger for job " + job, e);
        }
        if (trigger == null) {
            throw new SchedulerPluginException(90007, "Job does not exists");
        }
        return trigger;
    }

    public Date getPreviousFireTime(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        return this.getTrigger(object, context).getPreviousFireTime();
    }

    public Date getNextFireTime(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        return this.getTrigger(object, context).getNextFireTime();
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new SchedulerPluginApi((SchedulerPlugin)plugin, context);
    }

    public String getName() {
        return "scheduler";
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    private synchronized Scheduler getDefaultSchedulerInstance() throws SchedulerPluginException {
        Scheduler scheduler;
        try {
            scheduler = StdSchedulerFactory.getDefaultScheduler();
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90007, "Error getting default Scheduler instance", e);
        }
        return scheduler;
    }

    private void setStatusListener() throws SchedulerPluginException {
        StatusListener listener = new StatusListener();
        try {
            this.getScheduler().addSchedulerListener((SchedulerListener)listener);
            this.getScheduler().addGlobalJobListener((JobListener)listener);
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90001, "Error while initializing the status listener", e);
        }
    }

    private void saveStatus(String status, BaseObject object, XWikiContext context) throws XWikiException {
        XWikiDocument jobHolder = context.getWiki().getDocument(object.getName(), context);
        object.setStringValue("status", status);
        jobHolder.setMinorEdit(true);
        context.getWiki().saveDocument(jobHolder, context);
    }

    private String getObjectUniqueId(BaseObject object, XWikiContext context) {
        return context.getDatabase() + ":" + object.getName() + "_" + object.getNumber();
    }

    private void updateSchedulerJobClass(XWikiContext context) throws SchedulerPluginException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        try {
            doc = xwiki.getDocument(XWIKI_JOB_CLASS, context);
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            doc.setFullName(XWIKI_JOB_CLASS);
            needsUpdate = true;
        }
        BaseClass bclass = doc.getxWikiClass();
        bclass.setName(XWIKI_JOB_CLASS);
        needsUpdate |= bclass.addTextField("jobName", "Job Name", 60);
        needsUpdate |= bclass.addTextAreaField("jobDescription", "Job Description", 45, 10);
        needsUpdate |= bclass.addTextField("jobClass", "Job Class", 60);
        needsUpdate |= bclass.addTextField("status", "Status", 30);
        needsUpdate |= bclass.addTextField("cron", "Cron Expression", 30);
        needsUpdate |= bclass.addTextAreaField("script", "Job Script", 60, 10);
        TextAreaClass scriptField = (TextAreaClass)bclass.getField("script");
        if (scriptField.getEditor() != "puretext") {
            scriptField.setStringValue("editor", "PureText");
            needsUpdate = true;
        }
        needsUpdate |= bclass.addTextField("contextUser", "Job execution context user", 30);
        needsUpdate |= bclass.addTextField("contextLang", "Job execution context lang", 30);
        needsUpdate |= bclass.addTextField("contextDatabase", "Job execution context database", 30);
        if (StringUtils.isBlank((String)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator("superadmin");
        }
        if (StringUtils.isBlank((String)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthor(doc.getCreator());
        }
        if (StringUtils.isBlank((String)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("XWiki.XWikiClasses");
        }
        if (StringUtils.isBlank((String)doc.getTitle())) {
            needsUpdate = true;
            doc.setTitle("XWiki Scheduler Job Class");
        }
        if (StringUtils.isBlank((String)doc.getContent()) || !XWikiDocument.XWIKI20_SYNTAXID.equals(doc.getSyntaxId())) {
            needsUpdate = true;
            doc.setContent("{{include document=\"XWiki.ClassSheet\" /}}");
            doc.setSyntaxId(XWikiDocument.XWIKI20_SYNTAXID);
        }
        if (needsUpdate) {
            try {
                xwiki.saveDocument(doc, context);
            }
            catch (XWikiException ex) {
                throw new SchedulerPluginException(90000, "Error while saving XWiki.SchedulerJobClass class document in XWiki", ex);
            }
        }
    }
}

