/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web.sx;

import com.xpn.xwiki.web.sx.Extension;
import com.xpn.xwiki.web.sx.SxCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class JsExtension
implements Extension {
    private static final Log LOG = LogFactory.getLog(JsExtension.class);

    public String getClassName() {
        return "XWiki.JavaScriptExtension";
    }

    public String getContentType() {
        return "text/javascript; charset=UTF-8";
    }

    public SxCompressor getCompressor() {
        return new JsCompressor();
    }

    private class JsCompressor
    implements SxCompressor {
        private JsCompressor() {
        }

        public String compress(String source) {
            try {
                CustomErrorReporter reporter = new CustomErrorReporter();
                JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)new StringReader(source), (ErrorReporter)reporter);
                StringWriter out = new StringWriter();
                compressor.compress((Writer)out, -1, true, false, false, false);
                return out.toString();
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to write the compressed output: " + ex.getMessage()));
            }
            catch (EvaluatorException ex) {
                LOG.info((Object)("Failed to parse the JS extension: " + ex.getMessage()));
            }
            catch (Exception ex) {
                LOG.warn((Object)("Failed to compress JS extension: " + ex.getMessage()));
            }
            return source;
        }

        private class CustomErrorReporter
        implements ErrorReporter {
            private CustomErrorReporter() {
            }

            public void error(String message, String filename, int lineNumber, String context, int column) {
                LOG.warn((Object)MessageFormat.format("Error at line {2}, column {3}: {0}. Caused by: [{1}]", message, context, lineNumber, column));
            }

            public EvaluatorException runtimeError(String message, String filename, int lineNumber, String context, int column) {
                LOG.error((Object)MessageFormat.format("Runtime error minimizing JSX object: {0}", message));
                return null;
            }

            public void warning(String message, String filename, int lineNumber, String context, int column) {
                LOG.info((Object)MessageFormat.format("Warning at line {2}, column {3}: {0}. Caused by: [{1}]", message, context, lineNumber, column));
            }
        }
    }
}

