/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web.sx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.web.sx.Extension;
import com.xpn.xwiki.web.sx.SxSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SxDocumentSource
implements SxSource {
    private static final String CONTENT_PROPERTY_NAME = "code";
    private static final String PARSE_CONTENT_PROPERTY_NAME = "parse";
    private static final String CACHE_POLICY_PROPERTY_NAME = "cache";
    private static final Log LOG = LogFactory.getLog(SxDocumentSource.class);
    private XWikiDocument document;
    private XWikiContext context;
    private Extension extension;

    public SxDocumentSource(XWikiContext context, Extension extension) {
        this.context = context;
        this.document = context.getDoc();
        this.extension = extension;
    }

    public SxSource.CachePolicy getCachePolicy() {
        SxSource.CachePolicy finalCache = SxSource.CachePolicy.LONG;
        if (this.document.getObjects(this.extension.getClassName()) != null) {
            for (BaseObject sxObj : this.document.getObjects(this.extension.getClassName())) {
                if (sxObj == null) continue;
                try {
                    SxSource.CachePolicy cache = SxSource.CachePolicy.valueOf(StringUtils.upperCase((String)StringUtils.defaultIfEmpty((String)sxObj.getStringValue(CACHE_POLICY_PROPERTY_NAME), (String)"LONG")));
                    if (cache.compareTo(finalCache) <= 0) continue;
                    finalCache = cache;
                }
                catch (Exception ex) {
                    LOG.warn((Object)String.format("SX object [%s#%s] has an invalid cache policy: [%s]", this.document.getFullName(), sxObj.getStringValue("name"), sxObj.getStringValue(CACHE_POLICY_PROPERTY_NAME)));
                }
            }
        }
        return finalCache;
    }

    public String getContent() {
        StringBuilder resultBuilder = new StringBuilder();
        if (this.document.getObjects(this.extension.getClassName()) != null) {
            for (BaseObject sxObj : this.document.getObjects(this.extension.getClassName())) {
                if (sxObj == null) continue;
                String sxContent = sxObj.getLargeStringValue(CONTENT_PROPERTY_NAME);
                int parse = sxObj.getIntValue(PARSE_CONTENT_PROPERTY_NAME);
                if (parse == 1) {
                    sxContent = this.context.getWiki().getRenderingEngine().interpretText(sxContent, this.document, this.context);
                }
                resultBuilder.append(sxContent + "\n");
            }
        }
        return resultBuilder.toString();
    }

    public long getLastModifiedDate() {
        return this.document.getDate().getTime();
    }
}

