/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Context;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.mailsender.MailSenderPluginApi;
import com.xpn.xwiki.plugin.watchlist.WatchListPlugin;
import com.xpn.xwiki.plugin.watchlist.WatchListPluginApi;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class WatchListJob
implements Job {
    protected XWiki xwiki = null;
    protected BaseObject xjob = null;
    protected Context xcontext = null;
    protected WatchListPluginApi notificationPlugin = null;
    protected int interval = 0;

    public void init(JobExecutionContext context) {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        this.xwiki = (XWiki)data.get((java.lang.Object)"xwiki");
        this.xcontext = (Context)data.get((java.lang.Object)"context");
        this.notificationPlugin = (WatchListPluginApi)this.xwiki.getPlugin("watchlist");
        this.xjob = (BaseObject)data.get((java.lang.Object)"xjob");
        this.interval = Integer.parseInt(this.xjob.getLargeStringValue("script"));
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.init(context);
        try {
            List subscribers = this.retrieveNotificationSubscribers();
            if (subscribers != null && subscribers.size() > 0) {
                List updatedDocuments = this.retrieveUpdatedDocuments();
                Iterator it = subscribers.iterator();
                while (it.hasNext()) {
                    try {
                        List matchingDocuments;
                        Document subscriber = this.xwiki.getDocument((String)it.next());
                        Object userObj = subscriber.getObject("XWiki.XWikiUsers");
                        Object notificationCriteria = subscriber.getObject(WatchListPlugin.WATCHLIST_CLASS);
                        if (userObj == null || notificationCriteria == null || (matchingDocuments = this.filter(updatedDocuments, notificationCriteria, subscriber.getFullName())).size() <= 0) continue;
                        this.sendNotificationMessage(subscriber, matchingDocuments);
                    }
                    catch (XWikiException e) {}
                }
            }
        }
        catch (XWikiException xWikiException) {
            // empty catch block
        }
    }

    private List filter(List updatedDocuments, Object notificationCriteria, String subscriber) throws XWikiException {
        String spaceCriterion = (String)notificationCriteria.display("spaces", "view");
        String documentCriterion = (String)notificationCriteria.display("documents", "view");
        String query = (String)notificationCriteria.display("query", "view");
        ArrayList<String> watchedDocuments = new ArrayList<String>();
        if (spaceCriterion.length() == 0 && documentCriterion.length() == 0 && query.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> filteredDocumentList = new ArrayList<String>();
        String[] watchedSpaces = spaceCriterion.split(",");
        String[] docArray = documentCriterion.split(",");
        for (int i = 0; i < docArray.length; ++i) {
            watchedDocuments.add(docArray[i]);
        }
        if (query.length() > 0) {
            List queryDocuments = this.xwiki.searchDocuments(query);
            watchedDocuments.addAll(queryDocuments);
        }
        Iterator updatedDocumentsIt = updatedDocuments.iterator();
        block1: while (updatedDocumentsIt.hasNext()) {
            String updatedDocument = (String)updatedDocumentsIt.next();
            String updatedDocumentSpace = this.xwiki.getDocument(updatedDocument).getSpace();
            boolean documentAdded = false;
            for (int i = 0; i < watchedSpaces.length; ++i) {
                if (!updatedDocumentSpace.equals(watchedSpaces[i]) || !this.xwiki.hasAccessLevel("view", subscriber, updatedDocument)) continue;
                filteredDocumentList.add(updatedDocument);
                documentAdded = true;
                break;
            }
            if (documentAdded) continue;
            Iterator watchedDocumentIt = watchedDocuments.iterator();
            while (watchedDocumentIt.hasNext()) {
                String watchedDocumentName = (String)watchedDocumentIt.next();
                if (!updatedDocument.equals(watchedDocumentName) || !this.xwiki.hasAccessLevel("view", subscriber, updatedDocument)) continue;
                filteredDocumentList.add(updatedDocument);
                continue block1;
            }
        }
        return filteredDocumentList;
    }

    protected List retrieveNotificationSubscribers() throws XWikiException {
        List userDocs = this.xwiki.searchDocuments(", BaseObject as obj, StringProperty as prop where obj.name=doc.fullName and obj.className='" + WatchListPlugin.WATCHLIST_CLASS + "' and prop.id.id=obj.id and prop.name='interval' " + "and prop.value='" + this.interval + "'");
        return userDocs;
    }

    protected List retrieveUpdatedDocuments() throws XWikiException {
        String updatedDocumentRequest = "where year(doc.date) = year(current_date()) and ";
        switch (this.interval) {
            case 1: {
                updatedDocumentRequest = updatedDocumentRequest + "month(doc.date) = month(current_date()) and day(doc.date) = day(current_date()) and hour(doc.date) > (hour(current_time()) - 1)";
                break;
            }
            case 2: {
                updatedDocumentRequest = updatedDocumentRequest + "month(doc.date) = month(current_date()) and day(doc.date) > (day(current_date()) - 1)";
                break;
            }
            case 3: {
                updatedDocumentRequest = updatedDocumentRequest + "month(doc.date) = month(current_date()) and day(doc.date) > (day(current_date()) - 7)";
                break;
            }
            case 4: {
                updatedDocumentRequest = updatedDocumentRequest + "month(doc.date) > (month(current_date()) - 1)";
            }
        }
        updatedDocumentRequest = updatedDocumentRequest + " order by doc.date desc";
        return this.xwiki.searchDocuments(updatedDocumentRequest);
    }

    protected void sendNotificationMessage(Document subscriber, List updatedDocuments) throws XWikiException {
        Object userObj = subscriber.getObject("XWiki.XWikiUsers");
        String emailAddr = (String)userObj.display("email", "view");
        if (emailAddr == null || emailAddr.length() == 0 || emailAddr.indexOf("@") < 0) {
            return;
        }
        VelocityContext vcontext = new VelocityContext();
        vcontext.put("pseudo", userObj.display("first_name", "view"));
        vcontext.put("documents", (java.lang.Object)updatedDocuments);
        vcontext.put("interval", (java.lang.Object)new Integer(this.interval));
        vcontext.put("xwiki", (java.lang.Object)this.xwiki);
        vcontext.put("context", (java.lang.Object)this.xcontext);
        String language = this.xwiki.getXWikiPreference("default_language", "en");
        MailSenderPluginApi emailService = (MailSenderPluginApi)this.xwiki.getPlugin("mailsender");
        if (emailService == null) {
            return;
        }
        String sender = this.xwiki.getXWikiPreference("admin_email", "mailer@xwiki.localdomain.com");
        int sendResult = emailService.sendMessageFromTemplate(sender, emailAddr, null, null, language, WatchListPlugin.WATCHLIST_EMAIL_TEMPLATE, vcontext);
    }
}

