/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.scheduler.SchedulerPlugin;
import com.xpn.xwiki.plugin.watchlist.WatchListPluginApi;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WatchListPlugin
extends XWikiDefaultPlugin
implements XWikiPluginInterface {
    public static String WATCHLIST_EMAIL_TEMPLATE = "XWiki.WatchListMessage";
    public static String WATCHLIST_EMAIL_JOB_COMMON_NAME = "Scheduler.WatchListJob";
    public static String WATCHLIST_CLASS = "XWiki.WatchListClass";
    public static final int WATCHLIST_INTERVAL_NEVER = 0;
    public static final int WATCHLIST_INTERVAL_HOUR = 1;
    public static final int WATCHLIST_INTERVAL_DAY = 2;
    public static final int WATCHLIST_INTERVAL_WEEK = 3;
    public static final int WATCHLIST_INTERVAL_MONTH = 4;
    public static final String ID = "watchlist";
    private static final Log log = LogFactory.getLog((Class)(class$com$xpn$xwiki$plugin$watchlist$WatchListPlugin == null ? (class$com$xpn$xwiki$plugin$watchlist$WatchListPlugin = WatchListPlugin.class$("com.xpn.xwiki.plugin.watchlist.WatchListPlugin")) : class$com$xpn$xwiki$plugin$watchlist$WatchListPlugin));
    static /* synthetic */ Class class$com$xpn$xwiki$plugin$watchlist$WatchListPlugin;

    public WatchListPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    public String getName() {
        return ID;
    }

    public void virtualInit(XWikiContext context) {
        super.virtualInit(context);
        try {
            this.initWatchListClass(context);
            this.initEmailTemplate(context);
            this.initWatchlistJobs(context);
        }
        catch (XWikiException e) {
            log.error((Object)"virtualInit", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void init(XWikiContext context) {
        super.init(context);
        try {
            this.initWatchListClass(context);
            this.initEmailTemplate(context);
            this.initWatchlistJobs(context);
        }
        catch (XWikiException e) {
            log.error((Object)"virtualInit", (Throwable)e);
            e.printStackTrace();
        }
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new WatchListPluginApi((WatchListPlugin)plugin, context);
    }

    protected Log getLogger() {
        return log;
    }

    protected BaseClass initWatchListClass(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        try {
            doc = xwiki.getDocument(WATCHLIST_CLASS, context);
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            String[] spaceAndName = WATCHLIST_CLASS.split(".");
            doc.setSpace(spaceAndName[0]);
            doc.setName(spaceAndName[1]);
            needsUpdate = true;
        }
        BaseClass bclass = doc.getxWikiClass();
        bclass.setName(WATCHLIST_CLASS);
        needsUpdate |= bclass.addStaticListField("interval", "Email notifications interval", "0=never|1=hourly|2=daily|3=weekly|4=monthly");
        needsUpdate |= bclass.addTextAreaField("spaces", "Space list, separated by commas", 40, 5);
        needsUpdate |= bclass.addTextAreaField("documents", "Document list, separated by commas", 40, 5);
        needsUpdate |= bclass.addTextAreaField("query", "Query (HQL)", 40, 5);
        String content = doc.getContent();
        if (content == null || content.equals("")) {
            needsUpdate = true;
            doc.setContent("1 NotificationRule");
        }
        if (needsUpdate) {
            xwiki.saveDocument(doc, context);
        }
        return bclass;
    }

    protected void initWatchListJob(int interval, String name, String description, String cron, XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        String jobClass = "com.xpn.xwiki.plugin.watchlist.WatchListJob";
        String docName = WATCHLIST_EMAIL_JOB_COMMON_NAME + interval;
        try {
            doc = xwiki.getDocument(docName, context);
            BaseObject obj = doc.getObject("XWiki.SchedulerJobClass");
            if (obj == null) {
                needsUpdate = true;
            }
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            String[] spaceAndName = docName.split(".");
            doc.setSpace(spaceAndName[0]);
            doc.setName(spaceAndName[1]);
            needsUpdate = true;
        }
        if (needsUpdate) {
            int index = doc.createNewObject("XWiki.SchedulerJobClass", context);
            BaseObject job = doc.getObject("XWiki.SchedulerJobClass", index);
            job.setStringValue("jobName", name);
            job.setStringValue("jobClass", jobClass);
            job.setStringValue("cron", cron);
            job.setLargeStringValue("script", Integer.toString(interval));
            job.setLargeStringValue("jobDescription", description);
            job.setStringValue("contextUser", "XWiki.Admin");
            job.setStringValue("contextLang", "en");
            job.setStringValue("contextDatabase", "xwiki");
            doc.setContent("#includeInContext('XWiki.SchedulerJobSheet')");
            doc.setAuthor("XWiki.Admin");
            doc.setCreator("XWiki.Admin");
            index = doc.createNewObject("XWiki.XWikiRights", context);
            BaseObject rights = doc.getObject("XWiki.XWikiRights", index);
            rights.setStringValue("groups", "XWiki.XWikiAdminGroup");
            rights.setStringValue("levels", "edit,delete");
            rights.setIntValue("allow", 1);
            xwiki.saveDocument(doc, context);
            ((SchedulerPlugin)context.getWiki().getPlugin("scheduler", context)).scheduleJob(job, context);
        }
    }

    protected void initWatchlistJobs(XWikiContext context) throws XWikiException {
        this.initWatchListJob(1, "WatchList hourly notifications", "WatchList hourly email watchlist job", "0 0 * * * ?", context);
        this.initWatchListJob(2, "WatchList daily notifications", "WatchList daily email watchlist job", "0 0 0 * * ?", context);
        this.initWatchListJob(3, "WatchList weekly notifications", "WatchList weekly email watchlist job", "0 0 0 ? * SUN", context);
        this.initWatchListJob(4, "WatchList monthly notifications", "WatchList monthly email watchlist job", "0 0 0 ? * L", context);
    }

    protected void initEmailTemplate(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        try {
            doc = xwiki.getDocument(WATCHLIST_EMAIL_TEMPLATE, context);
            BaseObject obj = doc.getObject("XWiki.Mail");
            if (obj == null) {
                needsUpdate = true;
            }
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            String[] spaceAndName = WATCHLIST_EMAIL_TEMPLATE.split(".");
            doc.setSpace(spaceAndName[0]);
            doc.setName(spaceAndName[1]);
            needsUpdate = true;
        }
        if (needsUpdate) {
            int index = doc.createNewObject("XWiki.Mail", context);
            BaseObject mail = doc.getObject("XWiki.Mail", index);
            mail.setStringValue("language", "en");
            mail.setStringValue("subject", "XWiki : Watchlist Updates, #set($format=\"dd/MM/yyyy\")#if ($interval == 1)#set($format=\"${format} hh:mm\")#end$xwiki.formatDate($xwiki.date, $format)");
            mail.setLargeStringValue("text", "Hello $pseudo,\nThis message is sent by XWiki. Here are the documents in your watchlist that have been created or updated since the last notification :\n\n#foreach ($udocname in $documents)\n#set ($udoc = $xwiki.getDocument($udocname))$udoc.getDisplayTitle() : ${udoc.getExternalURL()}\n#end");
            mail.setLargeStringValue("html", "<b>Hello $pseudo,</b><br/>\n<i>This message is sent by XWiki. Here are the documents in your watchlist that have been created or updated since the last notification :</i><br/>\n<br/>\n<table width=\"100%\">\n<tr style=\"background-color:#EFEFEF;font-weight:bold;\">\n<td>Name</td><td>Space</td><td>Modified by</td><td>Comment</td><td>Modified on</td>\n</tr>\n#foreach ($udocname in $documents)\n#set ($udoc = $xwiki.getDocument($udocname))\n#if ($velocityCount % 2 == 0)\n  #set ($color = \"#E5F0FE\")\n#else\n  #set ($color = \"#FFF\")\n#end\n<tr style=\"background-color:${color};\">\n<td><a href=\"${udoc.getExternalURL()}\">$udoc.getDisplayTitle()</a></td>\n<td>$udoc.web</td>\n<td>$xwiki.getLocalUserName($udoc.author, true)</td>\n<td>$udoc.getComment()</td>\n<td>$xwiki.formatDate($udoc.date)</td>\n</tr>\n#end\n</table>");
            String content = doc.getContent();
            if (content == null || content.equals("")) {
                doc.setContent("1 Notification message");
            }
            xwiki.saveDocument(doc, context);
        }
    }

    public boolean isWatched(String localUser, String watchedElement, XWikiContext context) throws XWikiException {
        return this.getWatchedDocuments(localUser, context).contains(watchedElement) | this.getWatchedSpaces(localUser, context).contains(watchedElement);
    }

    public void createWatchListObject(String localUser, XWikiContext context) throws XWikiException {
        XWiki wiki = context.getWiki();
        XWikiDocument userDocument = wiki.getDocument(localUser, context);
        int nb = userDocument.createNewObject(WATCHLIST_CLASS, context);
        BaseObject wObj = userDocument.getObject(WATCHLIST_CLASS, nb);
        wObj.set("interval", (Object)"1", context);
        wiki.saveDocument(userDocument, context.getMessageTool().get("watchlist.create.object"), true, context);
    }

    private BaseObject getWatchListObject(String localUser, XWikiContext context) throws XWikiException {
        XWikiDocument userDocument = context.getWiki().getDocument(localUser, context);
        if (userDocument.getObjectNumbers(WATCHLIST_CLASS) == 0) {
            this.createWatchListObject(localUser, context);
            return this.getWatchListObject(localUser, context);
        }
        return userDocument.getObject(WATCHLIST_CLASS);
    }

    private void setWatchListLargeStringProperty(String localUser, String prop, String value, XWikiContext context) throws XWikiException {
        XWikiDocument userDocument = context.getWiki().getDocument(localUser, context);
        userDocument.setLargeStringValue(WATCHLIST_CLASS, prop, value);
        userDocument.isMinorEdit();
        context.getWiki().saveDocument(userDocument, context.getMessageTool().get("watchlist.save.object"), true, context);
    }

    public List getWatchedDocuments(String localUser, XWikiContext context) throws XWikiException {
        BaseObject watchListObject = this.getWatchListObject(localUser, context);
        String watchedItems = watchListObject.getLargeStringValue("documents").trim();
        return Arrays.asList(watchedItems.split(","));
    }

    public List getWatchedSpaces(String localUser, XWikiContext context) throws XWikiException {
        BaseObject watchListObject = this.getWatchListObject(localUser, context);
        String watchedItems = watchListObject.getLargeStringValue("spaces").trim();
        return Arrays.asList(watchedItems.split(","));
    }

    public boolean addWatchedElement(String localUser, String newWatchedElement, boolean isSpace, XWikiContext context) throws XWikiException {
        if (this.isWatched(localUser, newWatchedElement, context)) {
            return false;
        }
        String prop = isSpace ? "spaces" : "documents";
        List watchedItems = isSpace ? this.getWatchedSpaces(localUser, context) : this.getWatchedDocuments(localUser, context);
        StringBuffer updatedWatchedElements = new StringBuffer();
        for (int i = 0; i < watchedItems.size(); ++i) {
            if (i > 0) {
                updatedWatchedElements.append(",");
            }
            updatedWatchedElements.append(watchedItems.get(i));
        }
        if (watchedItems.size() > 0) {
            updatedWatchedElements.append(",");
        }
        updatedWatchedElements.append(newWatchedElement);
        this.setWatchListLargeStringProperty(localUser, prop, updatedWatchedElements.toString(), context);
        return true;
    }

    public boolean removeWatchedElement(String localUser, String watchedElement, boolean isSpace, XWikiContext context) throws XWikiException {
        if (!this.isWatched(localUser, watchedElement, context)) {
            return false;
        }
        String prop = isSpace ? "spaces" : "documents";
        List watchedItems = isSpace ? this.getWatchedSpaces(localUser, context) : this.getWatchedDocuments(localUser, context);
        StringBuffer updatedWatchedElements = new StringBuffer();
        for (int i = 0; i < watchedItems.size(); ++i) {
            if (watchedItems.get(i).equals(watchedElement)) continue;
            if (i > 0) {
                updatedWatchedElements.append(",");
            }
            updatedWatchedElements.append(watchedItems.get(i));
        }
        this.setWatchListLargeStringProperty(localUser, prop, updatedWatchedElements.toString(), context);
        return true;
    }

    public List getWatchListWhatsNew(String localUser, XWikiContext context) throws XWikiException {
        BaseObject watchListObject = this.getWatchListObject(localUser, context);
        String watchedDocuments = watchListObject.getLargeStringValue("documents").trim().replaceFirst("^,", "").replaceAll(",", "','");
        String watchedSpaces = watchListObject.getLargeStringValue("spaces").trim().replaceFirst("^,", "").replaceAll(",", "','");
        String request = "select doc.fullName from XWikiDocument as doc where doc.web in ('" + watchedSpaces + "') or doc.fullName in ('" + watchedDocuments + "') " + "order by doc.date desc";
        return context.getWiki().getStore().search(request, 20, 0, context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

