/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.AttachmentDiff;
import com.xpn.xwiki.doc.MetaDataDiff;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.ObjectDiff;
import com.xpn.xwiki.plugin.activitystream.plugin.ActivityEvent;
import com.xpn.xwiki.plugin.diff.DiffPluginApi;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.Element;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.Span;
import org.suigeneris.jrcs.rcs.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchListEvent
implements Comparable<WatchListEvent> {
    private static final String HTML_STYLE_PLACEHOLDER_PREFIX = "WATCHLIST_STYLE_DIFF_";
    private static final String HTML_IMG_PLACEHOLDER_SUFFIX = "_WATCHLIST_IMG_PLACEHOLDER";
    private final int hashCode;
    private final String prefixedSpace;
    private final String prefixedFullName;
    private String type;
    private List<ActivityEvent> activityEvents = new ArrayList<ActivityEvent>();
    private String previousVersion;
    private List<String> versions;
    private List<String> authors;
    private List<Date> dates;
    private String htmlDiff;

    public WatchListEvent(ActivityEvent activityEvent) {
        this.activityEvents.add(activityEvent);
        this.type = activityEvent.getType();
        this.prefixedSpace = activityEvent.getWiki() + ":" + activityEvent.getSpace();
        this.prefixedFullName = activityEvent.getWiki() + ":" + activityEvent.getPage();
        int hash = 3;
        this.hashCode = "update".equals(activityEvent) ? 42 * hash + this.prefixedFullName.hashCode() + activityEvent.getType().hashCode() : 42 * hash + this.prefixedFullName.hashCode() + activityEvent.getType().hashCode() + activityEvent.getDate().hashCode();
    }

    public void addEvent(WatchListEvent event) {
        if ("delete".equals(event.getType())) {
            this.activityEvents.clear();
            this.type = event.getType();
            this.versions.clear();
            this.versions = null;
            this.authors.clear();
            this.authors = null;
            this.previousVersion = null;
            this.htmlDiff = null;
        } else if ("update".equals(event.getType()) && "delete".equals(this.getType())) {
            return;
        }
        this.activityEvents.add(event.getActivityEvent());
    }

    public String getWiki() {
        return this.getActivityEvent().getWiki();
    }

    public String getSpace() {
        return this.getActivityEvent().getSpace();
    }

    public String getPrefixedSpace() {
        return this.prefixedSpace;
    }

    public String getFullName() {
        return this.getActivityEvent().getPage();
    }

    public String getPrefixedFullName() {
        return this.prefixedFullName;
    }

    public String getUrl(XWikiContext context) {
        String url;
        try {
            url = new URL(context.getURL(), this.getActivityEvent().getUrl()).toString();
        }
        catch (MalformedURLException e) {
            url = this.getActivityEvent().getUrl();
        }
        return url;
    }

    public Date getDate() {
        return this.getActivityEvent().getDate();
    }

    public List<Date> getDates() {
        if (this.dates == null) {
            this.dates = new ArrayList<Date>();
            if (!this.isComposite()) {
                this.dates.add(this.getDate());
            } else {
                for (ActivityEvent event : this.activityEvents) {
                    this.dates.add(event.getDate());
                }
            }
        }
        return this.dates;
    }

    public String getType() {
        return this.type;
    }

    private ActivityEvent getActivityEvent() {
        return this.activityEvents.get(0);
    }

    public String getAuthor() {
        return this.getActivityEvent().getUser();
    }

    public List<String> getAuthors() {
        if (this.authors == null) {
            this.authors = new ArrayList<String>();
            if (!this.isComposite()) {
                this.authors.add(this.getAuthor());
            } else {
                for (ActivityEvent event : this.activityEvents) {
                    String prefixedAuthor = event.getWiki() + ":" + event.getUser();
                    if (this.authors.contains(prefixedAuthor)) continue;
                    this.authors.add(prefixedAuthor);
                }
            }
        }
        return this.authors;
    }

    public String getVersion() {
        return this.getActivityEvent().getVersion();
    }

    public List<String> getVersions() {
        if (this.versions == null) {
            this.versions = new ArrayList<String>();
            if (!this.isComposite()) {
                if (!StringUtils.isBlank((String)this.getActivityEvent().getVersion())) {
                    this.versions.add(this.getActivityEvent().getVersion());
                }
            } else {
                for (ActivityEvent event : this.activityEvents) {
                    if (StringUtils.isBlank((String)event.getVersion()) || this.versions.contains(event.getVersion())) continue;
                    this.versions.add(event.getVersion());
                }
            }
        }
        return this.versions;
    }

    public String getPreviousVersion(XWikiContext context) {
        if (this.previousVersion == null) {
            String currentVersion = "";
            this.previousVersion = "1.1";
            try {
                if (!this.isComposite()) {
                    currentVersion = this.getActivityEvent().getVersion();
                } else {
                    List<String> allVersions = this.getVersions();
                    if (allVersions.size() > 1) {
                        currentVersion = allVersions.get(allVersions.size() - 1);
                    }
                }
                if (!StringUtils.isBlank((String)currentVersion)) {
                    XWikiDocument doc = context.getWiki().getDocument(this.prefixedFullName, context);
                    XWikiDocument docRev = context.getWiki().getDocument(doc, currentVersion, context);
                    doc.loadArchive(context);
                    Version version = doc.getDocumentArchive().getPrevVersion(docRev.getRCSVersion());
                    if (version != null) {
                        this.previousVersion = version.toString();
                    }
                }
            }
            catch (XWikiException e) {
                e.printStackTrace();
            }
        }
        return this.previousVersion;
    }

    public boolean isComposite() {
        return this.activityEvents.size() > 1;
    }

    private Div createDiffDiv(String classAttr) {
        Div div = new Div();
        div.setClass(classAttr);
        div.setStyle(HTML_STYLE_PLACEHOLDER_PREFIX + classAttr);
        return div;
    }

    private Span createDiffSpan(String classAttr) {
        Span span = new Span();
        span.setClass(classAttr);
        span.setStyle(HTML_STYLE_PLACEHOLDER_PREFIX + classAttr);
        return span;
    }

    private String getHTMLObjectsDiff(List<List<ObjectDiff>> objectDiffs, String prefix, DiffPluginApi diff) {
        StringBuffer result = new StringBuffer();
        String propSeparator = ": ";
        try {
            for (List<ObjectDiff> oList : objectDiffs) {
                if (oList.size() <= 0) continue;
                Div mainDiv = this.createDiffDiv(prefix + "Diff");
                Span objectName = this.createDiffSpan(prefix + "ClassName");
                objectName.addElement(oList.get(0).getClassName());
                mainDiv.addElement(prefix + HTML_IMG_PLACEHOLDER_SUFFIX);
                mainDiv.addElement((Element)objectName);
                for (ObjectDiff oDiff : oList) {
                    if (StringUtils.isBlank((String)oDiff.getPropName())) continue;
                    Div propDiv = this.createDiffDiv("propDiffContainer");
                    Span propNameSpan = this.createDiffSpan("propName");
                    propNameSpan.addElement(oDiff.getPropName() + propSeparator);
                    propDiv.addElement(StringUtils.removeEnd((String)oDiff.getPropType(), (String)"Class").toLowerCase() + HTML_IMG_PLACEHOLDER_SUFFIX);
                    propDiv.addElement((Element)propNameSpan);
                    String propDiff = diff.getDifferencesAsHTML(oDiff.getPrevValue().toString(), oDiff.getNewValue().toString(), false);
                    Div propDiffDiv = this.createDiffDiv("propDiff");
                    propDiffDiv.addElement(propDiff);
                    propDiv.addElement((Element)propDiffDiv);
                    mainDiv.addElement((Element)propDiv);
                }
                result.append(mainDiv);
            }
        }
        catch (XWikiException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public String getHTMLDiff(XWikiContext context) {
        if (this.htmlDiff == null) {
            try {
                XWikiDocument d2 = context.getWiki().getDocument(this.getPrefixedFullName(), context);
                XWikiDocument d1 = context.getWiki().getDocument(d2, this.getPreviousVersion(context), context);
                DiffPluginApi diff = (DiffPluginApi)context.getWiki().getPluginApi("diff", context);
                StringBuffer result = new StringBuffer();
                List attachDiffs = d2.getAttachmentDiff(d1, d2, context);
                List objectDiffs = d2.getObjectDiff(d1, d2, context);
                List classDiffs = d2.getClassDiff(d1, d2, context);
                List metaDiffs = d2.getMetaDataDiff(d1, d2, context);
                if (!d1.getContent().equals(d2.getContent())) {
                    Div contentDiv = this.createDiffDiv("contentDiff");
                    String contentDiff = diff.getDifferencesAsHTML(d1.getContent(), d2.getContent(), false);
                    contentDiv.addElement(contentDiff);
                    result.append(contentDiv);
                }
                for (AttachmentDiff aDiff : attachDiffs) {
                    Div attachmentDiv = this.createDiffDiv("attachmentDiff");
                    attachmentDiv.addElement("attach_WATCHLIST_IMG_PLACEHOLDER");
                    attachmentDiv.addElement(aDiff.toString());
                    result.append(attachmentDiv);
                }
                result.append(this.getHTMLObjectsDiff(objectDiffs, "object", diff));
                result.append(this.getHTMLObjectsDiff(classDiffs, "class", diff));
                for (MetaDataDiff mDiff : metaDiffs) {
                    Div metaDiv = this.createDiffDiv("metaDiff");
                    metaDiv.addElement("metadata_WATCHLIST_IMG_PLACEHOLDER");
                    metaDiv.addElement(mDiff.toString());
                    result.append(metaDiv);
                }
                this.htmlDiff = result.toString();
            }
            catch (XWikiException e) {
                e.printStackTrace();
            }
        }
        return this.htmlDiff;
    }

    @Override
    public int compareTo(WatchListEvent event) {
        return this.getPrefixedFullName().compareTo(event.getPrefixedFullName());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WatchListEvent)) {
            return false;
        }
        WatchListEvent event = (WatchListEvent)obj;
        return this.prefixedFullName.equals(event.getPrefixedFullName()) && "update".equals(this.getType()) && ("update".equals(event.getType()) || "delete".equals(event.getType()));
    }
}

