/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.sun.syndication.feed.synd.SyndFeed;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.activitystream.plugin.ActivityStreamPluginApi;
import com.xpn.xwiki.plugin.watchlist.WatchListPlugin;
import com.xpn.xwiki.plugin.watchlist.WatchListStore;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WatchListEventFeedManager {
    private final WatchListPlugin plugin;

    public WatchListEventFeedManager(WatchListPlugin plugin) {
        this.plugin = plugin;
    }

    public SyndFeed getFeed(String user, int entryNumber, XWikiContext context) throws XWikiException {
        List<String> wikis = this.plugin.getStore().getWatchedElements(user, WatchListStore.ElementType.WIKI, context);
        List<String> spaces = this.plugin.getStore().getWatchedElements(user, WatchListStore.ElementType.SPACE, context);
        List<String> pages = this.plugin.getStore().getWatchedElements(user, WatchListStore.ElementType.DOCUMENT, context);
        ActivityStreamPluginApi asApi = (ActivityStreamPluginApi)context.getWiki().getPluginApi("activitystream", context);
        String listItemsJoint = "','";
        List events = asApi.searchEvents("act.wiki in ('" + StringUtils.join(wikis, (String)listItemsJoint) + "') or act.space in ('" + StringUtils.join(spaces, (String)listItemsJoint) + "') or act.page in ('" + StringUtils.join(pages, (String)listItemsJoint) + "')", false, true, entryNumber, 0);
        String msgPrefix = "watchlist.rss.";
        SyndFeed feed = asApi.getFeed(events);
        feed.setAuthor(context.getMessageTool().get(msgPrefix + "author"));
        feed.setTitle(context.getMessageTool().get(msgPrefix + "title"));
        feed.setDescription(context.getMessageTool().get(msgPrefix + "description"));
        feed.setCopyright(context.getWiki().getXWikiPreference("copyright", context));
        feed.setLink(context.getWiki().getExternalURL("xwiki:Main.WebHome", "view", context));
        return feed;
    }
}

