/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.activitystream.api.ActivityStreamException;
import com.xpn.xwiki.plugin.activitystream.plugin.ActivityEvent;
import com.xpn.xwiki.plugin.activitystream.plugin.ActivityStreamPluginApi;
import com.xpn.xwiki.plugin.watchlist.WatchListEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchListEventMatcher {
    private static final Log LOG = LogFactory.getLog(WatchListEventMatcher.class);
    private static final List<String> MATCHING_EVENT_TYPES = new ArrayList<String>(){
        {
            this.add("create");
            this.add("update");
            this.add("delete");
        }
    };
    private final ActivityStreamPluginApi asApi;
    private final List<WatchListEvent> events = new ArrayList<WatchListEvent>();

    public WatchListEventMatcher(Date start, XWikiContext context) {
        this.asApi = (ActivityStreamPluginApi)context.getWiki().getPluginApi("activitystream", context);
        ArrayList<Date> parameters = new ArrayList<Date>();
        parameters.add(start);
        try {
            List rawEvents = this.asApi.searchEvents("act.date > ? and act.type in ('" + StringUtils.join(MATCHING_EVENT_TYPES, (String)"','") + "')", false, true, 0, 0, parameters);
            for (ActivityEvent rawEvent : rawEvents) {
                WatchListEvent event = new WatchListEvent(rawEvent);
                if (!this.events.contains(event)) {
                    this.events.add(new WatchListEvent(rawEvent));
                    continue;
                }
                WatchListEvent existingCompositeEvent = this.events.get(this.events.indexOf(event));
                existingCompositeEvent.addEvent(event);
            }
        }
        catch (ActivityStreamException e) {
            LOG.error((Object)"Failed to retrieve updated documents from activity stream");
            e.printStackTrace();
        }
    }

    public int getEventNumber() {
        return this.events.size();
    }

    public List<WatchListEvent> getMatchingEvents(List<String> wikis, List<String> spaces, List<String> documents, List<String> users, String userName, XWikiContext context) {
        ArrayList<WatchListEvent> matchingEvents = new ArrayList<WatchListEvent>();
        for (WatchListEvent event : this.events) {
            if (!wikis.contains(event.getWiki()) && !spaces.contains(event.getPrefixedSpace()) && !documents.contains(event.getPrefixedFullName()) && ListUtils.intersection(users, event.getAuthors()).size() <= 0) continue;
            try {
                if (!context.getWiki().getRightService().hasAccessLevel("view", userName, event.getPrefixedFullName(), context)) continue;
                matchingEvents.add(event);
            }
            catch (XWikiException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(matchingEvents);
        return matchingEvents;
    }
}

