/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.scheduler.AbstractJob;
import com.xpn.xwiki.plugin.watchlist.WatchListEvent;
import com.xpn.xwiki.plugin.watchlist.WatchListEventMatcher;
import com.xpn.xwiki.plugin.watchlist.WatchListPlugin;
import com.xpn.xwiki.plugin.watchlist.WatchListStore;
import com.xpn.xwiki.web.Utils;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletContainerException;
import org.xwiki.container.servlet.ServletContainerInitializer;
import org.xwiki.context.Execution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchListJob
extends AbstractJob
implements Job {
    public static final String DEFAULT_EMAIL_TEMPLATE = "XWiki.WatchListMessage";
    private static final Log LOG = LogFactory.getLog(WatchListPlugin.class);
    private BaseObject schedulerJobObject;
    private BaseObject watchListJobObject;
    private XWikiContext context;
    private WatchListPlugin plugin;

    public void init(JobExecutionContext jobContext) throws Exception {
        JobDataMap data = jobContext.getJobDetail().getJobDataMap();
        this.context = (XWikiContext)((XWikiContext)data.get((Object)"context")).clone();
        this.context.getWiki().getStore().cleanUp(this.context);
        this.plugin = (WatchListPlugin)this.context.getWiki().getPlugin("watchlist", this.context);
        this.schedulerJobObject = (BaseObject)data.get((Object)"xjob");
        this.watchListJobObject = this.context.getWiki().getDocument(this.schedulerJobObject.getName(), this.context).getObject("XWiki.WatchListJobClass");
        this.initializeComponents(this.context);
    }

    protected void initializeComponents(XWikiContext context) throws ServletException {
        ServletContainerInitializer containerInitializer = (ServletContainerInitializer)Utils.getComponent(ServletContainerInitializer.class);
        try {
            containerInitializer.initializeRequest(context.getRequest().getHttpServletRequest(), (Object)context);
            containerInitializer.initializeResponse(context.getResponse().getHttpServletResponse());
            containerInitializer.initializeSession(context.getRequest().getHttpServletRequest());
        }
        catch (ServletContainerException e) {
            throw new ServletException("Failed to initialize Request/Response or Session", (Throwable)e);
        }
    }

    protected void cleanupComponents() {
        Container container = (Container)Utils.getComponent(Container.class);
        Execution execution = (Execution)Utils.getComponent(Execution.class);
        container.removeRequest();
        container.removeResponse();
        container.removeSession();
        execution.removeContext();
    }

    public String getId() {
        String className = ((Object)((Object)this)).getClass().getName();
        return className.substring(className.lastIndexOf(".") + 1);
    }

    private Date getPreviousFireTime() {
        return this.watchListJobObject.getDateValue("last_fire_time");
    }

    private void setPreviousFireTime() throws XWikiException {
        XWikiDocument doc = this.context.getWiki().getDocument(this.watchListJobObject.getName(), this.context);
        this.watchListJobObject.setDateValue("last_fire_time", new Date());
        this.context.getWiki().saveDocument(doc, "Updated last fire time", true, this.context);
    }

    private String getEmailTemplate(String userWiki) {
        String fullName = this.watchListJobObject.getStringValue("template");
        if (fullName.contains(":")) {
            String prefixedFullName = fullName;
        } else {
            String prefixedFullName = userWiki + ":" + fullName;
            if (this.context.getWiki().exists(prefixedFullName, this.context)) {
                return prefixedFullName;
            }
        }
        return fullName;
    }

    private List<String> getSubscribers() {
        return this.plugin.getStore().getSubscribersForJob(this.schedulerJobObject.getName());
    }

    private boolean hasSubscribers() {
        List<String> subscribers = this.getSubscribers();
        return !subscribers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeJob(JobExecutionContext jobContext) throws JobExecutionException {
        try {
            this.init(jobContext);
            if (this.watchListJobObject == null) {
                return;
            }
            List<String> subscribers = this.getSubscribers();
            Date previousFireTime = this.getPreviousFireTime();
            WatchListEventMatcher eventMatcher = new WatchListEventMatcher(previousFireTime, this.context);
            this.setPreviousFireTime();
            if (!this.hasSubscribers()) {
                return;
            }
            if (eventMatcher.getEventNumber() == 0) {
                return;
            }
            for (String subscriber : subscribers) {
                List<String> wikis = this.plugin.getStore().getWatchedElements(subscriber, WatchListStore.ElementType.WIKI, this.context);
                List<String> spaces = this.plugin.getStore().getWatchedElements(subscriber, WatchListStore.ElementType.SPACE, this.context);
                List<String> documents = this.plugin.getStore().getWatchedElements(subscriber, WatchListStore.ElementType.DOCUMENT, this.context);
                List<String> users = this.plugin.getStore().getWatchedElements(subscriber, WatchListStore.ElementType.USER, this.context);
                List<WatchListEvent> matchingEvents = eventMatcher.getMatchingEvents(wikis, spaces, documents, users, subscriber, this.context);
                String userWiki = StringUtils.substringBefore((String)subscriber, (String)":");
                if (matchingEvents.size() <= 0) continue;
                this.plugin.getNotifier().sendEmailNotification(subscriber, matchingEvents, this.getEmailTemplate(userWiki), previousFireTime, this.context);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while running job", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            this.context.getWiki().getStore().cleanUp(this.context);
            this.cleanupComponents();
        }
    }
}

