/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.sun.syndication.feed.synd.SyndFeed;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.activitystream.plugin.ActivityStreamPluginApi;
import com.xpn.xwiki.plugin.watchlist.WatchListPlugin;
import com.xpn.xwiki.plugin.watchlist.WatchListStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.ConstantTransformer;
import org.apache.commons.lang.StringUtils;

public class WatchListEventFeedManager {
    private final WatchListPlugin plugin;

    public WatchListEventFeedManager(WatchListPlugin plugin) {
        this.plugin = plugin;
    }

    public SyndFeed getFeed(String user, int entryNumber, XWikiContext context) throws XWikiException {
        List<String> wikis = this.plugin.getStore().getWatchedElements(user, WatchListStore.ElementType.WIKI, context);
        List<String> spaces = this.plugin.getStore().getWatchedElements(user, WatchListStore.ElementType.SPACE, context);
        List<String> documents = this.plugin.getStore().getWatchedElements(user, WatchListStore.ElementType.DOCUMENT, context);
        ArrayList<String> parameters = new ArrayList<String>();
        ActivityStreamPluginApi asApi = (ActivityStreamPluginApi)context.getWiki().getPluginApi("activitystream", context);
        parameters.addAll(wikis);
        parameters.addAll(spaces);
        parameters.addAll(documents);
        ConstantTransformer transformer = new ConstantTransformer((Object)"?");
        List wikisPlaceholders = ListUtils.transformedList(new ArrayList(), (Transformer)transformer);
        wikisPlaceholders.addAll(wikis);
        List spacesPlaceholders = ListUtils.transformedList(new ArrayList(), (Transformer)transformer);
        spacesPlaceholders.addAll(spaces);
        List documentsPlaceholders = ListUtils.transformedList(new ArrayList(), (Transformer)transformer);
        documentsPlaceholders.addAll(documents);
        String listItemsJoint = ",";
        String concatWiki = ") or concat(act.wiki,'";
        List events = asApi.searchEvents("act.wiki in (" + StringUtils.join((Collection)wikisPlaceholders, (String)listItemsJoint) + concatWiki + ":" + "',act.space) in (" + StringUtils.join((Collection)spacesPlaceholders, (String)listItemsJoint) + concatWiki + ":" + "',act.page) in (" + StringUtils.join((Collection)documentsPlaceholders, (String)listItemsJoint) + ")", false, true, entryNumber, 0, parameters);
        String msgPrefix = "watchlist.rss.";
        SyndFeed feed = asApi.getFeed(events);
        feed.setAuthor(context.getMessageTool().get(msgPrefix + "author"));
        feed.setTitle(context.getMessageTool().get(msgPrefix + "title"));
        feed.setDescription(context.getMessageTool().get(msgPrefix + "description"));
        feed.setCopyright(context.getWiki().getXWikiPreference("copyright", context));
        feed.setLink(context.getWiki().getExternalURL("xwiki:Main.WebHome", "view", context));
        return feed;
    }
}

