/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.sun.syndication.feed.synd.SyndFeed;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.watchlist.WatchListPlugin;
import com.xpn.xwiki.plugin.watchlist.WatchListStore;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchListPluginApi
extends PluginApi<WatchListPlugin> {
    public WatchListPluginApi(WatchListPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
    }

    public boolean isDocInWatchedSpaces() throws XWikiException {
        return this.getWatchListPlugin().getStore().getWatchedElements(this.context.getUser(), WatchListStore.ElementType.SPACE, this.context).contains(this.context.getDatabase() + ":" + this.context.getDoc().getSpace());
    }

    public boolean isDocumentWatched() throws XWikiException {
        return this.getWatchListPlugin().getStore().getWatchedElements(this.context.getUser(), WatchListStore.ElementType.DOCUMENT, this.context).contains(this.context.getDatabase() + ":" + this.context.getDoc().getFullName());
    }

    public boolean addDocument(String wDoc) throws XWikiException {
        return this.getWatchListPlugin().getStore().addWatchedElement(this.context.getUser(), wDoc, WatchListStore.ElementType.DOCUMENT, this.context);
    }

    public boolean addDocumentForUser(String user, String wDoc) throws XWikiException {
        return this.context.getWiki().getUser(this.context).hasAdminRights() && this.getWatchListPlugin().getStore().addWatchedElement(user, wDoc, WatchListStore.ElementType.DOCUMENT, this.context);
    }

    public boolean removeDocument(String wDoc) throws XWikiException {
        return this.getWatchListPlugin().getStore().removeWatchedElement(this.context.getUser(), wDoc, WatchListStore.ElementType.DOCUMENT, this.context);
    }

    public boolean removeDocumentForUser(String user, String wDoc) throws XWikiException {
        return this.context.getWiki().getUser(this.context).hasAdminRights() && this.getWatchListPlugin().getStore().removeWatchedElement(user, wDoc, WatchListStore.ElementType.DOCUMENT, this.context);
    }

    public boolean isSpaceWatched() throws XWikiException {
        return this.getWatchListPlugin().getStore().getWatchedElements(this.context.getUser(), WatchListStore.ElementType.SPACE, this.context).contains(this.context.getDatabase() + ":" + this.context.getDoc().getSpace());
    }

    public boolean addSpace(String wSpace) throws XWikiException {
        return this.getWatchListPlugin().getStore().addWatchedElement(this.context.getUser(), wSpace, WatchListStore.ElementType.SPACE, this.context);
    }

    public boolean addSpaceForUser(String user, String wSpace) throws XWikiException {
        return this.context.getWiki().getUser(this.context).hasAdminRights() && this.getWatchListPlugin().getStore().addWatchedElement(user, wSpace, WatchListStore.ElementType.SPACE, this.context);
    }

    public boolean removeSpace(String wSpace) throws XWikiException {
        return this.getWatchListPlugin().getStore().removeWatchedElement(this.context.getUser(), wSpace, WatchListStore.ElementType.SPACE, this.context);
    }

    public boolean removeSpaceForUser(String user, String wSpace) throws XWikiException {
        return this.context.getWiki().getUser(this.context).hasAdminRights() && this.getWatchListPlugin().getStore().removeWatchedElement(user, wSpace, WatchListStore.ElementType.SPACE, this.context);
    }

    public boolean isWikiWatched() throws XWikiException {
        return this.getWatchListPlugin().getStore().getWatchedElements(this.context.getUser(), WatchListStore.ElementType.WIKI, this.context).contains(this.context.getDatabase());
    }

    public boolean addWiki(String wWiki) throws XWikiException {
        return this.getWatchListPlugin().getStore().addWatchedElement(this.context.getUser(), wWiki, WatchListStore.ElementType.WIKI, this.context);
    }

    public boolean addWikiForUser(String user, String wWiki) throws XWikiException {
        return this.context.getWiki().getUser(this.context).hasAdminRights() && this.getWatchListPlugin().getStore().addWatchedElement(user, wWiki, WatchListStore.ElementType.WIKI, this.context);
    }

    public boolean removeWiki(String wWiki) throws XWikiException {
        return this.getWatchListPlugin().getStore().removeWatchedElement(this.context.getUser(), wWiki, WatchListStore.ElementType.WIKI, this.context);
    }

    public boolean removeWikiForUser(String user, String wWiki) throws XWikiException {
        return this.context.getWiki().getUser(this.context).hasAdminRights() && this.getWatchListPlugin().getStore().removeWatchedElement(user, wWiki, WatchListStore.ElementType.WIKI, this.context);
    }

    public boolean isUserWatched(String user) throws XWikiException {
        return this.getWatchListPlugin().getStore().getWatchedElements(this.context.getUser(), WatchListStore.ElementType.USER, this.context).contains(user);
    }

    public boolean addUser(String user) throws XWikiException {
        return this.getWatchListPlugin().getStore().addWatchedElement(this.context.getUser(), user, WatchListStore.ElementType.USER, this.context);
    }

    public boolean addUserForUser(String user, String userToWatch) throws XWikiException {
        return this.context.getWiki().getUser(this.context).hasAdminRights() && this.getWatchListPlugin().getStore().addWatchedElement(user, userToWatch, WatchListStore.ElementType.USER, this.context);
    }

    public boolean removeUser(String user) throws XWikiException {
        return this.getWatchListPlugin().getStore().removeWatchedElement(this.context.getUser(), user, WatchListStore.ElementType.USER, this.context);
    }

    public boolean removeUserForUser(String user, String userToRemove) throws XWikiException {
        return this.context.getWiki().getUser(this.context).hasAdminRights() && this.getWatchListPlugin().getStore().removeWatchedElement(user, userToRemove, WatchListStore.ElementType.USER, this.context);
    }

    public List<String> getWatchedDocuments() throws XWikiException {
        return this.getWatchListPlugin().getStore().getWatchedElements(this.context.getUser(), WatchListStore.ElementType.DOCUMENT, this.context);
    }

    public List<String> getWatchedSpaces() throws XWikiException {
        return this.getWatchListPlugin().getStore().getWatchedElements(this.context.getUser(), WatchListStore.ElementType.SPACE, this.context);
    }

    public List<String> getWatchedWikis() throws XWikiException {
        return this.getWatchListPlugin().getStore().getWatchedElements(this.context.getUser(), WatchListStore.ElementType.WIKI, this.context);
    }

    public List<String> getWatchedUsers() throws XWikiException {
        return this.getWatchListPlugin().getStore().getWatchedElements(this.context.getUser(), WatchListStore.ElementType.USER, this.context);
    }

    public List<String> getWatchedElements() throws XWikiException {
        ArrayList<String> wEls = new ArrayList<String>();
        wEls.addAll(this.getWatchedDocuments());
        wEls.addAll(this.getWatchedSpaces());
        wEls.addAll(this.getWatchedWikis());
        wEls.addAll(this.getWatchedUsers());
        return wEls;
    }

    public SyndFeed getFeed(int entryNumber) throws XWikiException {
        return this.getFeed(this.context.getUser(), entryNumber);
    }

    public SyndFeed getFeed(String user, int entryNumber) throws XWikiException {
        return this.getWatchListPlugin().getFeedManager().getFeed(user, entryNumber, this.context);
    }

    private WatchListPlugin getWatchListPlugin() {
        return (WatchListPlugin)this.getProtectedPlugin();
    }
}

