/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.scheduler.SchedulerPlugin;
import com.xpn.xwiki.plugin.watchlist.WatchListJob;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WatchListJobManager {
    public static final String WATCHLIST_JOB_CLASS = "XWiki.WatchListJobClass";
    public static final String WATCHLIST_JOB_EMAIL_PROP = "template";
    public static final String WATCHLIST_JOB_LAST_FIRE_TIME_PROP = "last_fire_time";
    public static final String XWIKI_RIGHTS_CLASS_GROUPS_PROPERTY = "groups";
    public static final String XWIKI_RIGHTS_CLASS_LEVELS_PROPERTY = "levels";
    public static final String XWIKI_RIGHTS_CLASS_ALLOW_PROPERTY = "allow";
    private static final Log LOG = LogFactory.getLog(WatchListJobManager.class);
    private static final String XWIKI_RIGHTS_CLASS = "XWiki.XWikiRights";

    private boolean setWatchListCommonDocumentsFields(XWikiDocument doc) {
        boolean needsUpdate = false;
        if (StringUtils.isBlank((String)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator("superadmin");
        }
        if (StringUtils.isBlank((String)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthor(doc.getCreator());
        }
        if (StringUtils.isBlank((String)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("XWiki.WatchListClass");
        }
        return needsUpdate;
    }

    private boolean initWatchListJobClassProperties(XWikiDocument watchListJobClass, XWikiContext context) {
        boolean needsUpdate = false;
        BaseClass bclass = watchListJobClass.getxWikiClass();
        bclass.setName(WATCHLIST_JOB_CLASS);
        needsUpdate |= bclass.addTextField(WATCHLIST_JOB_EMAIL_PROP, "Email template to use", 30);
        return needsUpdate |= bclass.addDateField(WATCHLIST_JOB_LAST_FIRE_TIME_PROP, "Last notifier fire time", "dd/MM/yyyy HH:mm:ss", 1);
    }

    private void initWatchListJobClass(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        boolean needsUpdate = false;
        try {
            doc = context.getWiki().getDocument(WATCHLIST_JOB_CLASS, context);
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            String[] spaceAndName = WATCHLIST_JOB_CLASS.split(".");
            doc.setSpace(spaceAndName[0]);
            doc.setName(spaceAndName[1]);
            needsUpdate = true;
        }
        needsUpdate |= this.initWatchListJobClassProperties(doc, context);
        needsUpdate |= this.setWatchListCommonDocumentsFields(doc);
        if (StringUtils.isBlank((String)doc.getTitle())) {
            needsUpdate = true;
            doc.setTitle("XWiki WatchList Notifier Class");
        }
        if (StringUtils.isBlank((String)doc.getContent()) || !XWikiDocument.XWIKI20_SYNTAXID.equals(doc.getSyntaxId())) {
            needsUpdate = true;
            doc.setContent("{{include document=\"XWiki.ClassSheet\" /}}");
            doc.setSyntaxId(XWikiDocument.XWIKI20_SYNTAXID);
        }
        if (needsUpdate) {
            context.getWiki().saveDocument(doc, "", true, context);
        }
    }

    private boolean createWatchListJobObject(XWikiDocument doc, String emailTemplate, XWikiContext context) throws XWikiException {
        BaseObject obj = null;
        boolean needsupdate = false;
        obj = doc.getObject(WATCHLIST_JOB_CLASS);
        if (obj == null) {
            doc.createNewObject(WATCHLIST_JOB_CLASS, context);
            needsupdate = true;
        }
        if (StringUtils.isBlank((String)(obj = doc.getObject(WATCHLIST_JOB_CLASS)).getStringValue(WATCHLIST_JOB_EMAIL_PROP))) {
            obj.setStringValue(WATCHLIST_JOB_EMAIL_PROP, emailTemplate);
            needsupdate = true;
        }
        if (obj.getDateValue(WATCHLIST_JOB_LAST_FIRE_TIME_PROP) == null) {
            obj.setDateValue(WATCHLIST_JOB_LAST_FIRE_TIME_PROP, new Date());
            needsupdate = true;
        }
        return needsupdate;
    }

    private boolean createWatchListJobRightsObject(XWikiDocument doc, XWikiContext context) throws XWikiException {
        int index;
        boolean needsUpdate = false;
        BaseObject editRights = doc.getObject(XWIKI_RIGHTS_CLASS, 0);
        BaseObject viewRights = doc.getObject(XWIKI_RIGHTS_CLASS, 1);
        if (editRights == null) {
            index = doc.createNewObject(XWIKI_RIGHTS_CLASS, context);
            editRights = doc.getObject(XWIKI_RIGHTS_CLASS, index);
            editRights.setLargeStringValue(XWIKI_RIGHTS_CLASS_GROUPS_PROPERTY, "XWiki.XWikiAdminGroup");
            editRights.setStringValue(XWIKI_RIGHTS_CLASS_LEVELS_PROPERTY, "edit,delete");
            editRights.setIntValue(XWIKI_RIGHTS_CLASS_ALLOW_PROPERTY, 1);
            needsUpdate = true;
        }
        if (viewRights == null) {
            index = doc.createNewObject(XWIKI_RIGHTS_CLASS, context);
            viewRights = doc.getObject(XWIKI_RIGHTS_CLASS, index);
            viewRights.setLargeStringValue(XWIKI_RIGHTS_CLASS_GROUPS_PROPERTY, "XWiki.XWikiAllGroup");
            viewRights.setStringValue(XWIKI_RIGHTS_CLASS_LEVELS_PROPERTY, "view");
            viewRights.setIntValue(XWIKI_RIGHTS_CLASS_ALLOW_PROPERTY, 1);
            needsUpdate = true;
        }
        return needsUpdate;
    }

    private void initWatchListJob(String docName, String name, String nameResource, String emailTemplate, String cron, XWikiContext context) throws XWikiException {
        boolean needsUpdate = false;
        BaseObject job = null;
        try {
            XWikiDocument doc = context.getWiki().getDocument(docName, context);
            job = doc.getObject("XWiki.SchedulerJobClass");
            if (job == null) {
                needsUpdate = true;
                int index = doc.createNewObject("XWiki.SchedulerJobClass", context);
                job = doc.getObject("XWiki.SchedulerJobClass", index);
                job.setStringValue("jobName", name);
                job.setStringValue("jobClass", WatchListJob.class.getName());
                job.setStringValue("cron", cron);
                job.setStringValue("contextUser", "XWiki.superadmin");
                job.setStringValue("contextLang", "en");
                job.setStringValue("contextDatabase", "xwiki");
            }
            needsUpdate |= this.createWatchListJobRightsObject(doc, context);
            needsUpdate |= this.createWatchListJobObject(doc, emailTemplate, context);
            needsUpdate |= this.setWatchListCommonDocumentsFields(doc);
            if (StringUtils.isBlank((String)doc.getTitle())) {
                needsUpdate = true;
                doc.setTitle("$msg.get(\"" + nameResource + "\")");
            }
            if (StringUtils.isBlank((String)doc.getContent())) {
                needsUpdate = true;
                doc.setContent("{{include document=\"XWiki.SchedulerJobSheet\"/}}");
                doc.setSyntaxId(XWikiDocument.XWIKI20_SYNTAXID);
            }
            if (needsUpdate) {
                context.getWiki().saveDocument(doc, "", true, context);
                ((SchedulerPlugin)context.getWiki().getPlugin("scheduler", context)).scheduleJob(job, context);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot initialize WatchListJob", (Throwable)e);
        }
    }

    public void init(XWikiContext context) throws XWikiException {
        this.initWatchListJobClass(context);
        this.initWatchListJob("Scheduler.WatchListHourlyNotifier", "WatchList hourly notifier", "watchlist.job.hourly", "XWiki.WatchListMessage", "0 0 * * * ?", context);
        this.initWatchListJob("Scheduler.WatchListDailyNotifier", "WatchList daily notifier", "watchlist.job.daily", "XWiki.WatchListMessage", "0 0 0 * * ?", context);
        this.initWatchListJob("Scheduler.WatchListWeeklyNotifier", "WatchList weekly notifier", "watchlist.job.weekly", "XWiki.WatchListMessage", "0 0 0 ? * MON", context);
    }
}

