/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.watchlist.WatchListEventFeedManager;
import com.xpn.xwiki.plugin.watchlist.WatchListJobManager;
import com.xpn.xwiki.plugin.watchlist.WatchListNotifier;
import com.xpn.xwiki.plugin.watchlist.WatchListPluginApi;
import com.xpn.xwiki.plugin.watchlist.WatchListStore;
import com.xpn.xwiki.web.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;

public class WatchListPlugin
extends XWikiDefaultPlugin
implements XWikiPluginInterface {
    public static final String ID = "watchlist";
    public static final String APP_RES_PREFIX = "watchlist.";
    public static final String DEFAULT_DOC_AUTHOR = "superadmin";
    public static final String DEFAULT_CLASS_PARENT = "XWiki.XWikiClasses";
    private static final Log LOG = LogFactory.getLog(WatchListPlugin.class);
    private final WatchListJobManager jobManager = new WatchListJobManager();
    private WatchListStore store = new WatchListStore();
    private WatchListNotifier notifier = new WatchListNotifier();
    private WatchListEventFeedManager feedManager = new WatchListEventFeedManager(this);

    public WatchListPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    public String getName() {
        return ID;
    }

    public void init(XWikiContext context) {
        super.init(context);
        try {
            this.jobManager.init(context);
            this.store.init(context);
            ObservationManager observationManager = (ObservationManager)Utils.getComponent(ObservationManager.class);
            if (observationManager.getListener(this.store.getName()) == null) {
                observationManager.addListener((EventListener)this.store);
            }
        }
        catch (XWikiException e) {
            LOG.error((Object)"init", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void virtualInit(XWikiContext context) {
        super.virtualInit(context);
        try {
            this.store.virtualInit(context);
        }
        catch (XWikiException e) {
            LOG.error((Object)"virtualInit", (Throwable)e);
            e.printStackTrace();
        }
    }

    public WatchListPluginApi getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new WatchListPluginApi((WatchListPlugin)plugin, context);
    }

    public WatchListJobManager getJobManager() {
        return this.jobManager;
    }

    public WatchListStore getStore() {
        return this.store;
    }

    public WatchListNotifier getNotifier() {
        return this.notifier;
    }

    public WatchListEventFeedManager getFeedManager() {
        return this.feedManager;
    }
}

