/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.scheduler.SchedulerPlugin;
import com.xpn.xwiki.plugin.watchlist.WatchListPluginApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WatchListPlugin
extends XWikiDefaultPlugin
implements XWikiPluginInterface {
    public static String WATCHLIST_EMAIL_TEMPLATE = "XWiki.WatchListMessage";
    public static String WATCHLIST_EMAIL_JOB_COMMON_NAME = "Scheduler.WatchListJob";
    public static String WATCHLIST_CLASS = "XWiki.WatchListClass";
    public static final int WATCHLIST_INTERVAL_NEVER = 0;
    public static final int WATCHLIST_INTERVAL_HOUR = 1;
    public static final int WATCHLIST_INTERVAL_DAY = 2;
    public static final int WATCHLIST_INTERVAL_WEEK = 3;
    public static final int WATCHLIST_INTERVAL_MONTH = 4;
    public static final String ID = "watchlist";
    private static final Log log = LogFactory.getLog(WatchListPlugin.class);

    public WatchListPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    public String getName() {
        return ID;
    }

    public void virtualInit(XWikiContext context) {
        super.virtualInit(context);
    }

    public void init(XWikiContext context) {
        super.init(context);
        try {
            this.initWatchListClass(context);
            this.initWatchlistJobs(context);
            this.sanitizeWatchlists(context);
        }
        catch (XWikiException e) {
            log.error((Object)"virtualInit", (Throwable)e);
            e.printStackTrace();
        }
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new WatchListPluginApi((WatchListPlugin)plugin, context);
    }

    protected Log getLogger() {
        return log;
    }

    protected BaseClass initWatchListClass(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        boolean needsUpdate = false;
        try {
            doc = context.getWiki().getDocument(WATCHLIST_CLASS, context);
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            String[] spaceAndName = WATCHLIST_CLASS.split(".");
            doc.setSpace(spaceAndName[0]);
            doc.setName(spaceAndName[1]);
            needsUpdate = true;
        }
        BaseClass bclass = doc.getxWikiClass();
        bclass.setName(WATCHLIST_CLASS);
        needsUpdate |= bclass.addStaticListField("interval", "Email notifications interval", "0=never|1=hourly|2=daily|3=weekly|4=monthly");
        needsUpdate |= bclass.addTextAreaField("spaces", "Space list, separated by commas", 40, 5);
        needsUpdate |= bclass.addTextAreaField("documents", "Document list, separated by commas", 40, 5);
        needsUpdate |= bclass.addTextAreaField("query", "Query (HQL)", 40, 5);
        if (StringUtils.isBlank((String)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthor("XWiki.Admin");
        }
        if (StringUtils.isBlank((String)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator("XWiki.Admin");
        }
        if (StringUtils.isBlank((String)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("XWiki.XWikiClasses");
        }
        if (StringUtils.isBlank((String)doc.getContent())) {
            needsUpdate = true;
            doc.setContent("1 XWiki Watchlist Notification Rule Class");
        }
        if (needsUpdate) {
            context.getWiki().saveDocument(doc, "", true, context);
        }
        return bclass;
    }

    protected void initWatchListJob(int interval, String name, String description, String cron, XWikiContext context) throws XWikiException {
        boolean needsUpdate = false;
        String jobClass = "com.xpn.xwiki.plugin.watchlist.WatchListJob";
        BaseObject job = null;
        String docName = WATCHLIST_EMAIL_JOB_COMMON_NAME + interval;
        try {
            BaseObject rights;
            XWikiDocument doc = context.getWiki().getDocument(docName, context);
            job = doc.getObject("XWiki.SchedulerJobClass");
            if (job == null) {
                needsUpdate = true;
                int index = doc.createNewObject("XWiki.SchedulerJobClass", context);
                job = doc.getObject("XWiki.SchedulerJobClass", index);
                job.setStringValue("jobName", name);
                job.setStringValue("jobClass", jobClass);
                job.setStringValue("cron", cron);
                job.setLargeStringValue("script", Integer.toString(interval));
                job.setLargeStringValue("jobDescription", description);
                job.setStringValue("contextUser", "XWiki.Admin");
                job.setStringValue("contextLang", "en");
                job.setStringValue("contextDatabase", "xwiki");
            }
            if ((rights = doc.getObject("XWiki.XWikiRights")) == null) {
                needsUpdate = true;
                int index = doc.createNewObject("XWiki.XWikiRights", context);
                rights = doc.getObject("XWiki.XWikiRights", index);
                rights.setStringValue("groups", "XWiki.XWikiAdminGroup");
                rights.setStringValue("levels", "edit,delete");
                rights.setIntValue("allow", 1);
            }
            if (StringUtils.isBlank((String)doc.getAuthor())) {
                needsUpdate = true;
                doc.setAuthor("XWiki.Admin");
            }
            if (StringUtils.isBlank((String)doc.getCreator())) {
                needsUpdate = true;
                doc.setCreator("XWiki.Admin");
            }
            if (StringUtils.isBlank((String)doc.getParent())) {
                needsUpdate = true;
                doc.setParent("XWiki.XWikiClasses");
            }
            if (StringUtils.isBlank((String)doc.getContent())) {
                needsUpdate = true;
                doc.setContent("#includeInContext(\"XWiki.SchedulerJobSheet\")");
            }
            if (needsUpdate) {
                context.getWiki().saveDocument(doc, "", true, context);
                ((SchedulerPlugin)context.getWiki().getPlugin("scheduler", context)).scheduleJob(job, context);
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot initialize WatchListJob", (Throwable)e);
        }
    }

    protected void initWatchlistJobs(XWikiContext context) throws XWikiException {
        this.initWatchListJob(1, "WatchList hourly notifications", "WatchList hourly email watchlist job", "0 0 * * * ?", context);
        this.initWatchListJob(2, "WatchList daily notifications", "WatchList daily email watchlist job", "0 0 0 * * ?", context);
        this.initWatchListJob(3, "WatchList weekly notifications", "WatchList weekly email watchlist job", "0 0 0 ? * SUN", context);
        this.initWatchListJob(4, "WatchList monthly notifications", "WatchList monthly email watchlist job", "0 0 0 ? * L", context);
    }

    public boolean isWatched(String user, String watchedElement, XWikiContext context) throws XWikiException {
        return this.getWatchedDocuments(user, context).contains(watchedElement) | this.getWatchedSpaces(user, context).contains(watchedElement);
    }

    public void createWatchListObject(String user, XWikiContext context) throws XWikiException {
        XWikiDocument userDocument = context.getWiki().getDocument(user, context);
        int nb = userDocument.createNewObject(WATCHLIST_CLASS, context);
        BaseObject wObj = userDocument.getObject(WATCHLIST_CLASS, nb);
        wObj.set("interval", (Object)"1", context);
        context.getWiki().saveDocument(userDocument, context.getMessageTool().get("watchlist.create.object"), true, context);
    }

    public BaseObject getWatchListObject(String user, XWikiContext context) throws XWikiException {
        XWikiDocument userDocument = context.getWiki().getDocument(user, context);
        if (userDocument.getObjectNumbers(WATCHLIST_CLASS) == 0) {
            this.createWatchListObject(user, context);
            return this.getWatchListObject(user, context);
        }
        return userDocument.getObject(WATCHLIST_CLASS);
    }

    public void setWatchListLargeStringProperty(String user, String prop, String value, XWikiContext context) throws XWikiException {
        XWikiDocument userDocument = context.getWiki().getDocument(user, context);
        userDocument.setLargeStringValue(WATCHLIST_CLASS, prop, value);
        userDocument.isMinorEdit();
        context.getWiki().saveDocument(userDocument, context.getMessageTool().get("watchlist.save.object"), true, context);
    }

    public List getWatchedDocuments(String user, XWikiContext context) throws XWikiException {
        BaseObject watchListObject = this.getWatchListObject(user, context);
        String watchedItems = watchListObject.getLargeStringValue("documents").trim();
        return Arrays.asList(watchedItems.split(","));
    }

    public List getWatchedSpaces(String user, XWikiContext context) throws XWikiException {
        BaseObject watchListObject = this.getWatchListObject(user, context);
        String watchedItems = watchListObject.getLargeStringValue("spaces").trim();
        return Arrays.asList(watchedItems.split(","));
    }

    public boolean addWatchedElement(String user, String newWatchedElement, boolean isSpace, XWikiContext context) throws XWikiException {
        newWatchedElement = context.getDatabase() + ":" + newWatchedElement;
        if (this.isWatched(user, newWatchedElement, context)) {
            return false;
        }
        String prop = isSpace ? "spaces" : "documents";
        List watchedItems = isSpace ? this.getWatchedSpaces(user, context) : this.getWatchedDocuments(user, context);
        StringBuffer updatedWatchedElements = new StringBuffer();
        for (int i = 0; i < watchedItems.size(); ++i) {
            if (i > 0) {
                updatedWatchedElements.append(",");
            }
            updatedWatchedElements.append(watchedItems.get(i));
        }
        if (watchedItems.size() > 0) {
            updatedWatchedElements.append(",");
        }
        updatedWatchedElements.append(newWatchedElement);
        this.setWatchListLargeStringProperty(user, prop, updatedWatchedElements.toString(), context);
        return true;
    }

    public boolean removeWatchedElement(String user, String watchedElement, boolean isSpace, XWikiContext context) throws XWikiException {
        if (!watchedElement.contains(":")) {
            watchedElement = context.getDatabase() + ":" + watchedElement;
        }
        if (!this.isWatched(user, watchedElement, context)) {
            return false;
        }
        String prop = isSpace ? "spaces" : "documents";
        List watchedItems = isSpace ? this.getWatchedSpaces(user, context) : this.getWatchedDocuments(user, context);
        StringBuffer updatedWatchedElements = new StringBuffer();
        for (int i = 0; i < watchedItems.size(); ++i) {
            if (watchedItems.get(i).equals(watchedElement)) continue;
            if (i > 0) {
                updatedWatchedElements.append(",");
            }
            updatedWatchedElements.append(watchedItems.get(i));
        }
        this.setWatchListLargeStringProperty(user, prop, updatedWatchedElements.toString(), context);
        return true;
    }

    public List getWatchListWhatsNew(String user, XWikiContext context) throws XWikiException {
        BaseObject watchListObject = this.getWatchListObject(user, context);
        if (context.getWiki().isVirtual()) {
            return new ArrayList();
        }
        String watchedDocuments = watchListObject.getLargeStringValue("documents").trim().replaceFirst("^,", "").replaceAll("[^\\.,:]+:", "").replaceAll(",", "','");
        String watchedSpaces = watchListObject.getLargeStringValue("spaces").trim().replaceFirst("^,", "").replaceAll("[^\\.,:]+:", "").replaceAll(",", "','");
        String request = "select doc.fullName from XWikiDocument as doc where doc.web in ('" + watchedSpaces + "') or doc.fullName in ('" + watchedDocuments + "') " + "order by doc.date desc";
        return context.getWiki().getStore().search(request, 20, 0, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List globalSearchDocuments(String request, int nb, int start, List values, XWikiContext context) {
        String initialDb = !context.getDatabase().equals("") ? context.getDatabase() : context.getMainXWiki();
        List<String> wikiServers = Collections.EMPTY_LIST;
        ArrayList<String> results = new ArrayList<String>();
        if (context.getWiki().isVirtual()) {
            try {
                wikiServers = context.getWiki().getVirtualWikiList();
                if (!wikiServers.contains(context.getMainXWiki())) {
                    wikiServers.add(context.getMainXWiki());
                }
            }
            catch (Exception e) {
                this.getLogger().error((Object)"error getting list of wiki servers!", (Throwable)e);
            }
        } else {
            wikiServers = new ArrayList();
            wikiServers.add(context.getMainXWiki());
        }
        try {
            for (String wiki : wikiServers) {
                String wikiPrefix = wiki + ":";
                context.setDatabase(wiki);
                try {
                    List upDocsInWiki = context.getWiki().getStore().searchDocumentsNames(request, 0, 0, values, context);
                    Iterator it = upDocsInWiki.iterator();
                    while (it.hasNext()) {
                        results.add(wikiPrefix + it.next());
                    }
                }
                catch (Exception e) {
                    this.getLogger().error((Object)("error getting list of documents in the wiki : " + wiki), (Throwable)e);
                }
            }
        }
        finally {
            context.setDatabase(initialDb);
        }
        return results;
    }

    protected void sanitizeWatchlists(XWikiContext context) {
        String request = ", BaseObject as obj where obj.name=doc.fullName and obj.className='" + WATCHLIST_CLASS + "'";
        List subscribers = this.globalSearchDocuments(request, 0, 0, new ArrayList(), context);
        for (String user : subscribers) {
            try {
                XWikiDocument userDocument = context.getWiki().getDocument(user, context);
                BaseObject wobj = userDocument.getObject(WATCHLIST_CLASS);
                String docs = wobj.getLargeStringValue("documents").trim();
                String spaces = wobj.getLargeStringValue("spaces").trim();
                boolean update = false;
                Pattern p = Pattern.compile("(^|,)([^\\.,:]+)(\\.)([^\\.,]+)");
                Matcher m = p.matcher(docs);
                if (m.find()) {
                    String newdocs = docs.replaceAll("(^|,)([^\\.,:]+)(\\.)([^\\.,]+)", "$1" + context.getMainXWiki() + ":$2$3$4");
                    wobj.setLargeStringValue("documents", newdocs);
                    this.getLogger().info((Object)("Sanitizing watchlist documents for user : " + user));
                    update = true;
                }
                if ((m = (p = Pattern.compile("(^|,)([^:,]+)(?=(,|$))")).matcher(spaces)).find()) {
                    String newspaces = spaces.replaceAll("(^|,)([^:,]+)(?=(,|$))", "$1" + context.getMainXWiki() + ":$2");
                    wobj.setLargeStringValue("spaces", newspaces);
                    this.getLogger().info((Object)("Sanitizing watchlist spaces for user : " + user));
                    update = true;
                }
                if (!update) continue;
                context.getWiki().saveDocument(userDocument, "", true, context);
            }
            catch (Exception e) {
                this.getLogger().error((Object)("Exception while sanitizing watchlist for user : " + user));
                e.printStackTrace();
            }
        }
    }
}

