/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Context;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.mailsender.MailSenderPlugin;
import com.xpn.xwiki.plugin.watchlist.WatchListPlugin;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Months;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class WatchListJob
implements Job {
    private static final Log LOG = LogFactory.getLog(WatchListPlugin.class);
    protected BaseObject xjob = null;
    protected XWikiContext context = null;
    protected WatchListPlugin plugin = null;
    protected int interval = 0;
    protected String jobMailTemplate;
    protected String logprefix;

    public void init(JobExecutionContext jobContext) throws XWikiException {
        JobDataMap data = jobContext.getJobDetail().getJobDataMap();
        this.context = (XWikiContext)data.get((java.lang.Object)"context");
        this.plugin = (WatchListPlugin)this.context.getWiki().getPlugin("watchlist", this.context);
        this.xjob = (BaseObject)data.get((java.lang.Object)"xjob");
        this.jobMailTemplate = this.xjob.getLargeStringValue("script").trim();
        this.interval = Integer.parseInt(this.xjob.getName().substring(this.xjob.getName().length() - 1));
        this.logprefix = "WatchList job " + this.context.getDatabase() + ":" + this.xjob.getName() + " ";
    }

    public void execute(JobExecutionContext jobContext) throws JobExecutionException {
        try {
            this.init(jobContext);
            List subscribers = this.retrieveNotificationSubscribers();
            if (subscribers != null && subscribers.size() > 0) {
                List updatedDocuments = this.retrieveUpdatedDocuments();
                LOG.info((java.lang.Object)(this.logprefix + "updatedDocumentsNumber : [" + updatedDocuments.size() + "]"));
                Iterator it = subscribers.iterator();
                while (it.hasNext()) {
                    try {
                        List matchingDocuments;
                        Document subscriber = new Document(this.context.getWiki().getDocument((String)it.next(), this.context), this.context);
                        Object userObj = subscriber.getObject("XWiki.XWikiUsers");
                        Object notificationCriteria = subscriber.getObject(WatchListPlugin.WATCHLIST_CLASS);
                        if (userObj == null || notificationCriteria == null || (matchingDocuments = this.filter(updatedDocuments, notificationCriteria, subscriber.getFullName())).size() <= 0) continue;
                        LOG.info((java.lang.Object)(this.logprefix + "matchingDocumentsForUser " + subscriber.getFullName() + ": [" + matchingDocuments.size() + "]"));
                        try {
                            this.sendNotificationMessage(subscriber, matchingDocuments);
                        }
                        catch (Exception e) {
                            LOG.error((java.lang.Object)(this.logprefix + "exception while sending email to " + subscriber.display("email", "view") + " with " + matchingDocuments.size() + " matching documents"));
                            e.printStackTrace();
                        }
                    }
                    catch (XWikiException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (XWikiException xWikiException) {
            // empty catch block
        }
    }

    private List filter(List updatedDocuments, Object notificationCriteria, String subscriber) throws XWikiException {
        String spaceCriterion = (String)notificationCriteria.display("spaces", "view");
        String documentCriterion = (String)notificationCriteria.display("documents", "view");
        String query = (String)notificationCriteria.display("query", "view");
        ArrayList<String> watchedDocuments = new ArrayList<String>();
        if (spaceCriterion.length() == 0 && documentCriterion.length() == 0 && query.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> filteredDocumentList = new ArrayList<String>();
        String[] watchedSpaces = spaceCriterion.split(",");
        String[] docArray = documentCriterion.split(",");
        for (int i = 0; i < docArray.length; ++i) {
            watchedDocuments.add(docArray[i]);
        }
        if (query.length() > 0) {
            List queryDocuments = this.plugin.globalSearchDocuments(query, 0, 0, new ArrayList(), this.context);
            watchedDocuments.addAll(queryDocuments);
        }
        block1: for (String updatedDocumentName : updatedDocuments) {
            Document updatedDocument = new Document(this.context.getWiki().getDocument(updatedDocumentName, this.context), this.context);
            String updatedDocumentSpace = updatedDocument.getWiki() + ":" + updatedDocument.getSpace();
            boolean documentAdded = false;
            for (int i = 0; i < watchedSpaces.length; ++i) {
                if (!updatedDocumentSpace.equals(watchedSpaces[i]) || !this.context.getWiki().getRightService().hasAccessLevel("view", subscriber, updatedDocumentName, this.context)) continue;
                filteredDocumentList.add(updatedDocumentName);
                documentAdded = true;
                break;
            }
            if (documentAdded) continue;
            for (String watchedDocumentName : watchedDocuments) {
                if (!updatedDocumentName.equals(watchedDocumentName) || !this.context.getWiki().getRightService().hasAccessLevel("view", subscriber, updatedDocumentName, this.context)) continue;
                filteredDocumentList.add(updatedDocumentName);
                continue block1;
            }
        }
        return filteredDocumentList;
    }

    protected List retrieveNotificationSubscribers() throws XWikiException {
        String request = ", BaseObject as obj, StringProperty as prop where obj.name=doc.fullName and obj.className='" + WatchListPlugin.WATCHLIST_CLASS + "' and prop.id.id=obj.id and prop.name='interval' " + "and prop.value='" + this.interval + "')";
        return this.plugin.globalSearchDocuments(request, 0, 0, new ArrayList(), this.context);
    }

    protected List retrieveUpdatedDocuments() throws XWikiException {
        DateTime dt = new DateTime();
        switch (this.interval) {
            case 1: {
                dt = dt.minus((ReadablePeriod)Hours.ONE);
                break;
            }
            case 2: {
                dt = dt.minus((ReadablePeriod)Days.ONE);
                break;
            }
            case 3: {
                dt = dt.minus((ReadablePeriod)Weeks.ONE);
                break;
            }
            case 4: {
                dt = dt.minus((ReadablePeriod)Months.ONE);
            }
        }
        ArrayList<Date> values = new ArrayList<Date>();
        values.add(dt.toDate());
        String updatedDocumentRequest = "where doc.date > ? order by doc.date desc";
        return this.plugin.globalSearchDocuments(updatedDocumentRequest, 0, 0, values, this.context);
    }

    protected void sendNotificationMessage(Document subscriber, List updatedDocuments) throws XWikiException {
        Object userObj = subscriber.getObject("XWiki.XWikiUsers");
        String emailAddr = (String)userObj.display("email", "view");
        if (emailAddr == null || emailAddr.length() == 0 || emailAddr.indexOf("@") < 0) {
            return;
        }
        VelocityContext vcontext = new VelocityContext();
        vcontext.put("pseudo", userObj.display("first_name", "view"));
        vcontext.put("documents", (java.lang.Object)updatedDocuments);
        vcontext.put("interval", (java.lang.Object)new Integer(this.interval));
        vcontext.put("xwiki", (java.lang.Object)new XWiki(this.context.getWiki(), this.context));
        vcontext.put("context", (java.lang.Object)new Context(this.context));
        String language = this.context.getWiki().getXWikiPreference("default_language", "en", this.context);
        MailSenderPlugin emailService = (MailSenderPlugin)this.context.getWiki().getPlugin("mailsender", this.context);
        if (emailService == null) {
            return;
        }
        String sender = this.context.getWiki().getXWikiPreference("admin_email", "mailer@xwiki.localdomain.com", this.context);
        String mailTemplate = "";
        mailTemplate = this.context.getWiki().exists(this.jobMailTemplate, this.context) ? this.jobMailTemplate : (this.context.getWiki().exists(WatchListPlugin.WATCHLIST_EMAIL_TEMPLATE, this.context) ? WatchListPlugin.WATCHLIST_EMAIL_TEMPLATE : this.context.getMainXWiki() + ":" + WatchListPlugin.WATCHLIST_EMAIL_TEMPLATE);
        emailService.sendMailFromTemplate(mailTemplate, sender, emailAddr, null, null, language, vcontext, this.context);
    }
}

