/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.watchlist.WatchListPlugin;
import java.util.ArrayList;
import java.util.List;

public class WatchListPluginApi
extends PluginApi {
    public WatchListPluginApi(WatchListPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
    }

    public boolean isDocInWatchedSpaces() throws XWikiException {
        return this.getWatchListPlugin().getWatchedSpaces(this.getXWikiContext().getUser(), this.getXWikiContext()).contains(this.context.getDatabase() + ":" + this.context.getDoc().getSpace());
    }

    public boolean isDocumentWatched() throws XWikiException {
        return this.getWatchListPlugin().getWatchedDocuments(this.context.getUser(), this.context).contains(this.context.getDatabase() + ":" + this.context.getDoc().getFullName());
    }

    public boolean addDocument(String wDoc) throws XWikiException {
        return this.getWatchListPlugin().addWatchedElement(this.getXWikiContext().getUser(), wDoc, false, this.getXWikiContext());
    }

    public boolean addDocumentForUser(String user, String wDoc) throws XWikiException {
        return this.context.getWiki().getUser(this.context).hasAdminRights() && this.getWatchListPlugin().addWatchedElement(user, wDoc, false, this.getXWikiContext());
    }

    public boolean removeDocument(String wDoc) throws XWikiException {
        return this.getWatchListPlugin().removeWatchedElement(this.getXWikiContext().getUser(), wDoc, false, this.getXWikiContext());
    }

    public boolean removeDocumentForUser(String user, String wDoc) throws XWikiException {
        return this.context.getWiki().getUser(this.context).hasAdminRights() && this.getWatchListPlugin().removeWatchedElement(user, wDoc, false, this.getXWikiContext());
    }

    public boolean isSpaceWatched() throws XWikiException {
        return this.getWatchListPlugin().getWatchedSpaces(this.context.getUser(), this.context).contains(this.context.getDatabase() + ":" + this.context.getDoc().getSpace());
    }

    public boolean addSpace(String wSpace) throws XWikiException {
        return this.getWatchListPlugin().addWatchedElement(this.getXWikiContext().getUser(), wSpace, true, this.getXWikiContext());
    }

    public boolean addSpaceForUser(String user, String wSpace) throws XWikiException {
        return this.context.getWiki().getUser(this.context).hasAdminRights() && this.getWatchListPlugin().addWatchedElement(user, wSpace, true, this.getXWikiContext());
    }

    public boolean removeSpace(String wSpace) throws XWikiException {
        return this.getWatchListPlugin().removeWatchedElement(this.getXWikiContext().getUser(), wSpace, true, this.getXWikiContext());
    }

    public boolean removeSpaceForUser(String user, String wSpace) throws XWikiException {
        return this.context.getWiki().getUser(this.context).hasAdminRights() && this.getWatchListPlugin().removeWatchedElement(user, wSpace, true, this.getXWikiContext());
    }

    public List getWatchedDocuments() throws XWikiException {
        return this.getWatchListPlugin().getWatchedDocuments(this.getXWikiContext().getUser(), this.context);
    }

    public List getWatchedSpaces() throws XWikiException {
        return this.getWatchListPlugin().getWatchedSpaces(this.getXWikiContext().getUser(), this.context);
    }

    public List getWatchedElements() throws XWikiException {
        ArrayList wEls = new ArrayList();
        wEls.addAll(this.getWatchedDocuments());
        wEls.addAll(this.getWatchedSpaces());
        return wEls;
    }

    public List getWatchListWhatsNew(String user) throws Exception {
        return this.getWatchListPlugin().getWatchListWhatsNew(user, this.context);
    }

    private WatchListPlugin getWatchListPlugin() {
        return (WatchListPlugin)this.getProtectedPlugin();
    }
}

