/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.test;

import com.xpn.xwiki.test.AntBuildListener;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;

public class XWikiTestSetup
extends TestSetup {
    private static final String EXECUTION_DIRECTORY = System.getProperty("xwikiExecutionDirectory");
    private static final String START_COMMAND = System.getProperty("xwikiExecutionStartCommand");
    private static final String STOP_COMMAND = System.getProperty("xwikiExecutionStopCommand");
    private static final String PORT = System.getProperty("xwikiPort", "8080");
    private static final boolean DEBUG = System.getProperty("debug", "false").equalsIgnoreCase("true");
    private static final int TIMEOUT_SECONDS = 120;
    private Project project = new Project();

    public XWikiTestSetup(Test test) {
        super(test);
        this.project.init();
        this.project.addBuildListener((BuildListener)new AntBuildListener(DEBUG));
    }

    protected void setUp() throws Exception {
        this.startXWikiInSeparateThread();
        this.waitForXWikiToLoad();
    }

    private void startXWikiInSeparateThread() {
        Thread startThread = new Thread(new Runnable(){

            public void run() {
                try {
                    XWikiTestSetup.this.startXWiki();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        startThread.start();
    }

    private void startXWiki() throws Exception {
        File dir = new File(EXECUTION_DIRECTORY);
        if (!dir.exists()) {
            throw new Exception("Invalid directory from where to start XWiki [" + EXECUTION_DIRECTORY + "]");
        }
        ExecTask execTask = (ExecTask)this.project.createTask("exec");
        execTask.setDir(new File(EXECUTION_DIRECTORY));
        Commandline commandLine = new Commandline(START_COMMAND);
        execTask.setCommand(commandLine);
        execTask.execute();
    }

    private Task createStopTask() throws Exception {
        File dir = new File(EXECUTION_DIRECTORY);
        if (!dir.exists()) {
            throw new Exception("Invalid directory from where to stop XWiki [" + EXECUTION_DIRECTORY + "]");
        }
        ExecTask execTask = (ExecTask)this.project.createTask("exec");
        execTask.setDir(new File(EXECUTION_DIRECTORY));
        Commandline commandLine = new Commandline(STOP_COMMAND);
        execTask.setCommand(commandLine);
        return execTask;
    }

    private void waitForXWikiToLoad() throws Exception {
        System.out.println("Checking that XWiki is up and running...");
        URL url = new URL("http://localhost:" + PORT + "/xwiki/bin/view/Main/WebHome");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        boolean connected = false;
        boolean timedOut = false;
        long startTime = System.currentTimeMillis();
        while (!connected && !timedOut) {
            try {
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (DEBUG) {
                    System.out.println("Result of pinging [" + url + "] = [" + responseCode + "], Message = [" + connection.getResponseMessage() + "]");
                }
                connected = responseCode < 400 || responseCode == 401;
            }
            catch (IOException e) {
                // empty catch block
            }
            Thread.sleep(100L);
            timedOut = System.currentTimeMillis() - startTime > 120000L;
        }
        if (timedOut) {
            String message = "Failed to start XWiki in [120] seconds";
            System.out.println(message);
            this.tearDown();
            throw new RuntimeException(message);
        }
    }

    protected void tearDown() throws Exception {
        this.createStopTask().execute();
    }
}

