/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.representations.comments;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.Representation;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.model.jaxb.Comment;
import org.xwiki.rest.model.jaxb.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="org.xwiki.rest.representations.comments.FormUrlEncodedCommentReader")
@Provider
@Consumes(value={"application/x-www-form-urlencoded"})
public class FormUrlEncodedCommentReader
implements MessageBodyReader<Comment>,
XWikiRestComponent {
    private static final String COMMENT_TEXT_FIELD_NAME = "text";
    private static final String COMMENT_REPLYTO_FIELD_NAME = "replyTo";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType) {
        return Comment.class.isAssignableFrom(type);
    }

    public Comment readFrom(Class<Comment> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ObjectFactory objectFactory = new ObjectFactory();
        Comment comment = objectFactory.createComment();
        HttpServletRequest httpServletRequest = (HttpServletRequest)Context.getCurrent().getAttributes().get("httpRequest");
        InputRepresentation representation = new InputRepresentation(entityStream, MediaType.APPLICATION_WWW_FORM);
        Form form = new Form((Representation)representation);
        if (form.getNames().isEmpty()) {
            try {
                comment.setReplyTo(Integer.parseInt(httpServletRequest.getParameter(COMMENT_REPLYTO_FIELD_NAME)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            comment.setText(httpServletRequest.getParameter(COMMENT_TEXT_FIELD_NAME));
        } else {
            try {
                comment.setReplyTo(Integer.parseInt(form.getFirstValue(COMMENT_REPLYTO_FIELD_NAME)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            comment.setText(form.getFirstValue(COMMENT_TEXT_FIELD_NAME));
        }
        return comment;
    }
}

