/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.objects;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.objects.BaseObject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Object;
import org.xwiki.rest.model.jaxb.Property;
import org.xwiki.rest.resources.objects.BaseObjectsResource;

@Component(value="org.xwiki.rest.resources.objects.ObjectResource")
@Path(value="/wikis/{wikiName}/spaces/{spaceName}/pages/{pageName}/objects/{className}/{objectNumber}")
public class ObjectResource
extends BaseObjectsResource {
    @GET
    public Object getObject(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @PathParam(value="className") String className, @PathParam(value="objectNumber") Integer objectNumber) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
        Document doc = documentInfo.getDocument();
        BaseObject baseObject = this.getBaseObject(doc, className, objectNumber);
        if (baseObject == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return DomainObjectFactory.createObject(this.objectFactory, this.uriInfo.getBaseUri(), Utils.getXWikiContext(this.componentManager), doc, baseObject, false);
    }

    @PUT
    public Response updateObject(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @PathParam(value="className") String className, @PathParam(value="objectNumber") Integer objectNumber, Object object) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
        Document doc = documentInfo.getDocument();
        if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        BaseObject baseObject = this.getBaseObject(doc, className, objectNumber);
        if (baseObject == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        for (Property property : object.getProperties()) {
            baseObject.set(property.getName(), (java.lang.Object)property.getValue(), Utils.getXWikiContext(this.componentManager));
        }
        doc.save();
        baseObject = this.getBaseObject(doc, className, objectNumber);
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((java.lang.Object)DomainObjectFactory.createObject(this.objectFactory, this.uriInfo.getBaseUri(), Utils.getXWikiContext(this.componentManager), doc, baseObject, false)).build();
    }

    @DELETE
    public void deleteObject(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @PathParam(value="className") String className, @PathParam(value="objectNumber") Integer objectNumber) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
        Document doc = documentInfo.getDocument();
        if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        BaseObject baseObject = this.getBaseObject(doc, className, objectNumber);
        if (baseObject == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        baseObject.getDocument(Utils.getXWikiContext(this.componentManager)).removeObject(baseObject);
        doc.save();
    }
}

