/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.gwt.api.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiLock;
import com.xpn.xwiki.gwt.api.client.Attachment;
import com.xpn.xwiki.gwt.api.client.Dictionary;
import com.xpn.xwiki.gwt.api.client.Document;
import com.xpn.xwiki.gwt.api.client.User;
import com.xpn.xwiki.gwt.api.client.VersionInfo;
import com.xpn.xwiki.gwt.api.client.XObject;
import com.xpn.xwiki.gwt.api.client.XWikiGWTException;
import com.xpn.xwiki.gwt.api.client.XWikiService;
import com.xpn.xwiki.gwt.api.server.XWikiRequestWrapper;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.render.XWikiVelocityRenderer;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiEngineContext;
import com.xpn.xwiki.web.XWikiMessageTool;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiServletContext;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiURLFactory;
import com.xpn.xwiki.xmlrpc.MockXWikiServletContext;
import com.xpn.xwiki.xmlrpc.XWikiXMLRPCResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XWikiServiceImpl
extends RemoteServiceServlet
implements XWikiService {
    private static final Log log = LogFactory.getLog((Class)(class$com$xpn$xwiki$XWiki == null ? (class$com$xpn$xwiki$XWiki = XWikiServiceImpl.class$("com.xpn.xwiki.XWiki")) : class$com$xpn$xwiki$XWiki));
    XWikiEngineContext engine;
    XWikiRequest request;
    XWikiResponse response;
    static /* synthetic */ Class class$com$xpn$xwiki$XWiki;

    public XWikiServiceImpl() {
    }

    public XWikiServiceImpl(XWikiRequest request, XWikiResponse response, XWikiEngineContext engine) {
        this.request = request;
        this.response = response;
        this.engine = engine;
    }

    protected XWikiContext getXWikiContext() throws XWikiException {
        XWikiUser user;
        if (this.engine == null) {
            ServletContext sContext = null;
            try {
                sContext = this.getServletContext();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            this.engine = sContext != null ? new XWikiServletContext(sContext) : new XWikiServletContext((ServletContext)new MockXWikiServletContext());
        }
        XWikiRequest request = this.request != null ? this.request : new XWikiServletRequest(this.getThreadLocalRequest());
        XWikiResponse response = this.response != null ? this.response : new XWikiXMLRPCResponse(this.getThreadLocalResponse());
        XWikiContext context = Utils.prepareContext((String)"", (XWikiRequest)request, (XWikiResponse)response, (XWikiEngineContext)this.engine);
        context.setMode(5);
        context.setDatabase("xwiki");
        XWiki xwiki = XWiki.getXWiki((XWikiContext)context);
        XWikiURLFactory urlf = xwiki.getURLFactoryService().createURLFactory(context.getMode(), context);
        context.setURLFactory(urlf);
        XWikiVelocityRenderer.prepareContext((XWikiContext)context);
        xwiki.prepareResources(context);
        String username = "XWiki.XWikiGuest";
        if (context.getMode() == 6) {
            username = "XWiki.superadmin";
        }
        if ((user = context.getWiki().checkAuth(context)) != null) {
            username = user.getUser();
        }
        context.setUser(username);
        if (context.getDoc() == null) {
            context.setDoc(new XWikiDocument("Fake", "Document"));
        }
        context.put("ajax", new Boolean(true));
        return context;
    }

    protected XWikiGWTException getXWikiGWTException(Exception e) {
        if (log.isErrorEnabled()) {
            log.error((Object)"Unhandled exception on the server", (Throwable)e);
        }
        if (e instanceof XWikiGWTException) {
            return (XWikiGWTException)e;
        }
        XWikiException exp = e instanceof XWikiException ? (XWikiException)e : new XWikiException(19, 0, "Unknown GWT Exception", (Throwable)e);
        return new XWikiGWTException(exp.getMessage(), exp.getFullMessage(), exp.getCode(), exp.getModule());
    }

    public Document getDocument(String fullName) throws XWikiGWTException {
        return this.getDocument(fullName, false, false, false, false);
    }

    public Document getDocument(String fullName, boolean full, boolean withRenderedContent) throws XWikiGWTException {
        return this.getDocument(fullName, full, false, false, withRenderedContent);
    }

    public String getUniquePageName(String space) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            return context.getWiki().getUniquePageName(space, context);
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public String getUniquePageName(String space, String pageName) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            return context.getWiki().getUniquePageName(space, pageName, context);
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public Document getUniqueDocument(String space, String pageName) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            String fullName = context.getWiki().getUniquePageName(space, pageName, context);
            return this.getDocument(fullName);
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public Document getUniqueDocument(String space) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            String fullName = context.getWiki().getUniquePageName(space, context);
            return this.getDocument(space + "." + fullName);
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public Document getDocument(String fullName, boolean full, boolean viewDisplayers, boolean editDisplayers) throws XWikiGWTException {
        return this.getDocument(fullName, full, viewDisplayers, editDisplayers, false);
    }

    public Document getDocument(String fullName, boolean full, boolean viewDisplayers, boolean editDisplayers, boolean withRenderedContent) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("view", context.getUser(), fullName, context)) {
                XWikiDocument doc = context.getWiki().getDocument(fullName, context);
                return this.newDocument(new Document(), doc, full, viewDisplayers, editDisplayers, withRenderedContent, context);
            }
            return null;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public Boolean deleteDocument(String docName) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("delete", context.getUser(), docName, context)) {
                XWikiDocument doc = context.getWiki().getDocument(docName, context);
                context.getWiki().deleteDocument(doc, context);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public int deleteDocuments(String sql) throws XWikiGWTException {
        int nb = 0;
        ArrayList newlist = new ArrayList();
        try {
            XWikiContext context = this.getXWikiContext();
            List list = context.getWiki().getStore().searchDocumentsNames(sql, context);
            if (list == null && list.size() == 0) {
                return nb;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (!context.getWiki().getRightService().hasAccessLevel("delete", context.getUser(), (String)list.get(i), context)) continue;
                XWikiDocument doc = context.getWiki().getDocument((String)list.get(i), context);
                context.getWiki().deleteDocument(doc, context);
                ++nb;
            }
            return nb;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public User getUser() throws XWikiGWTException {
        try {
            return this.getUser(this.getXWikiContext().getUser());
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public User getUser(String fullName) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("view", context.getUser(), fullName, context)) {
                XWikiDocument doc = context.getWiki().getDocument(fullName, context);
                return this.newUser(new User(), doc, context);
            }
            return null;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public User[] getUserList(int nb, int start) throws XWikiGWTException {
        User[] users = new User[nb];
        try {
            XWikiContext context = this.getXWikiContext();
            List list = this.searchDocuments(",BaseObject as obj where doc.fullName=obj.name and obj.className='XWiki.XWikiUsers'", nb, start, context);
            if (list == null) {
                return new User[0];
            }
            for (int i = 0; i < list.size(); ++i) {
                String username = (String)list.get(i);
                XWikiDocument userdoc = context.getWiki().getDocument(username, context);
                users[i] = this.newUser(new User(), userdoc, context);
            }
            return users;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public List searchDocuments(String sql, int nb, int start) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            return this.searchDocuments(sql, nb, start, context);
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public List getDocuments(String sql, int nb, int start) throws XWikiGWTException {
        return this.getDocuments(sql, nb, start, false);
    }

    public List getDocuments(String sql, int nb, int start, boolean full) throws XWikiGWTException {
        return this.getDocuments(sql, nb, start, full, false, false);
    }

    public List getDocuments(String sql, int nb, int start, boolean full, boolean viewDisplayers, boolean editDisplayers) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            return this.getDocuments(sql, nb, start, full, viewDisplayers, editDisplayers, false, context);
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public boolean updateProperty(String docname, String className, String propertyname, String value) throws XWikiGWTException {
        XWikiContext context = null;
        try {
            context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("edit", context.getUser(), docname, context)) {
                XWikiDocument doc = context.getWiki().getDocument(docname, context);
                doc.setStringValue(className, propertyname, value);
                context.getWiki().saveDocument(doc, context.getMessageTool().get("core.comment.updateProperty"), context);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public boolean updateProperty(String docname, String className, String propertyname, int value) throws XWikiGWTException {
        XWikiContext context = null;
        try {
            context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("edit", context.getUser(), docname, context)) {
                XWikiDocument doc = context.getWiki().getDocument(docname, context);
                doc.setIntValue(className, propertyname, value);
                context.getWiki().saveDocument(doc, context.getMessageTool().get("core.comment.updateProperty"), context);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public boolean updateProperty(String docname, String className, String propertyname, List value) throws XWikiGWTException {
        XWikiContext context = null;
        try {
            context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("edit", context.getUser(), docname, context)) {
                XWikiDocument doc = context.getWiki().getDocument(docname, context);
                BaseClass bclass = context.getWiki().getClass(className, context);
                ListClass lclass = (ListClass)(bclass == null ? null : bclass.get(propertyname));
                BaseProperty prop = lclass.fromValue((Object)value);
                doc.setProperty(className, propertyname, prop);
                context.getWiki().saveDocument(doc, context.getMessageTool().get("core.comment.updateProperty"), context);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    private List getDocuments(String sql, int nb, int start, boolean full, boolean viewDisplayers, boolean editDisplayers, XWikiContext context) throws XWikiGWTException {
        return this.getDocuments(sql, nb, start, full, viewDisplayers, editDisplayers, false, context);
    }

    private List getDocuments(String sql, int nb, int start, boolean full, boolean viewDisplayers, boolean editDisplayers, boolean withRenderedContent, XWikiContext context) throws XWikiGWTException {
        ArrayList<Document> newlist = new ArrayList<Document>();
        try {
            List list = context.getWiki().getStore().searchDocumentsNames(sql, nb, start, context);
            if (list == null && list.size() == 0) {
                return newlist;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (!context.getWiki().getRightService().hasAccessLevel("view", context.getUser(), (String)list.get(i), context)) continue;
                XWikiDocument doc = context.getWiki().getDocument((String)list.get(i), context);
                Document apidoc = this.newDocument(new Document(), doc, full, viewDisplayers, editDisplayers, withRenderedContent, context);
                newlist.add(apidoc);
            }
            return newlist;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    private List searchDocuments(String sql, int nb, int start, XWikiContext context) throws XWikiGWTException {
        ArrayList newlist = new ArrayList();
        try {
            List list = context.getWiki().getStore().searchDocumentsNames(sql, nb, start, context);
            if (list == null && list.size() == 0) {
                return newlist;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (!context.getWiki().getRightService().hasAccessLevel("view", context.getUser(), (String)list.get(i), context)) continue;
                newlist.add(list.get(i));
            }
            return newlist;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public List getObjects(String sql, String className, int nb, int start) throws XWikiGWTException {
        List docs = this.getDocuments(sql, nb, start, true);
        ArrayList objects = new ArrayList();
        Iterator it = docs.iterator();
        while (it.hasNext()) {
            Document doc = (Document)it.next();
            List docObjs = doc.getObjects(className);
            if (docObjs == null) continue;
            objects.addAll(docObjs);
        }
        return objects;
    }

    public XObject getFirstObject(String sql, String className) throws XWikiGWTException {
        List objs = this.getObjects(sql, className, 1, 0);
        if (objs != null && objs.size() > 0) {
            return (XObject)objs.get(0);
        }
        return null;
    }

    public XObject addObject(XWikiDocument doc, String className) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            int index = doc.createNewObject(className, context);
            return this.newObject(new XObject(), doc.getObject(className, index), false, false, context);
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public XObject addObject(String fullName, String className) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("edit", context.getUser(), fullName, context)) {
                XWikiDocument doc = context.getWiki().getDocument(fullName, context);
                XObject obj = this.addObject(doc, className);
                context.getWiki().saveDocument(doc, context.getMessageTool().get("core.comment.updateProperty"), context);
                return obj;
            }
            return null;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public List addObject(String fullName, List classesName) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            XWikiDocument doc = context.getWiki().getDocument(fullName, context);
            Iterator it = classesName.iterator();
            ArrayList<XObject> objs = new ArrayList<XObject>();
            while (it.hasNext()) {
                objs.add(this.addObject(doc, (String)it.next()));
            }
            context.getWiki().saveDocument(doc, context.getMessageTool().get("core.comment.addObject"), context);
            return objs;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public boolean addObject(String docname, XObject xobject) throws XWikiGWTException {
        XWikiContext context = null;
        try {
            context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("edit", context.getUser(), docname, context)) {
                XWikiDocument doc = context.getWiki().getDocument(docname, context);
                BaseObject newObject = doc.newObject(xobject.getClassName(), context);
                this.mergeObject(xobject, newObject, context);
                context.getWiki().saveDocument(doc, context.getMessageTool().get("core.comment.addObject"), context);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public Boolean saveDocumentContent(String fullName, String content) throws XWikiGWTException {
        return this.saveDocumentContent(fullName, content, null);
    }

    public Boolean saveDocumentContent(String fullName, String content, String comment) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("edit", context.getUser(), fullName, context)) {
                XWikiDocument doc = context.getWiki().getDocument(fullName, context);
                doc.setContent(content);
                doc.setAuthor(context.getUser());
                if (doc.isNew()) {
                    doc.setCreator(context.getUser());
                }
                context.getWiki().saveDocument(doc, comment == null ? context.getMessageTool().get("core.comment.updateContent") : comment, context);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public Boolean saveObject(XObject object) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("edit", context.getUser(), object.getName(), context)) {
                XWikiDocument doc = context.getWiki().getDocument(object.getName(), context);
                BaseObject bObject = this.newBaseObject(doc.getObject(object.getClassName(), object.getNumber()), object, context);
                doc.setObject(object.getClassName(), object.getNumber(), bObject);
                doc.setAuthor(context.getUser());
                if (doc.isNew()) {
                    doc.setCreator(context.getUser());
                }
                context.getWiki().saveDocument(doc, context.getMessageTool().get("core.comment.updateObject"), context);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public Boolean deleteObject(XObject object) throws XWikiGWTException {
        return this.deleteObject(object.getName(), object.getClassName(), object.getNumber());
    }

    public Boolean deleteObject(String docName, String className, int number) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("edit", context.getUser(), docName, context)) {
                BaseObject bObj;
                XWikiDocument doc = context.getWiki().getDocument(docName, context);
                if (!doc.removeObject(bObj = doc.getObject(className, number))) {
                    return false;
                }
                doc.setAuthor(context.getUser());
                if (doc.isNew()) {
                    doc.setCreator(context.getUser());
                }
                context.getWiki().saveDocument(doc, context.getMessageTool().get("core.comment.deleteObject"), context);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public Boolean saveObjects(List objects) throws XWikiGWTException {
        Iterator it = objects.iterator();
        boolean error = false;
        while (it.hasNext()) {
            error |= this.saveObject((XObject)it.next()) == false;
        }
        return !error;
    }

    public Boolean lockDocument(String fullName, boolean force) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            XWikiDocument doc = context.getWiki().getDocument(fullName, context);
            if (context.getWiki().getRightService().hasAccessLevel("edit", context.getUser(), fullName, context)) {
                XWikiLock lock = doc.getLock(context);
                if (lock == null || lock.getUserName().equals(context.getUser()) || force) {
                    if (lock != null) {
                        doc.removeLock(context);
                    }
                    doc.setLock(context.getUser(), context);
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public void unlockDocument(String fullName) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            XWikiDocument doc = context.getWiki().getDocument(fullName, context);
            XWikiLock lock = doc.getLock(context);
            if (lock != null) {
                doc.removeLock(context);
            }
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public Boolean isLastDocumentVersion(String fullName, String version) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            return context.getWiki().getDocument(fullName, context).getVersion().equals(version);
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public String getLoginURL() throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            return context.getWiki().getDocument("XWiki.XWikiLogin", context).getExternalURL("login", context);
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public String login(String username, String password, boolean rememberme) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            XWikiUser user = context.getWiki().getAuthService().checkAuth(username, password, rememberme ? "yes" : "no", context);
            if (user == null) {
                return "XWiki.XWikiGuest";
            }
            return user.getUser();
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public boolean addComment(String docname, String message) throws XWikiGWTException {
        XWikiContext context = null;
        try {
            context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("comment", context.getUser(), docname, context)) {
                XWikiDocument doc = context.getWiki().getDocument(docname, context);
                BaseObject newObject = doc.newObject("XWiki.XWikiComments", context);
                newObject.set("author", (Object)context.getUser(), context);
                newObject.set("date", (Object)new Date(), context);
                newObject.set("comment", (Object)message, context);
                doc.setContentDirty(false);
                context.getWiki().saveDocument(doc, context.getMessageTool().get("core.comment.addComment"), context);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public List customQuery(String queryPage) throws XWikiGWTException {
        return this.customQuery(queryPage, null, 0, 0);
    }

    public List customQuery(String queryPage, Map params) throws XWikiGWTException {
        return this.customQuery(queryPage, params, 0, 0);
    }

    public List customQuery(String queryPage, int nb, int start) throws XWikiGWTException {
        return this.customQuery(queryPage, null, nb, start);
    }

    public List customQuery(String queryPage, Map params, int nb, int start) throws XWikiGWTException {
        ArrayList newlist = new ArrayList();
        try {
            XWikiContext context = this.getXWikiContext();
            XWikiDocument queryDoc = context.getWiki().getDocument(queryPage, context);
            if (context.getWiki().getRightService().hasProgrammingRights(queryDoc, context)) {
                if (params != null) {
                    XWikiRequestWrapper srw = new XWikiRequestWrapper(context.getRequest());
                    Iterator it = params.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        Object value = params.get(key);
                        if (key instanceof String) {
                            params.put(key, ((String)value).replaceAll("'", ""));
                            continue;
                        }
                        params.remove(key);
                    }
                    srw.setParameterMap(params);
                    context.setRequest((XWikiRequest)srw);
                }
                List list = context.getWiki().getStore().search(queryDoc.getRenderedContent(context), nb, start, context);
                for (int i = 0; i < list.size(); ++i) {
                    Object[] item = (Object[])list.get(i);
                    ArrayList<Object> itemlist = new ArrayList<Object>();
                    for (int j = 0; j < item.length; ++j) {
                        itemlist.add(item[j]);
                    }
                    newlist.add(itemlist);
                }
                return newlist;
            }
            return null;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    protected User newUser(User user, XWikiDocument xdoc, XWikiContext context) throws XWikiGWTException {
        this.newDocument(user, xdoc, context);
        user.setFirstName(xdoc.getStringValue("XWiki.XWikiUsers", "first_name"));
        user.setLastName(xdoc.getStringValue("XWiki.XWikiUsers", "last_name"));
        user.setEmail(xdoc.getStringValue("XWiki.XWikiUsers", "email"));
        XWiki xwiki = context.getWiki();
        user.setAdmin(xwiki.getRightService().hasAdminRights(context));
        return user;
    }

    protected Document newDocument(Document doc, XWikiDocument xdoc, XWikiContext context) throws XWikiGWTException {
        return this.newDocument(doc, xdoc, false, context);
    }

    protected Document newDocument(Document doc, XWikiDocument xdoc, boolean withObjects, XWikiContext context) throws XWikiGWTException {
        return this.newDocument(doc, xdoc, withObjects, false, false, false, context);
    }

    public boolean hasAccessLevel(String level, String fullName, XWikiContext context) throws XWikiGWTException {
        try {
            return this.getXWikiContext().getWiki().getRightService().hasAccessLevel(level, context.getUser(), fullName, context);
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    protected void assertEditRight(XWikiDocument doc, XWikiContext context) throws XWikiGWTException, XWikiException {
        if (context.getMode() == 6) {
            return;
        }
        if (!this.hasAccessLevel("edit", doc.getFullName(), context)) {
            this.raiseRightException(context);
        }
    }

    protected void assertViewRight(String fullName, XWikiContext context) throws XWikiGWTException, XWikiException {
        if (context.getMode() == 6) {
            return;
        }
        if (!this.hasAccessLevel("view", fullName, context)) {
            this.raiseRightException(context);
        }
    }

    protected void raiseRightException(XWikiContext context) throws XWikiException {
        if (context.getUser().equals("XWiki.XWikiGuest")) {
            throw new XWikiException(9, 9002, "User needs to be logged-in");
        }
        throw new XWikiException(9, 9001, "User needs appropriate rights");
    }

    protected void assertViewRight(XWikiDocument doc, XWikiContext context) throws XWikiGWTException, XWikiException {
        this.assertViewRight(doc.getFullName(), context);
    }

    protected Document newDocument(Document doc, XWikiDocument xdoc, boolean withObjects, boolean withViewDisplayers, boolean withEditDisplayers, boolean withRenderedContent, XWikiContext context) throws XWikiGWTException {
        Iterator<Object> it;
        doc.setId(xdoc.getId());
        doc.setTitle(xdoc.getTitle());
        doc.setFullName(xdoc.getFullName());
        doc.setParent(xdoc.getParent());
        doc.setSpace(xdoc.getSpace());
        doc.setName(xdoc.getName());
        doc.setContent(xdoc.getContent());
        doc.setMeta(xdoc.getMeta());
        doc.setFormat(xdoc.getFormat());
        doc.setCreator(xdoc.getCreator());
        doc.setAuthor(xdoc.getAuthor());
        doc.setContentAuthor(xdoc.getContentAuthor());
        doc.setCustomClass(xdoc.getCustomClass());
        doc.setVersion(xdoc.getVersion());
        doc.setContentUpdateDate(xdoc.getContentUpdateDate().getTime());
        doc.setDate(xdoc.getDate().getTime());
        doc.setCreationDate(xdoc.getCreationDate().getTime());
        doc.setMostRecent(xdoc.isMostRecent());
        doc.setNew(xdoc.isNew());
        doc.setTemplate(xdoc.getTemplate());
        doc.setLanguage(xdoc.getLanguage());
        doc.setDefaultLanguage(xdoc.getDefaultLanguage());
        doc.setTranslation(xdoc.getTranslation());
        doc.setComment(xdoc.getComment());
        Vector comments = xdoc.getComments();
        doc.setCommentsNumber(comments == null ? 0 : comments.size());
        doc.setUploadURL(xdoc.getExternalURL("upload", "ajax=1", context));
        doc.setViewURL(xdoc.getExternalURL("view", context));
        try {
            doc.setSaveURL(context.getWiki().getExternalURL(xdoc.getFullName(), "save", "ajax=1", context));
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
        doc.setHasElement(xdoc.getElements());
        try {
            doc.setEditRight(context.getWiki().getRightService().hasAccessLevel("edit", context.getUser(), xdoc.getFullName(), context));
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
        try {
            doc.setCommentRight(context.getWiki().getRightService().hasAccessLevel("comment", context.getUser(), xdoc.getFullName(), context));
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
        if (withObjects) {
            it = xdoc.getxWikiObjects().values().iterator();
            while (it.hasNext()) {
                List list = (List)it.next();
                for (int i = 0; i < list.size(); ++i) {
                    BaseObject bobj = (BaseObject)list.get(i);
                    if (bobj == null) continue;
                    XObject obj = this.newObject(new XObject(), bobj, withViewDisplayers, withEditDisplayers, context);
                    doc.addObject(bobj.getClassName(), obj);
                }
            }
        }
        if (xdoc.getAttachmentList() != null && xdoc.getAttachmentList().size() > 0) {
            it = xdoc.getAttachmentList().iterator();
            while (it.hasNext()) {
                XWikiAttachment xAtt = (XWikiAttachment)it.next();
                Attachment att = this.newAttachment(new Attachment(), xAtt, context);
                doc.addAttachments(att);
            }
        }
        if (withRenderedContent) {
            try {
                doc.setRenderedContent(xdoc.getRenderedContent(context));
            }
            catch (Exception e) {
                throw this.getXWikiGWTException(e);
            }
        }
        return doc;
    }

    protected Attachment newAttachment(Attachment att, XWikiAttachment xAtt, XWikiContext context) {
        att.setAttDate(xAtt.getDate().getTime());
        att.setAuthor(xAtt.getAuthor());
        att.setFilename(xAtt.getFilename());
        att.setId(xAtt.getId());
        att.setImage(xAtt.isImage(context));
        att.setMimeType(xAtt.getMimeType(context));
        att.setFilesize(xAtt.getFilesize());
        att.setDownloadUrl(context.getWiki().getExternalAttachmentURL(xAtt.getDoc().getFullName(), xAtt.getFilename(), context));
        return att;
    }

    protected XObject newObject(XObject xObject, BaseObject baseObject, boolean withViewDisplayers, boolean withEditDisplayers, XWikiContext context) {
        xObject.setName(baseObject.getName());
        xObject.setNumber(baseObject.getNumber());
        xObject.setClassName(baseObject.getClassName());
        String prefix = baseObject.getxWikiClass(context).getName() + "_" + baseObject.getNumber() + "_";
        Object[] propnames = baseObject.getxWikiClass(context).getFieldList().toArray();
        for (int i = 0; i < propnames.length; ++i) {
            String propname = ((PropertyInterface)propnames[i]).getName();
            if (propname.equals("fullcontent")) continue;
            try {
                BaseProperty prop = (BaseProperty)baseObject.get(propname);
                if (prop != null) {
                    Object value = prop.getValue();
                    if (value instanceof Date) {
                        xObject.set(propname, new Date(((Date)prop.getValue()).getTime()));
                    } else if (value instanceof List) {
                        ArrayList newlist = new ArrayList();
                        for (int j = 0; j < ((List)value).size(); ++j) {
                            newlist.add(((List)value).get(j));
                        }
                        xObject.set(propname, newlist);
                    } else {
                        xObject.set(propname, prop.getValue());
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (withViewDisplayers) {
                    xObject.setViewProperty(propname, baseObject.displayView(propname, prefix, context));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (!withEditDisplayers) continue;
                xObject.setEditProperty(propname, baseObject.displayEdit(propname, prefix, context));
                xObject.setEditPropertyFieldName(propname, prefix + propname);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return xObject;
    }

    protected void mergeObject(XObject xobject, BaseObject baseObject, XWikiContext context) {
        BaseClass bclass = baseObject.getxWikiClass(context);
        Object[] propnames = bclass.getPropertyNames();
        for (int i = 0; i < propnames.length; ++i) {
            String propname = (String)propnames[i];
            Object propdata = xobject.getProperty(propname);
            baseObject.set(propname, propdata, context);
        }
    }

    public String getDocumentContent(String fullName) throws XWikiGWTException {
        return this.getDocumentContent(fullName, false, null);
    }

    protected BaseObject newBaseObject(BaseObject baseObject, XObject xObject, XWikiContext context) throws XWikiException {
        if (baseObject == null) {
            baseObject = (BaseObject)context.getWiki().getClass(xObject.getClassName(), context).newObject(context);
            baseObject.setName(xObject.getName());
            baseObject.setNumber(xObject.getNumber());
        }
        Object[] propnames = xObject.getPropertyNames().toArray();
        for (int i = 0; i < propnames.length; ++i) {
            String propname = (String)propnames[i];
            try {
                baseObject.set(propname, xObject.get(propname), context);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return baseObject;
    }

    public String getDocumentContent(String fullName, boolean rendered) throws XWikiGWTException {
        return this.getDocumentContent(fullName, rendered, null);
    }

    public String getDocumentContent(String fullName, boolean rendered, Map params) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("view", context.getUser(), fullName, context)) {
                XWikiDocument doc = context.getWiki().getDocument(fullName, context);
                context.setDoc(doc);
                if (!rendered) {
                    return doc.getContent();
                }
                XWikiRequestWrapper srw = new XWikiRequestWrapper(context.getRequest());
                srw.setParameterMap(params);
                context.setRequest((XWikiRequest)srw);
                return doc.getRenderedContent(context);
            }
            return null;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public List getDocumentVersions(String fullName, int nb, int start) throws XWikiGWTException {
        try {
            ArrayList<VersionInfo> versionsList = new ArrayList<VersionInfo>();
            XWikiContext context = this.getXWikiContext();
            if (context.getWiki().getRightService().hasAccessLevel("view", context.getUser(), fullName, context)) {
                int j;
                XWikiDocument doc = context.getWiki().getDocument(fullName, context);
                String[] versions = nb == 0 ? doc.getRecentRevisions(0, context) : doc.getRecentRevisions(nb + start, context);
                int nbVersions = nb == 0 ? versions.length - start : nb;
                for (int i = 0; i < nbVersions && (j = i + start) < versions.length; ++i) {
                    String version = versions[j];
                    XWikiDocument vdoc = null;
                    try {
                        vdoc = context.getWiki().getDocument(doc, version, context);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (vdoc != null) {
                        String authorLink = context.getWiki().getURL(vdoc.getAuthor(), "view", context);
                        String author = context.getWiki().getLocalUserName(vdoc.getAuthor(), null, false, context);
                        versionsList.add(new VersionInfo(version, vdoc.getDate().getTime(), author, authorLink, vdoc.getComment()));
                        continue;
                    }
                    versionsList.add(new VersionInfo(version, 0L, "?", "?", "?"));
                }
                return versionsList;
            }
            return versionsList;
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    public void logJSError(Map infos) {
        log.warn((Object)("[GWT-JS] useragent:" + infos.get("useragent") + "\n" + "module:" + infos.get("module") + "\n"));
    }

    public Dictionary getTranslation(String translationPage, String locale) throws XWikiGWTException {
        try {
            XWikiContext context = this.getXWikiContext();
            XWikiMessageTool msg = context.getMessageTool();
            XWikiDocument docBundle = context.getWiki().getDocument(translationPage, context);
            docBundle = docBundle.getTranslatedDocument(context);
            Properties encproperties = msg == null ? null : msg.getDocumentBundleProperties(docBundle);
            Properties properties = new Properties();
            Iterator it = ((Hashtable)encproperties).keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = encproperties.getProperty(key);
                String newvalue = new String(value.getBytes(), "UTF-8");
                properties.setProperty(key, newvalue);
            }
            if (properties == null) {
                return new Dictionary();
            }
            return new Dictionary((Map)properties);
        }
        catch (Exception e) {
            throw this.getXWikiGWTException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

