/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package com.xpn.xwiki.wysiwyg.client.plugin.internal;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.ui.UIObject;
import com.xpn.xwiki.wysiwyg.client.plugin.UIExtension;

/**
 * Aggregates many {@link UIExtension} objects that have the same role.
 */
public class CompositeUIExtension implements UIExtension
{
    private final List<UIExtension> extensions;

    private final String role;

    public CompositeUIExtension(String role)
    {
        this.role = role;
        extensions = new ArrayList<UIExtension>();
    }

    /**
     * {@inheritDoc}
     * 
     * @see UIExtension#getFeatures()
     */
    public String[] getFeatures()
    {
        final List<String> allFeatures = new ArrayList<String>();
        for (UIExtension uie : extensions) {
            String[] features = uie.getFeatures();
            if (features == null) {
                continue;
            }
            for (int i = 0; i < features.length; i++) {
                allFeatures.add(features[i]);
            }
        }
        return allFeatures.toArray(new String[allFeatures.size()]);
    }

    /**
     * {@inheritDoc}
     * 
     * @see UIExtension#getRole()
     */
    public String getRole()
    {
        return role;
    }

    /**
     * {@inheritDoc}
     * 
     * @see UIExtension#getUIObject(String)
     */
    public UIObject getUIObject(String feature)
    {
        for (UIExtension uie : extensions) {
            UIObject uiObject = uie.getUIObject(feature);
            if (uiObject != null) {
                return uiObject;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     * 
     * @see UIExtension#isEnabled(String)
     */
    public boolean isEnabled(String feature)
    {
        boolean enabled = false;
        for (UIExtension uie : extensions) {
            enabled = enabled || uie.isEnabled(feature);
        }
        return enabled;
    }

    /**
     * {@inheritDoc}
     * 
     * @see UIExtension#setEnabled(String, boolean)
     */
    public void setEnabled(String feature, boolean enabled)
    {
        for (UIExtension uie : extensions) {
            uie.setEnabled(feature, enabled);
        }
    }

    public void addUIExtension(UIExtension uie)
    {
        if (role.equals(uie.getRole())) {
            extensions.add(uie);
        }
    }

    public void removeUIExtension(UIExtension uie)
    {
        extensions.remove(uie);
    }
}
