package com.xpn.xwiki.wysiwyg.client.plugin.internal;

/**
 * An user interface extension that cannot be enabled or disabled.
 * 
 * @version $Id: StatelessUIExtension.java 19241 2009-04-30 21:32:32Z mflorea $
 */
public class StatelessUIExtension extends AbstractUIExtension
{
    /**
     * Creates a new state less UI extension.
     * 
     * @param role the name of the extension point where the newly created UI extension fits
     */
    public StatelessUIExtension(String role)
    {
        super(role);
    }

    /**
     * {@inheritDoc}
     * 
     * @see AbstractUIExtension#isEnabled(String)
     */
    public boolean isEnabled(String feature)
    {
        return true;
    }

    /**
     * {@inheritDoc}
     * 
     * @see AbstractUIExtension#setEnabled(String, boolean)
     */
    public void setEnabled(String feature, boolean enabled)
    {
        // ignore
    }
}
