/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package com.xpn.xwiki.wysiwyg.client.util;

/**
 * Represents a combination of keyboard keys that could trigger a specific action.
 * 
 * @version $Id: ShortcutKey.java 20039 2009-05-16 12:04:30Z sdumitriu $
 */
public class ShortcutKey
{
    /**
     * The unicode character that was generated by the keyboard action.
     * {@link com.google.gwt.user.client.ui.KeyboardListener#KEY_UP} is such an example.
     */
    private final int keyCode;

    /**
     * The modifier keys pressed at when the event occurred. This value is a combination of the bits defined by
     * {@link com.google.gwt.user.client.ui.KeyboardListener#MODIFIER_SHIFT},
     * {@link com.google.gwt.user.client.ui.KeyboardListener#MODIFIER_CTRL},
     * {@link com.google.gwt.user.client.ui.KeyboardListener#MODIFIER_ALT}, and
     * {@link com.google.gwt.user.client.ui.KeyboardListener#MODIFIER_META}
     */
    private final int modifiers;

    /**
     * We store the hash code of this object so we don't have to compute it many times.
     */
    private final int hashCode;

    /**
     * Creates a new shortcut key.
     * 
     * @param keyCode the Unicode character that was generated by the keyboard action.
     * @param modifiers the modifier keys pressed at when the event occurred. This value is a combination of the bits
     *            defined by {@link com.google.gwt.user.client.ui.KeyboardListener#MODIFIER_SHIFT},
     *            {@link com.google.gwt.user.client.ui.KeyboardListener#MODIFIER_CTRL},
     *            {@link com.google.gwt.user.client.ui.KeyboardListener#MODIFIER_ALT}, and
     *            {@link com.google.gwt.user.client.ui.KeyboardListener#MODIFIER_META}
     */
    public ShortcutKey(int keyCode, int modifiers)
    {
        this.keyCode = keyCode;
        this.modifiers = modifiers;

        final int prime = 31;
        int thisHashCode = 1;
        thisHashCode = prime * thisHashCode + keyCode;
        thisHashCode = prime * thisHashCode + modifiers;
        this.hashCode = thisHashCode;
    }

    /**
     * @return {@link #keyCode}
     */
    public int getKeyCode()
    {
        return keyCode;
    }

    /**
     * @return {@link #modifiers}
     */
    public int getModifiers()
    {
        return modifiers;
    }

    /**
     * {@inheritDoc}
     * 
     * @see Object#hashCode()
     */
    public int hashCode()
    {
        return hashCode;
    }

    /**
     * {@inheritDoc}
     * 
     * @see Object#equals(Object)
     */
    public boolean equals(Object obj)
    {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ShortcutKey)) {
            return false;
        }
        final ShortcutKey other = (ShortcutKey) obj;
        return keyCode == other.keyCode && modifiers == other.modifiers;
    }
}
